/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.commons.lang3.concurrent;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.concurrent.BackgroundInitializer;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.concurrent.ConcurrentException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;

public class MultiBackgroundInitializer
extends BackgroundInitializer<MultiBackgroundInitializerResults> {
    private final Map<String, BackgroundInitializer<?>> childInitializers = new HashMap();

    public MultiBackgroundInitializer() {
    }

    public MultiBackgroundInitializer(ExecutorService executorService) {
        super(executorService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInitializer(String string, BackgroundInitializer<?> backgroundInitializer) {
        Objects.requireNonNull(string, "name");
        Objects.requireNonNull(backgroundInitializer, "backgroundInitializer");
        MultiBackgroundInitializer multiBackgroundInitializer = this;
        synchronized (multiBackgroundInitializer) {
            if (this.isStarted()) {
                throw new IllegalStateException("addInitializer() must not be called after start()!");
            }
            this.childInitializers.put(string, backgroundInitializer);
        }
    }

    @Override
    public void close() throws ConcurrentException {
        ConcurrentException concurrentException = null;
        for (BackgroundInitializer<?> backgroundInitializer : this.childInitializers.values()) {
            try {
                backgroundInitializer.close();
            }
            catch (Exception exception) {
                Throwables.throwIfCritical(exception);
                Exception exception2 = exception;
                if (concurrentException == null) {
                    concurrentException = new ConcurrentException();
                }
                if (exception2 instanceof ConcurrentException) {
                    concurrentException.addSuppressed(exception2.getCause());
                    continue;
                }
                concurrentException.addSuppressed(exception2);
            }
        }
        if (concurrentException != null) {
            throw concurrentException;
        }
    }

    @Override
    protected int getTaskCount() {
        return 1 + this.childInitializers.values().stream().mapToInt(BackgroundInitializer::getTaskCount).sum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected MultiBackgroundInitializerResults initialize() throws Exception {
        HashMap hashMap;
        Object object = this;
        synchronized (object) {
            hashMap = new HashMap(this.childInitializers);
        }
        object = this.getActiveExecutor();
        hashMap.values().forEach(arg_0 -> MultiBackgroundInitializer.lambda$initialize$0((ExecutorService)object, arg_0));
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        hashMap.forEach((string, backgroundInitializer) -> {
            try {
                hashMap2.put(string, backgroundInitializer.get());
            }
            catch (ConcurrentException concurrentException) {
                hashMap3.put(string, concurrentException);
            }
        });
        return new MultiBackgroundInitializerResults(hashMap, hashMap2, hashMap3);
    }

    @Override
    public boolean isInitialized() {
        if (this.childInitializers.isEmpty()) {
            return false;
        }
        return this.childInitializers.values().stream().allMatch(BackgroundInitializer::isInitialized);
    }

    private static /* synthetic */ void lambda$initialize$0(ExecutorService executorService, BackgroundInitializer backgroundInitializer) {
        if (backgroundInitializer.getExternalExecutor() == null) {
            backgroundInitializer.setExternalExecutor(executorService);
        }
        backgroundInitializer.start();
    }

    public static class MultiBackgroundInitializerResults {
        private final Map<String, BackgroundInitializer<?>> initializers;
        private final Map<String, Object> resultObjects;
        private final Map<String, ConcurrentException> exceptions;

        private MultiBackgroundInitializerResults(Map<String, BackgroundInitializer<?>> map, Map<String, Object> map2, Map<String, ConcurrentException> map3) {
            this.initializers = map;
            this.resultObjects = map2;
            this.exceptions = map3;
        }

        private BackgroundInitializer<?> checkName(String string) {
            BackgroundInitializer<?> backgroundInitializer = this.initializers.get(string);
            if (backgroundInitializer == null) {
                throw new NoSuchElementException("No child initializer with name " + string);
            }
            return backgroundInitializer;
        }

        public ConcurrentException getException(String string) {
            this.checkName(string);
            return this.exceptions.get(string);
        }

        public BackgroundInitializer<?> getInitializer(String string) {
            return this.checkName(string);
        }

        public Object getResultObject(String string) {
            this.checkName(string);
            return this.resultObjects.get(string);
        }

        public Set<String> initializerNames() {
            return Collections.unmodifiableSet(this.initializers.keySet());
        }

        public boolean isException(String string) {
            this.checkName(string);
            return this.exceptions.containsKey(string);
        }

        public boolean isSuccessful() {
            return this.exceptions.isEmpty();
        }
    }
}

