/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.commons.lang3.reflect;

import com.contrastsecurity.thirdparty.oa4j.commons.lang3.ArrayUtils;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.ClassUtils;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.JavaVersion;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.StringUtils;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.SystemUtils;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.Validate;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.reflect.MemberUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class FieldUtils {
    public static Field[] getAllFields(Class<?> clazz) {
        return FieldUtils.getAllFieldsList(clazz).toArray(ArrayUtils.EMPTY_FIELD_ARRAY);
    }

    public static List<Field> getAllFieldsList(Class<?> clazz) {
        Objects.requireNonNull(clazz, "cls");
        ArrayList<Field> arrayList = new ArrayList<Field>();
        for (Class<?> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            Field[] fieldArray = clazz2.getDeclaredFields();
            Collections.addAll(arrayList, fieldArray);
        }
        return arrayList;
    }

    public static Field getDeclaredField(Class<?> clazz, String string) {
        return FieldUtils.getDeclaredField(clazz, string, false);
    }

    public static Field getDeclaredField(Class<?> clazz, String string, boolean bl2) {
        Objects.requireNonNull(clazz, "cls");
        Validate.isTrue(StringUtils.isNotBlank(string), "The field name must not be blank/empty", new Object[0]);
        try {
            Field field = clazz.getDeclaredField(string);
            if (!MemberUtils.isAccessible(field)) {
                if (!bl2) {
                    return null;
                }
                field.setAccessible(true);
            }
            return field;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    public static Field getField(Class<?> clazz, String string) {
        return MemberUtils.setAccessibleWorkaround(FieldUtils.getField(clazz, string, false));
    }

    public static Field getField(Class<?> clazz, String string, boolean bl2) {
        AnnotatedElement annotatedElement;
        Objects.requireNonNull(clazz, "cls");
        Validate.isTrue(StringUtils.isNotBlank(string), "The field name must not be blank/empty", new Object[0]);
        for (annotatedElement = clazz; annotatedElement != null; annotatedElement = annotatedElement.getSuperclass()) {
            try {
                Field field = annotatedElement.getDeclaredField(string);
                if (!MemberUtils.isPublic(field)) {
                    if (!bl2) continue;
                    field.setAccessible(true);
                }
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        annotatedElement = null;
        for (Class clazz2 : ClassUtils.getAllInterfaces(clazz)) {
            try {
                Field field = clazz2.getField(string);
                Validate.isTrue(annotatedElement == null, "Reference to field %s is ambiguous relative to %s; a matching field exists on two or more implemented interfaces.", string, clazz);
                annotatedElement = field;
            }
            catch (NoSuchFieldException noSuchFieldException) {}
        }
        return annotatedElement;
    }

    public static List<Field> getFieldsListWithAnnotation(Class<?> clazz, Class<? extends Annotation> clazz2) {
        Objects.requireNonNull(clazz2, "annotationCls");
        return FieldUtils.getAllFieldsList(clazz).stream().filter(field -> field.getAnnotation(clazz2) != null).collect(Collectors.toList());
    }

    public static Field[] getFieldsWithAnnotation(Class<?> clazz, Class<? extends Annotation> clazz2) {
        return FieldUtils.getFieldsListWithAnnotation(clazz, clazz2).toArray(ArrayUtils.EMPTY_FIELD_ARRAY);
    }

    public static Object readDeclaredField(Object object, String string) throws IllegalAccessException {
        return FieldUtils.readDeclaredField(object, string, false);
    }

    public static Object readDeclaredField(Object object, String string, boolean bl2) throws IllegalAccessException {
        Objects.requireNonNull(object, "target");
        Class<?> clazz = object.getClass();
        Field field = FieldUtils.getDeclaredField(clazz, string, bl2);
        Validate.isTrue(field != null, "Cannot locate declared field %s.%s", clazz, string);
        return FieldUtils.readField(field, object, false);
    }

    public static Object readDeclaredStaticField(Class<?> clazz, String string) throws IllegalAccessException {
        return FieldUtils.readDeclaredStaticField(clazz, string, false);
    }

    public static Object readDeclaredStaticField(Class<?> clazz, String string, boolean bl2) throws IllegalAccessException {
        Field field = FieldUtils.getDeclaredField(clazz, string, bl2);
        Validate.notNull(field, "Cannot locate declared field %s.%s", clazz.getName(), string);
        return FieldUtils.readStaticField(field, false);
    }

    public static Object readField(Field field, Object object) throws IllegalAccessException {
        return FieldUtils.readField(field, object, false);
    }

    public static Object readField(Field field, Object object, boolean bl2) throws IllegalAccessException {
        Objects.requireNonNull(field, "field");
        if (bl2 && !field.isAccessible()) {
            field.setAccessible(true);
        } else {
            MemberUtils.setAccessibleWorkaround(field);
        }
        return field.get(object);
    }

    public static Object readField(Object object, String string) throws IllegalAccessException {
        return FieldUtils.readField(object, string, false);
    }

    public static Object readField(Object object, String string, boolean bl2) throws IllegalAccessException {
        Objects.requireNonNull(object, "target");
        Class<?> clazz = object.getClass();
        Field field = FieldUtils.getField(clazz, string, bl2);
        Validate.isTrue(field != null, "Cannot locate field %s on %s", string, clazz);
        return FieldUtils.readField(field, object, false);
    }

    public static Object readStaticField(Class<?> clazz, String string) throws IllegalAccessException {
        return FieldUtils.readStaticField(clazz, string, false);
    }

    public static Object readStaticField(Class<?> clazz, String string, boolean bl2) throws IllegalAccessException {
        Field field = FieldUtils.getField(clazz, string, bl2);
        Validate.notNull(field, "Cannot locate field '%s' on %s", string, clazz);
        return FieldUtils.readStaticField(field, false);
    }

    public static Object readStaticField(Field field) throws IllegalAccessException {
        return FieldUtils.readStaticField(field, false);
    }

    public static Object readStaticField(Field field, boolean bl2) throws IllegalAccessException {
        Objects.requireNonNull(field, "field");
        Validate.isTrue(MemberUtils.isStatic(field), "The field '%s' is not static", field.getName());
        return FieldUtils.readField(field, null, bl2);
    }

    public static void removeFinalModifier(Field field) {
        FieldUtils.removeFinalModifier(field, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void removeFinalModifier(Field field, boolean bl2) {
        block7: {
            Objects.requireNonNull(field, "field");
            try {
                boolean bl3;
                if (!Modifier.isFinal(field.getModifiers())) break block7;
                Field field2 = Field.class.getDeclaredField("modifiers");
                boolean bl4 = bl3 = bl2 && !field2.isAccessible();
                if (bl3) {
                    field2.setAccessible(true);
                }
                try {
                    field2.setInt(field, field.getModifiers() & 0xFFFFFFEF);
                }
                finally {
                    if (bl3) {
                        field2.setAccessible(false);
                    }
                }
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                if (!SystemUtils.isJavaVersionAtLeast(JavaVersion.JAVA_12)) break block7;
                throw new UnsupportedOperationException("In java 12+ final cannot be removed.", reflectiveOperationException);
            }
        }
    }

    public static void writeDeclaredField(Object object, String string, Object object2) throws IllegalAccessException {
        FieldUtils.writeDeclaredField(object, string, object2, false);
    }

    public static void writeDeclaredField(Object object, String string, Object object2, boolean bl2) throws IllegalAccessException {
        Objects.requireNonNull(object, "target");
        Class<?> clazz = object.getClass();
        Field field = FieldUtils.getDeclaredField(clazz, string, bl2);
        Validate.isTrue(field != null, "Cannot locate declared field %s.%s", clazz.getName(), string);
        FieldUtils.writeField(field, object, object2, false);
    }

    public static void writeDeclaredStaticField(Class<?> clazz, String string, Object object) throws IllegalAccessException {
        FieldUtils.writeDeclaredStaticField(clazz, string, object, false);
    }

    public static void writeDeclaredStaticField(Class<?> clazz, String string, Object object, boolean bl2) throws IllegalAccessException {
        Field field = FieldUtils.getDeclaredField(clazz, string, bl2);
        Validate.notNull(field, "Cannot locate declared field %s.%s", clazz.getName(), string);
        FieldUtils.writeField(field, null, object, false);
    }

    public static void writeField(Field field, Object object, Object object2) throws IllegalAccessException {
        FieldUtils.writeField(field, object, object2, false);
    }

    public static void writeField(Field field, Object object, Object object2, boolean bl2) throws IllegalAccessException {
        Objects.requireNonNull(field, "field");
        if (bl2 && !field.isAccessible()) {
            field.setAccessible(true);
        } else {
            MemberUtils.setAccessibleWorkaround(field);
        }
        field.set(object, object2);
    }

    public static void writeField(Object object, String string, Object object2) throws IllegalAccessException {
        FieldUtils.writeField(object, string, object2, false);
    }

    public static void writeField(Object object, String string, Object object2, boolean bl2) throws IllegalAccessException {
        Objects.requireNonNull(object, "target");
        Class<?> clazz = object.getClass();
        Field field = FieldUtils.getField(clazz, string, bl2);
        Validate.isTrue(field != null, "Cannot locate declared field %s.%s", clazz.getName(), string);
        FieldUtils.writeField(field, object, object2, false);
    }

    public static void writeStaticField(Class<?> clazz, String string, Object object) throws IllegalAccessException {
        FieldUtils.writeStaticField(clazz, string, object, false);
    }

    public static void writeStaticField(Class<?> clazz, String string, Object object, boolean bl2) throws IllegalAccessException {
        Field field = FieldUtils.getField(clazz, string, bl2);
        Validate.notNull(field, "Cannot locate field %s on %s", string, clazz);
        FieldUtils.writeStaticField(field, object, false);
    }

    public static void writeStaticField(Field field, Object object) throws IllegalAccessException {
        FieldUtils.writeStaticField(field, object, false);
    }

    public static void writeStaticField(Field field, Object object, boolean bl2) throws IllegalAccessException {
        Objects.requireNonNull(field, "field");
        Validate.isTrue(MemberUtils.isStatic(field), "The field %s.%s is not static", field.getDeclaringClass().getName(), field.getName());
        FieldUtils.writeField(field, null, object, bl2);
    }

    @Deprecated
    public FieldUtils() {
    }
}

