/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.http.impl.conn;

import com.contrastsecurity.thirdparty.oa4j.http.HttpHost;
import com.contrastsecurity.thirdparty.oa4j.http.annotation.Contract;
import com.contrastsecurity.thirdparty.oa4j.http.annotation.ThreadingBehavior;
import com.contrastsecurity.thirdparty.oa4j.http.conn.SchemePortResolver;
import com.contrastsecurity.thirdparty.oa4j.http.conn.UnsupportedSchemeException;
import com.contrastsecurity.thirdparty.oa4j.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultSchemePortResolver
implements SchemePortResolver {
    public static final DefaultSchemePortResolver INSTANCE = new DefaultSchemePortResolver();

    @Override
    public int resolve(HttpHost httpHost) throws UnsupportedSchemeException {
        Args.notNull(httpHost, "HTTP host");
        int n2 = httpHost.getPort();
        if (n2 > 0) {
            return n2;
        }
        String string = httpHost.getSchemeName();
        if (string.equalsIgnoreCase("http")) {
            return 80;
        }
        if (string.equalsIgnoreCase("https")) {
            return 443;
        }
        throw new UnsupportedSchemeException(string + " protocol is not supported");
    }
}

