/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.http.impl.cookie;

import com.contrastsecurity.thirdparty.oa4j.http.annotation.Contract;
import com.contrastsecurity.thirdparty.oa4j.http.annotation.ThreadingBehavior;
import com.contrastsecurity.thirdparty.oa4j.http.cookie.CommonCookieAttributeHandler;
import com.contrastsecurity.thirdparty.oa4j.http.cookie.MalformedCookieException;
import com.contrastsecurity.thirdparty.oa4j.http.cookie.SetCookie;
import com.contrastsecurity.thirdparty.oa4j.http.impl.cookie.AbstractCookieAttributeHandler;
import com.contrastsecurity.thirdparty.oa4j.http.util.Args;
import com.contrastsecurity.thirdparty.oa4j.http.util.TextUtils;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class LaxMaxAgeHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    private static final Pattern MAX_AGE_PATTERN = Pattern.compile("^\\-?[0-9]+$");

    @Override
    public void parse(SetCookie setCookie, String string) throws MalformedCookieException {
        Args.notNull(setCookie, "Cookie");
        if (TextUtils.isBlank(string)) {
            return;
        }
        Matcher matcher = MAX_AGE_PATTERN.matcher(string);
        if (matcher.matches()) {
            int n2;
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            Date date = n2 >= 0 ? new Date(System.currentTimeMillis() + (long)n2 * 1000L) : new Date(Long.MIN_VALUE);
            setCookie.setExpiryDate(date);
        }
    }

    @Override
    public String getAttributeName() {
        return "max-age";
    }
}

