/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.http.impl.io;

import com.contrastsecurity.thirdparty.oa4j.http.Consts;
import com.contrastsecurity.thirdparty.oa4j.http.impl.io.HttpTransportMetricsImpl;
import com.contrastsecurity.thirdparty.oa4j.http.io.BufferInfo;
import com.contrastsecurity.thirdparty.oa4j.http.io.HttpTransportMetrics;
import com.contrastsecurity.thirdparty.oa4j.http.io.SessionOutputBuffer;
import com.contrastsecurity.thirdparty.oa4j.http.params.HttpParams;
import com.contrastsecurity.thirdparty.oa4j.http.util.Args;
import com.contrastsecurity.thirdparty.oa4j.http.util.ByteArrayBuffer;
import com.contrastsecurity.thirdparty.oa4j.http.util.CharArrayBuffer;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

@Deprecated
public abstract class AbstractSessionOutputBuffer
implements BufferInfo,
SessionOutputBuffer {
    private static final byte[] CRLF = new byte[]{13, 10};
    private OutputStream outStream;
    private ByteArrayBuffer buffer;
    private Charset charset;
    private boolean ascii;
    private int minChunkLimit;
    private HttpTransportMetricsImpl metrics;
    private CodingErrorAction onMalformedCharAction;
    private CodingErrorAction onUnmappableCharAction;
    private CharsetEncoder encoder;
    private ByteBuffer bbuf;

    protected AbstractSessionOutputBuffer(OutputStream outputStream, int n2, Charset charset, int n3, CodingErrorAction codingErrorAction, CodingErrorAction codingErrorAction2) {
        Args.notNull(outputStream, "Input stream");
        Args.notNegative(n2, "Buffer size");
        this.outStream = outputStream;
        this.buffer = new ByteArrayBuffer(n2);
        this.charset = charset != null ? charset : Consts.ASCII;
        this.ascii = this.charset.equals(Consts.ASCII);
        this.encoder = null;
        this.minChunkLimit = n3 >= 0 ? n3 : 512;
        this.metrics = this.createTransportMetrics();
        this.onMalformedCharAction = codingErrorAction != null ? codingErrorAction : CodingErrorAction.REPORT;
        this.onUnmappableCharAction = codingErrorAction2 != null ? codingErrorAction2 : CodingErrorAction.REPORT;
    }

    public AbstractSessionOutputBuffer() {
    }

    protected void init(OutputStream outputStream, int n2, HttpParams httpParams) {
        Args.notNull(outputStream, "Input stream");
        Args.notNegative(n2, "Buffer size");
        Args.notNull(httpParams, "HTTP parameters");
        this.outStream = outputStream;
        this.buffer = new ByteArrayBuffer(n2);
        String string = (String)httpParams.getParameter("http.protocol.element-charset");
        this.charset = string != null ? Charset.forName(string) : Consts.ASCII;
        this.ascii = this.charset.equals(Consts.ASCII);
        this.encoder = null;
        this.minChunkLimit = httpParams.getIntParameter("http.connection.min-chunk-limit", 512);
        this.metrics = this.createTransportMetrics();
        CodingErrorAction codingErrorAction = (CodingErrorAction)httpParams.getParameter("http.malformed.input.action");
        this.onMalformedCharAction = codingErrorAction != null ? codingErrorAction : CodingErrorAction.REPORT;
        CodingErrorAction codingErrorAction2 = (CodingErrorAction)httpParams.getParameter("http.unmappable.input.action");
        this.onUnmappableCharAction = codingErrorAction2 != null ? codingErrorAction2 : CodingErrorAction.REPORT;
    }

    protected HttpTransportMetricsImpl createTransportMetrics() {
        return new HttpTransportMetricsImpl();
    }

    @Override
    public int capacity() {
        return this.buffer.capacity();
    }

    @Override
    public int length() {
        return this.buffer.length();
    }

    @Override
    public int available() {
        return this.capacity() - this.length();
    }

    protected void flushBuffer() throws IOException {
        int n2 = this.buffer.length();
        if (n2 > 0) {
            this.outStream.write(this.buffer.buffer(), 0, n2);
            this.buffer.clear();
            this.metrics.incrementBytesTransferred(n2);
        }
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        this.outStream.flush();
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        if (byArray == null) {
            return;
        }
        if (n3 > this.minChunkLimit || n3 > this.buffer.capacity()) {
            this.flushBuffer();
            this.outStream.write(byArray, n2, n3);
            this.metrics.incrementBytesTransferred(n3);
        } else {
            int n4 = this.buffer.capacity() - this.buffer.length();
            if (n3 > n4) {
                this.flushBuffer();
            }
            this.buffer.append(byArray, n2, n3);
        }
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        if (byArray == null) {
            return;
        }
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(int n2) throws IOException {
        if (this.buffer.isFull()) {
            this.flushBuffer();
        }
        this.buffer.append(n2);
    }

    @Override
    public void writeLine(String string) throws IOException {
        if (string == null) {
            return;
        }
        if (string.length() > 0) {
            if (this.ascii) {
                for (int i2 = 0; i2 < string.length(); ++i2) {
                    this.write(string.charAt(i2));
                }
            } else {
                CharBuffer charBuffer = CharBuffer.wrap(string);
                this.writeEncoded(charBuffer);
            }
        }
        this.write(CRLF);
    }

    @Override
    public void writeLine(CharArrayBuffer charArrayBuffer) throws IOException {
        if (charArrayBuffer == null) {
            return;
        }
        if (this.ascii) {
            int n2;
            int n3 = 0;
            for (int i2 = charArrayBuffer.length(); i2 > 0; i2 -= n2) {
                n2 = this.buffer.capacity() - this.buffer.length();
                if ((n2 = Math.min(n2, i2)) > 0) {
                    this.buffer.append(charArrayBuffer, n3, n2);
                }
                if (this.buffer.isFull()) {
                    this.flushBuffer();
                }
                n3 += n2;
            }
        } else {
            CharBuffer charBuffer = CharBuffer.wrap(charArrayBuffer.buffer(), 0, charArrayBuffer.length());
            this.writeEncoded(charBuffer);
        }
        this.write(CRLF);
    }

    private void writeEncoded(CharBuffer charBuffer) throws IOException {
        CoderResult coderResult;
        if (!charBuffer.hasRemaining()) {
            return;
        }
        if (this.encoder == null) {
            this.encoder = this.charset.newEncoder();
            this.encoder.onMalformedInput(this.onMalformedCharAction);
            this.encoder.onUnmappableCharacter(this.onUnmappableCharAction);
        }
        if (this.bbuf == null) {
            this.bbuf = ByteBuffer.allocate(1024);
        }
        this.encoder.reset();
        while (charBuffer.hasRemaining()) {
            coderResult = this.encoder.encode(charBuffer, this.bbuf, true);
            this.handleEncodingResult(coderResult);
        }
        coderResult = this.encoder.flush(this.bbuf);
        this.handleEncodingResult(coderResult);
        this.bbuf.clear();
    }

    private void handleEncodingResult(CoderResult coderResult) throws IOException {
        if (coderResult.isError()) {
            coderResult.throwException();
        }
        this.bbuf.flip();
        while (this.bbuf.hasRemaining()) {
            this.write(this.bbuf.get());
        }
        this.bbuf.compact();
    }

    @Override
    public HttpTransportMetrics getMetrics() {
        return this.metrics;
    }
}

