/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j;

import com.contrastsecurity.thirdparty.oa4j.logging.log4j.spi.StandardLevel;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.Strings;
import java.io.Serializable;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class Level
implements Serializable,
Comparable<Level> {
    private static final Level[] EMPTY_ARRAY = new Level[0];
    private static final ConcurrentMap<String, Level> LEVELS = new ConcurrentHashMap<String, Level>();
    public static final Level OFF = new Level("OFF", StandardLevel.OFF.intLevel());
    public static final Level FATAL = new Level("FATAL", StandardLevel.FATAL.intLevel());
    public static final Level ERROR = new Level("ERROR", StandardLevel.ERROR.intLevel());
    public static final Level WARN = new Level("WARN", StandardLevel.WARN.intLevel());
    public static final Level INFO = new Level("INFO", StandardLevel.INFO.intLevel());
    public static final Level DEBUG = new Level("DEBUG", StandardLevel.DEBUG.intLevel());
    public static final Level TRACE = new Level("TRACE", StandardLevel.TRACE.intLevel());
    public static final Level ALL = new Level("ALL", StandardLevel.ALL.intLevel());
    public static final String CATEGORY = "Level";
    private static final long serialVersionUID = 1581082L;
    private final String name;
    private final int intLevel;
    private final StandardLevel standardLevel;

    private Level(String string, int n2) {
        if (Strings.isEmpty(string)) {
            throw new IllegalArgumentException("Illegal null or empty Level name.");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Illegal Level int less than zero.");
        }
        this.name = string;
        this.intLevel = n2;
        this.standardLevel = StandardLevel.getStandardLevel(n2);
        if (LEVELS.putIfAbsent(Level.toUpperCase(string.trim()), this) != null) {
            throw new IllegalStateException("Level " + string + " has already been defined.");
        }
    }

    public int intLevel() {
        return this.intLevel;
    }

    public StandardLevel getStandardLevel() {
        return this.standardLevel;
    }

    public boolean isInRange(Level level, Level level2) {
        return this.intLevel >= level.intLevel && this.intLevel <= level2.intLevel;
    }

    public boolean isLessSpecificThan(Level level) {
        return this.intLevel >= level.intLevel;
    }

    public boolean isMoreSpecificThan(Level level) {
        return this.intLevel <= level.intLevel;
    }

    public Level clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public int compareTo(Level level) {
        return this.intLevel < level.intLevel ? -1 : (this.intLevel > level.intLevel ? 1 : 0);
    }

    public boolean equals(Object object) {
        return object instanceof Level && object == this;
    }

    public Class<Level> getDeclaringClass() {
        return Level.class;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public static Level forName(String string, int n2) {
        if (Strings.isEmpty(string)) {
            throw new IllegalArgumentException("Illegal null or empty Level name.");
        }
        String string2 = Level.toUpperCase(string.trim());
        Level level = (Level)LEVELS.get(string2);
        if (level != null) {
            return level;
        }
        try {
            return new Level(string, n2);
        }
        catch (IllegalStateException illegalStateException) {
            return (Level)LEVELS.get(string2);
        }
    }

    public static Level getLevel(String string) {
        if (Strings.isEmpty(string)) {
            throw new IllegalArgumentException("Illegal null or empty Level name.");
        }
        return (Level)LEVELS.get(Level.toUpperCase(string.trim()));
    }

    public static Level toLevel(String string) {
        return Level.toLevel(string, DEBUG);
    }

    public static Level toLevel(String string, Level level) {
        if (string == null) {
            return level;
        }
        Level level2 = (Level)LEVELS.get(Level.toUpperCase(string.trim()));
        return level2 == null ? level : level2;
    }

    private static String toUpperCase(String string) {
        return string.toUpperCase(Locale.ENGLISH);
    }

    public static Level[] values() {
        return LEVELS.values().toArray(EMPTY_ARRAY);
    }

    public static Level valueOf(String string) {
        Objects.requireNonNull(string, "No level name given.");
        String string2 = Level.toUpperCase(string.trim());
        Level level = (Level)LEVELS.get(string2);
        if (level != null) {
            return level;
        }
        throw new IllegalArgumentException("Unknown level constant [" + string2 + "].");
    }

    public static <T extends Enum<T>> T valueOf(Class<T> clazz, String string) {
        return Enum.valueOf(clazz, string);
    }

    protected Object readResolve() {
        return Level.valueOf(this.name);
    }
}

