/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.impl;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.pattern.JAnsiTextRenderer;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.pattern.PlainTextRenderer;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.pattern.TextRenderer;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Integers;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Loader;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Patterns;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.status.StatusLogger;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public final class ThrowableFormatOptions {
    private static final int DEFAULT_LINES = Integer.MAX_VALUE;
    protected static final ThrowableFormatOptions DEFAULT = new ThrowableFormatOptions();
    private static final String FULL = "full";
    private static final String NONE = "none";
    private static final String SHORT = "short";
    private final TextRenderer textRenderer;
    private final int lines;
    private final String separator;
    private final String suffix;
    private final List<String> ignorePackages;
    public static final String CLASS_NAME = "short.className";
    public static final String METHOD_NAME = "short.methodName";
    public static final String LINE_NUMBER = "short.lineNumber";
    public static final String FILE_NAME = "short.fileName";
    public static final String MESSAGE = "short.message";
    public static final String LOCALIZED_MESSAGE = "short.localizedMessage";

    protected ThrowableFormatOptions(int n2, String string, List<String> list, TextRenderer textRenderer, String string2) {
        this.lines = n2;
        this.separator = string == null ? Strings.LINE_SEPARATOR : string;
        this.ignorePackages = list;
        this.textRenderer = textRenderer == null ? PlainTextRenderer.getInstance() : textRenderer;
        this.suffix = string2;
    }

    protected ThrowableFormatOptions(List<String> list) {
        this(Integer.MAX_VALUE, null, list, null, null);
    }

    protected ThrowableFormatOptions() {
        this(Integer.MAX_VALUE, null, null, null, null);
    }

    public int getLines() {
        return this.lines;
    }

    public String getSeparator() {
        return this.separator;
    }

    public TextRenderer getTextRenderer() {
        return this.textRenderer;
    }

    public List<String> getIgnorePackages() {
        return this.ignorePackages;
    }

    public boolean allLines() {
        return this.lines == Integer.MAX_VALUE;
    }

    public boolean anyLines() {
        return this.lines > 0;
    }

    public int minLines(int n2) {
        return this.lines > n2 ? n2 : this.lines;
    }

    public boolean hasPackages() {
        return this.ignorePackages != null && !this.ignorePackages.isEmpty();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{').append(this.allLines() ? FULL : (this.lines == 2 ? SHORT : (this.anyLines() ? String.valueOf(this.lines) : NONE))).append('}');
        stringBuilder.append("{separator(").append(this.separator).append(")}");
        if (this.hasPackages()) {
            stringBuilder.append("{filters(");
            for (String string : this.ignorePackages) {
                stringBuilder.append(string).append(',');
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            stringBuilder.append(")}");
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ThrowableFormatOptions newInstance(String[] stringArray) {
        Object object;
        Object object2;
        ArrayList<String> arrayList;
        String string;
        block33: {
            if (stringArray == null) return DEFAULT;
            if (stringArray.length == 0) {
                return DEFAULT;
            }
            if (stringArray.length == 1 && Strings.isNotEmpty(stringArray[0])) {
                block34: {
                    String[] stringArray2 = stringArray[0].split(Patterns.COMMA_SEPARATOR, 2);
                    string = stringArray2[0].trim();
                    arrayList = new Scanner(string);
                    object2 = null;
                    try {
                        if (stringArray2.length > 1 && (string.equalsIgnoreCase(FULL) || string.equalsIgnoreCase(SHORT) || string.equalsIgnoreCase(NONE) || ((Scanner)((Object)arrayList)).hasNextInt())) {
                            stringArray = new String[]{string, stringArray2[1].trim()};
                        }
                        if (arrayList == null) break block33;
                        if (object2 == null) break block34;
                    }
                    catch (Throwable throwable) {
                        try {
                            Throwables.throwIfCritical(throwable);
                            Throwable throwable2 = throwable;
                            object2 = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (arrayList == null) throw throwable3;
                            if (object2 == null) {
                                ((Scanner)((Object)arrayList)).close();
                                throw throwable3;
                            }
                            try {
                                ((Scanner)((Object)arrayList)).close();
                                throw throwable3;
                            }
                            catch (Throwable throwable2) {
                                Throwables.throwIfCritical(throwable2);
                                Throwable throwable5 = throwable2;
                                ((Throwable)object2).addSuppressed(throwable5);
                                throw throwable3;
                            }
                        }
                    }
                    try {
                        ((Scanner)((Object)arrayList)).close();
                    }
                    catch (Throwable throwable) {
                        Throwables.throwIfCritical(throwable);
                        object = throwable;
                        ((Throwable)object2).addSuppressed((Throwable)object);
                    }
                    break block33;
                }
                ((Scanner)((Object)arrayList)).close();
            }
        }
        int n2 = ThrowableFormatOptions.DEFAULT.lines;
        string = ThrowableFormatOptions.DEFAULT.separator;
        arrayList = ThrowableFormatOptions.DEFAULT.ignorePackages;
        object2 = ThrowableFormatOptions.DEFAULT.textRenderer;
        object = DEFAULT.getSuffix();
        String[] stringArray2 = stringArray;
        int n3 = stringArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            String string4;
            String string2 = stringArray2[n4];
            if (string2 != null && !(string4 = string2.trim()).isEmpty()) {
                String string3;
                if (string4.startsWith("separator(") && string4.endsWith(")")) {
                    string = string4.substring("separator(".length(), string4.length() - 1);
                } else if (string4.startsWith("filters(") && string4.endsWith(")")) {
                    String[] stringArray3;
                    string3 = string4.substring("filters(".length(), string4.length() - 1);
                    if (string3.length() > 0 && (stringArray3 = string3.split(Patterns.COMMA_SEPARATOR)).length > 0) {
                        arrayList = new ArrayList<String>(stringArray3.length);
                        for (String string5 : stringArray3) {
                            if ((string5 = string5.trim()).length() <= 0) continue;
                            arrayList.add(string5);
                        }
                    }
                } else if (string4.equalsIgnoreCase(NONE)) {
                    n2 = 0;
                } else if (string4.equalsIgnoreCase(SHORT) || string4.equalsIgnoreCase(CLASS_NAME) || string4.equalsIgnoreCase(METHOD_NAME) || string4.equalsIgnoreCase(LINE_NUMBER) || string4.equalsIgnoreCase(FILE_NAME) || string4.equalsIgnoreCase(MESSAGE) || string4.equalsIgnoreCase(LOCALIZED_MESSAGE)) {
                    n2 = 2;
                } else if (string4.startsWith("ansi(") && string4.endsWith(")") || string4.equals("ansi")) {
                    if (Loader.isJansiAvailable()) {
                        string3 = string4.equals("ansi") ? "" : string4.substring("ansi(".length(), string4.length() - 1);
                        object2 = new JAnsiTextRenderer(new String[]{null, string3}, JAnsiTextRenderer.DefaultExceptionStyleMap);
                    } else {
                        StatusLogger.getLogger().warn("You requested ANSI exception rendering but JANSI is not on the classpath. Please see https://logging.apache.org/log4j/2.x/runtime-dependencies.html");
                    }
                } else if (string4.startsWith("S(") && string4.endsWith(")")) {
                    object = string4.substring("S(".length(), string4.length() - 1);
                } else if (string4.startsWith("suffix(") && string4.endsWith(")")) {
                    object = string4.substring("suffix(".length(), string4.length() - 1);
                } else if (!string4.equalsIgnoreCase(FULL)) {
                    n2 = Integers.parseInt(string4);
                }
            }
            ++n4;
        }
        return new ThrowableFormatOptions(n2, string, (List<String>)arrayList, (TextRenderer)object2, (String)object);
    }

    public String getSuffix() {
        return this.suffix;
    }
}

