/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.net;

import com.contrastsecurity.thirdparty.oa4j.logging.log4j.Level;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.net.Facility;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.net.Severity;

public class Priority {
    private final Facility facility;
    private final Severity severity;

    public Priority(Facility facility, Severity severity) {
        this.facility = facility;
        this.severity = severity;
    }

    public static int getPriority(Facility facility, Level level) {
        return Priority.toPriority(facility, Severity.getSeverity(level));
    }

    private static int toPriority(Facility facility, Severity severity) {
        return (facility.getCode() << 3) + severity.getCode();
    }

    public Facility getFacility() {
        return this.facility;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public int getValue() {
        return Priority.toPriority(this.facility, this.severity);
    }

    public String toString() {
        return Integer.toString(this.getValue());
    }
}

