/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.pattern;

import com.contrastsecurity.thirdparty.oa4j.logging.log4j.Logger;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.PluginAttribute;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.PluginFactory;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.status.StatusLogger;
import java.util.regex.Pattern;

@Plugin(name="replace", category="Core", printObject=true)
public final class RegexReplacement {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final Pattern pattern;
    private final String substitution;

    private RegexReplacement(Pattern pattern, String string) {
        this.pattern = pattern;
        this.substitution = string;
    }

    public String format(String string) {
        return this.pattern.matcher(string).replaceAll(this.substitution);
    }

    public String toString() {
        return "replace(regex=" + this.pattern.pattern() + ", replacement=" + this.substitution + ')';
    }

    @PluginFactory
    public static RegexReplacement createRegexReplacement(@PluginAttribute(value="regex") Pattern pattern, @PluginAttribute(value="replacement") String string) {
        if (pattern == null) {
            LOGGER.error("A regular expression is required for replacement");
            return null;
        }
        if (string == null) {
            LOGGER.error("A replacement string is required to perform replacement");
        }
        return new RegexReplacement(pattern, string);
    }
}

