/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.util;

import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.BiConsumer;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.PropertySource;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;

public class PropertiesPropertySource
implements PropertySource {
    private static final int DEFAULT_PRIORITY = 200;
    private static final String PREFIX = "com.contrastsecurity.thirdparty.log4j2.";
    private final Properties properties;
    private final int priority;

    public PropertiesPropertySource(Properties properties) {
        this(properties, 200);
    }

    public PropertiesPropertySource(Properties properties, int n2) {
        this.properties = properties;
        this.priority = n2;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void forEach(BiConsumer<String, String> biConsumer) {
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            biConsumer.accept((String)entry.getKey(), (String)entry.getValue());
        }
    }

    @Override
    public CharSequence getNormalForm(Iterable<? extends CharSequence> iterable) {
        CharSequence charSequence = PropertySource.Util.joinAsCamelCase(iterable);
        return charSequence.length() > 0 ? PREFIX + charSequence : null;
    }

    @Override
    public Collection<String> getPropertyNames() {
        return this.properties.stringPropertyNames();
    }

    @Override
    public String getProperty(String string) {
        return this.properties.getProperty(string);
    }

    @Override
    public boolean containsProperty(String string) {
        return this.getProperty(string) != null;
    }
}

