/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.ojt.queues.atomic;

import com.contrastsecurity.thirdparty.ojt.queues.MessagePassingQueue;
import com.contrastsecurity.thirdparty.ojt.queues.atomic.AtomicQueueUtil;
import com.contrastsecurity.thirdparty.ojt.queues.atomic.SpscAtomicArrayQueueL3Pad;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class SpscAtomicArrayQueue<E>
extends SpscAtomicArrayQueueL3Pad<E> {
    public SpscAtomicArrayQueue(int n2) {
        super(Math.max(n2, 4));
    }

    @Override
    public boolean offer(E e2) {
        if (null == e2) {
            throw new NullPointerException();
        }
        AtomicReferenceArray atomicReferenceArray = this.buffer;
        int n2 = this.mask;
        long l2 = this.lpProducerIndex();
        if (l2 >= this.producerLimit && !this.offerSlowPath(atomicReferenceArray, n2, l2)) {
            return false;
        }
        int n3 = AtomicQueueUtil.calcCircularRefElementOffset(l2, n2);
        AtomicQueueUtil.soRefElement(atomicReferenceArray, n3, e2);
        this.soProducerIndex(l2 + 1L);
        return true;
    }

    private boolean offerSlowPath(AtomicReferenceArray<E> atomicReferenceArray, int n2, long l2) {
        int n3 = this.lookAheadStep;
        if (null == AtomicQueueUtil.lvRefElement(atomicReferenceArray, AtomicQueueUtil.calcCircularRefElementOffset(l2 + (long)n3, n2))) {
            this.producerLimit = l2 + (long)n3;
        } else {
            int n4 = AtomicQueueUtil.calcCircularRefElementOffset(l2, n2);
            if (null != AtomicQueueUtil.lvRefElement(atomicReferenceArray, n4)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public E poll() {
        AtomicReferenceArray atomicReferenceArray = this.buffer;
        long l2 = this.lpConsumerIndex();
        int n2 = AtomicQueueUtil.calcCircularRefElementOffset(l2, this.mask);
        Object e2 = AtomicQueueUtil.lvRefElement(atomicReferenceArray, n2);
        if (null == e2) {
            return null;
        }
        AtomicQueueUtil.soRefElement(atomicReferenceArray, n2, null);
        this.soConsumerIndex(l2 + 1L);
        return e2;
    }

    @Override
    public E peek() {
        return AtomicQueueUtil.lvRefElement(this.buffer, AtomicQueueUtil.calcCircularRefElementOffset(this.lpConsumerIndex(), this.mask));
    }

    @Override
    public boolean relaxedOffer(E e2) {
        return this.offer(e2);
    }

    @Override
    public E relaxedPoll() {
        return this.poll();
    }

    @Override
    public E relaxedPeek() {
        return this.peek();
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> consumer) {
        return this.drain(consumer, this.capacity());
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> supplier) {
        return this.fill(supplier, this.capacity());
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> consumer, int n2) {
        if (null == consumer) {
            throw new IllegalArgumentException("c is null");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("limit is negative: " + n2);
        }
        if (n2 == 0) {
            return 0;
        }
        AtomicReferenceArray atomicReferenceArray = this.buffer;
        int n3 = this.mask;
        long l2 = this.lpConsumerIndex();
        for (int i2 = 0; i2 < n2; ++i2) {
            long l3 = l2 + (long)i2;
            int n4 = AtomicQueueUtil.calcCircularRefElementOffset(l3, n3);
            Object e2 = AtomicQueueUtil.lvRefElement(atomicReferenceArray, n4);
            if (null == e2) {
                return i2;
            }
            AtomicQueueUtil.soRefElement(atomicReferenceArray, n4, null);
            this.soConsumerIndex(l3 + 1L);
            consumer.accept(e2);
        }
        return n2;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> supplier, int n2) {
        if (null == supplier) {
            throw new IllegalArgumentException("supplier is null");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("limit is negative:" + n2);
        }
        if (n2 == 0) {
            return 0;
        }
        AtomicReferenceArray atomicReferenceArray = this.buffer;
        int n3 = this.mask;
        int n4 = this.lookAheadStep;
        long l2 = this.lpProducerIndex();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n5;
            long l3 = l2 + (long)i2;
            int n6 = AtomicQueueUtil.calcCircularRefElementOffset(l3 + (long)n4, n3);
            if (null == AtomicQueueUtil.lvRefElement(atomicReferenceArray, n6)) {
                n5 = Math.min(n4, n2 - i2);
                for (int i3 = 0; i3 < n5; ++i3) {
                    int n7 = AtomicQueueUtil.calcCircularRefElementOffset(l3 + (long)i3, n3);
                    AtomicQueueUtil.soRefElement(atomicReferenceArray, n7, supplier.get());
                    this.soProducerIndex(l3 + (long)i3 + 1L);
                }
                i2 += n5 - 1;
                continue;
            }
            n5 = AtomicQueueUtil.calcCircularRefElementOffset(l3, n3);
            if (null != AtomicQueueUtil.lvRefElement(atomicReferenceArray, n5)) {
                return i2;
            }
            AtomicQueueUtil.soRefElement(atomicReferenceArray, n5, supplier.get());
            this.soProducerIndex(l3 + 1L);
        }
        return n2;
    }

    @Override
    public void drain(MessagePassingQueue.Consumer<E> consumer, MessagePassingQueue.WaitStrategy waitStrategy, MessagePassingQueue.ExitCondition exitCondition) {
        if (null == consumer) {
            throw new IllegalArgumentException("c is null");
        }
        if (null == waitStrategy) {
            throw new IllegalArgumentException("wait is null");
        }
        if (null == exitCondition) {
            throw new IllegalArgumentException("exit condition is null");
        }
        AtomicReferenceArray atomicReferenceArray = this.buffer;
        int n2 = this.mask;
        long l2 = this.lpConsumerIndex();
        int n3 = 0;
        while (exitCondition.keepRunning()) {
            for (int i2 = 0; i2 < 4096; ++i2) {
                int n4 = AtomicQueueUtil.calcCircularRefElementOffset(l2, n2);
                Object e2 = AtomicQueueUtil.lvRefElement(atomicReferenceArray, n4);
                if (null == e2) {
                    n3 = waitStrategy.idle(n3);
                    continue;
                }
                n3 = 0;
                AtomicQueueUtil.soRefElement(atomicReferenceArray, n4, null);
                this.soConsumerIndex(++l2);
                consumer.accept(e2);
            }
        }
    }

    @Override
    public void fill(MessagePassingQueue.Supplier<E> supplier, MessagePassingQueue.WaitStrategy waitStrategy, MessagePassingQueue.ExitCondition exitCondition) {
        if (null == waitStrategy) {
            throw new IllegalArgumentException("waiter is null");
        }
        if (null == exitCondition) {
            throw new IllegalArgumentException("exit condition is null");
        }
        if (null == supplier) {
            throw new IllegalArgumentException("supplier is null");
        }
        AtomicReferenceArray atomicReferenceArray = this.buffer;
        int n2 = this.mask;
        int n3 = this.lookAheadStep;
        long l2 = this.lpProducerIndex();
        int n4 = 0;
        while (exitCondition.keepRunning()) {
            int n5;
            int n6 = AtomicQueueUtil.calcCircularRefElementOffset(l2 + (long)n3, n2);
            if (null == AtomicQueueUtil.lvRefElement(atomicReferenceArray, n6)) {
                for (n5 = 0; n5 < n3; ++n5) {
                    int n7 = AtomicQueueUtil.calcCircularRefElementOffset(l2, n2);
                    AtomicQueueUtil.soRefElement(atomicReferenceArray, n7, supplier.get());
                    this.soProducerIndex(++l2);
                }
                continue;
            }
            n5 = AtomicQueueUtil.calcCircularRefElementOffset(l2, n2);
            if (null != AtomicQueueUtil.lvRefElement(atomicReferenceArray, n5)) {
                n4 = waitStrategy.idle(n4);
                continue;
            }
            n4 = 0;
            AtomicQueueUtil.soRefElement(atomicReferenceArray, n5, supplier.get());
            this.soProducerIndex(++l2);
        }
    }
}

