/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.omp.core.buffer;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.omp.core.Preconditions;
import com.contrastsecurity.thirdparty.omp.core.buffer.DirectBufferAccess;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import sun.misc.Unsafe;

public class MessageBuffer {
    static final boolean isUniversalBuffer;
    static final Unsafe unsafe;
    static final int javaVersion;
    private static final Constructor<?> mbArrConstructor;
    private static final Constructor<?> mbBBConstructor;
    static final int ARRAY_BYTE_BASE_OFFSET;
    private static final String UNIVERSAL_MESSAGE_BUFFER = "com.contrastsecurity.thirdparty.omp.core.buffer.MessageBufferU";
    private static final String BIGENDIAN_MESSAGE_BUFFER = "com.contrastsecurity.thirdparty.omp.core.buffer.MessageBufferBE";
    private static final String DEFAULT_MESSAGE_BUFFER = "com.contrastsecurity.thirdparty.omp.core.buffer.MessageBuffer";
    protected final Object base;
    protected final long address;
    protected final int size;
    protected final ByteBuffer reference;

    private static int getJavaVersion() {
        String string = System.getProperty("java.specification.version", "");
        int n2 = string.indexOf(46);
        if (n2 != -1) {
            try {
                int n3 = Integer.parseInt(string.substring(0, n2));
                int n4 = Integer.parseInt(string.substring(n2 + 1));
                return n3 > 1 ? n3 : n4;
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace(System.err);
            }
        } else {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace(System.err);
            }
        }
        return 6;
    }

    public static MessageBuffer allocate(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("size must not be negative");
        }
        return MessageBuffer.wrap(new byte[n2]);
    }

    public static MessageBuffer wrap(byte[] byArray) {
        return MessageBuffer.newMessageBuffer(byArray, 0, byArray.length);
    }

    public static MessageBuffer wrap(byte[] byArray, int n2, int n3) {
        return MessageBuffer.newMessageBuffer(byArray, n2, n3);
    }

    public static MessageBuffer wrap(ByteBuffer byteBuffer) {
        return MessageBuffer.newMessageBuffer(byteBuffer);
    }

    private static MessageBuffer newMessageBuffer(byte[] byArray, int n2, int n3) {
        Preconditions.checkNotNull(byArray);
        if (mbArrConstructor != null) {
            return MessageBuffer.newInstance(mbArrConstructor, byArray, n2, n3);
        }
        return new MessageBuffer(byArray, n2, n3);
    }

    private static MessageBuffer newMessageBuffer(ByteBuffer byteBuffer) {
        Preconditions.checkNotNull(byteBuffer);
        if (mbBBConstructor != null) {
            return MessageBuffer.newInstance(mbBBConstructor, byteBuffer);
        }
        return new MessageBuffer(byteBuffer);
    }

    private static MessageBuffer newInstance(Constructor<?> constructor, Object ... objectArray) {
        try {
            return (MessageBuffer)constructor.newInstance(objectArray);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalStateException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwables.throwIfCritical(invocationTargetException);
            InvocationTargetException invocationTargetException2 = invocationTargetException;
            if (invocationTargetException2.getCause() instanceof RuntimeException) {
                throw (RuntimeException)invocationTargetException2.getCause();
            }
            if (invocationTargetException2.getCause() instanceof Error) {
                throw (Error)invocationTargetException2.getCause();
            }
            throw new IllegalStateException(invocationTargetException2.getCause());
        }
    }

    public static void releaseBuffer(MessageBuffer messageBuffer) {
        if (!isUniversalBuffer && !messageBuffer.hasArray()) {
            if (DirectBufferAccess.isDirectByteBufferInstance(messageBuffer.reference)) {
                DirectBufferAccess.clean(messageBuffer.reference);
            } else {
                unsafe.freeMemory(messageBuffer.address);
            }
        }
    }

    MessageBuffer(byte[] byArray, int n2, int n3) {
        this.base = byArray;
        this.address = ARRAY_BYTE_BASE_OFFSET + n2;
        this.size = n3;
        this.reference = null;
    }

    MessageBuffer(ByteBuffer byteBuffer) {
        if (byteBuffer.isDirect()) {
            if (isUniversalBuffer) {
                this.base = null;
                this.address = 0L;
                this.size = byteBuffer.remaining();
                this.reference = null;
                return;
            }
            this.base = null;
            this.address = DirectBufferAccess.getAddress(byteBuffer) + (long)byteBuffer.position();
            this.size = byteBuffer.remaining();
            this.reference = byteBuffer;
        } else if (byteBuffer.hasArray()) {
            this.base = byteBuffer.array();
            this.address = ARRAY_BYTE_BASE_OFFSET + byteBuffer.arrayOffset() + byteBuffer.position();
            this.size = byteBuffer.remaining();
            this.reference = null;
        } else {
            throw new IllegalArgumentException("Only the array-backed ByteBuffer or DirectBuffer is supported");
        }
    }

    protected MessageBuffer(Object object, long l2, int n2) {
        this.base = object;
        this.address = l2;
        this.size = n2;
        this.reference = null;
    }

    public int size() {
        return this.size;
    }

    public MessageBuffer slice(int n2, int n3) {
        if (n2 == 0 && n3 == this.size()) {
            return this;
        }
        Preconditions.checkArgument(n2 + n3 <= this.size());
        return new MessageBuffer(this.base, this.address + (long)n2, n3);
    }

    public byte getByte(int n2) {
        return unsafe.getByte(this.base, this.address + (long)n2);
    }

    public boolean getBoolean(int n2) {
        return unsafe.getBoolean(this.base, this.address + (long)n2);
    }

    public short getShort(int n2) {
        short s2 = unsafe.getShort(this.base, this.address + (long)n2);
        return Short.reverseBytes(s2);
    }

    public int getInt(int n2) {
        int n3 = unsafe.getInt(this.base, this.address + (long)n2);
        return Integer.reverseBytes(n3);
    }

    public float getFloat(int n2) {
        return Float.intBitsToFloat(this.getInt(n2));
    }

    public long getLong(int n2) {
        long l2 = unsafe.getLong(this.base, this.address + (long)n2);
        return Long.reverseBytes(l2);
    }

    public double getDouble(int n2) {
        return Double.longBitsToDouble(this.getLong(n2));
    }

    public void getBytes(int n2, byte[] byArray, int n3, int n4) {
        unsafe.copyMemory(this.base, this.address + (long)n2, byArray, ARRAY_BYTE_BASE_OFFSET + n3, n4);
    }

    public void getBytes(int n2, int n3, ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() < n3) {
            throw new BufferOverflowException();
        }
        ByteBuffer byteBuffer2 = this.sliceAsByteBuffer(n2, n3);
        byteBuffer.put(byteBuffer2);
    }

    public void putByte(int n2, byte by) {
        unsafe.putByte(this.base, this.address + (long)n2, by);
    }

    public void putBoolean(int n2, boolean bl2) {
        unsafe.putBoolean(this.base, this.address + (long)n2, bl2);
    }

    public void putShort(int n2, short s2) {
        s2 = Short.reverseBytes(s2);
        unsafe.putShort(this.base, this.address + (long)n2, s2);
    }

    public void putInt(int n2, int n3) {
        n3 = Integer.reverseBytes(n3);
        unsafe.putInt(this.base, this.address + (long)n2, n3);
    }

    public void putFloat(int n2, float f2) {
        this.putInt(n2, Float.floatToRawIntBits(f2));
    }

    public void putLong(int n2, long l2) {
        l2 = Long.reverseBytes(l2);
        unsafe.putLong(this.base, this.address + (long)n2, l2);
    }

    public void putDouble(int n2, double d2) {
        this.putLong(n2, Double.doubleToRawLongBits(d2));
    }

    public void putBytes(int n2, byte[] byArray, int n3, int n4) {
        unsafe.copyMemory(byArray, ARRAY_BYTE_BASE_OFFSET + n3, this.base, this.address + (long)n2, n4);
    }

    public void putByteBuffer(int n2, ByteBuffer byteBuffer, int n3) {
        assert (n3 <= byteBuffer.remaining());
        assert (!isUniversalBuffer);
        if (byteBuffer.isDirect()) {
            unsafe.copyMemory(null, DirectBufferAccess.getAddress(byteBuffer) + (long)byteBuffer.position(), this.base, this.address + (long)n2, n3);
            byteBuffer.position(byteBuffer.position() + n3);
        } else if (byteBuffer.hasArray()) {
            byte[] byArray = byteBuffer.array();
            unsafe.copyMemory(byArray, ARRAY_BYTE_BASE_OFFSET + byteBuffer.position(), this.base, this.address + (long)n2, n3);
            byteBuffer.position(byteBuffer.position() + n3);
        } else if (this.hasArray()) {
            byteBuffer.get((byte[])this.base, n2, n3);
        } else {
            for (int i2 = 0; i2 < n3; ++i2) {
                unsafe.putByte(this.base, this.address + (long)n2, byteBuffer.get());
            }
        }
    }

    public void putMessageBuffer(int n2, MessageBuffer messageBuffer, int n3, int n4) {
        unsafe.copyMemory(messageBuffer.base, messageBuffer.address + (long)n3, this.base, this.address + (long)n2, n4);
    }

    public ByteBuffer sliceAsByteBuffer(int n2, int n3) {
        if (this.hasArray()) {
            return ByteBuffer.wrap((byte[])this.base, (int)(this.address - (long)ARRAY_BYTE_BASE_OFFSET + (long)n2), n3);
        }
        assert (!isUniversalBuffer);
        return DirectBufferAccess.newByteBuffer(this.address, n2, n3, this.reference);
    }

    public ByteBuffer sliceAsByteBuffer() {
        return this.sliceAsByteBuffer(0, this.size());
    }

    public boolean hasArray() {
        return this.base != null;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.size()];
        unsafe.copyMemory(this.base, this.address, byArray, ARRAY_BYTE_BASE_OFFSET, this.size());
        return byArray;
    }

    public byte[] array() {
        return (byte[])this.base;
    }

    public int arrayOffset() {
        return (int)this.address - ARRAY_BYTE_BASE_OFFSET;
    }

    public void copyTo(int n2, MessageBuffer messageBuffer, int n3, int n4) {
        unsafe.copyMemory(this.base, this.address + (long)n2, messageBuffer.base, messageBuffer.address + (long)n3, n4);
    }

    public String toHexString(int n2, int n3) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = n2; i2 < n3; ++i2) {
            if (i2 != n2) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(String.format("%02x", this.getByte(i2)));
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        block25: {
            String string;
            AccessibleObject accessibleObject;
            block23: {
                boolean bl2;
                block22: {
                    javaVersion = MessageBuffer.getJavaVersion();
                    boolean bl3 = false;
                    Unsafe unsafe = null;
                    int n2 = 16;
                    try {
                        boolean bl4 = false;
                        try {
                            bl4 = Class.forName("sun.misc.Unsafe") != null;
                        }
                        catch (Exception exception) {
                            Throwables.throwIfCritical(exception);
                            Exception exception2 = exception;
                        }
                        bl2 = System.getProperty("java.runtime.name", "").toLowerCase().contains("android");
                        boolean bl5 = System.getProperty("com.contrastsecurity.thirdparty.cggl.appengine.runtime.version") != null;
                        boolean bl6 = bl3 = Boolean.parseBoolean(System.getProperty("msgpack.universal-buffer", "false")) || bl2 || bl5 || javaVersion < 7 || !bl4;
                        if (!bl3) {
                            accessibleObject = Unsafe.class.getDeclaredField("theUnsafe");
                            ((Field)accessibleObject).setAccessible(true);
                            unsafe = (Unsafe)((Field)accessibleObject).get(null);
                            if (unsafe == null) {
                                throw new RuntimeException("Unsafe is unavailable");
                            }
                            n2 = unsafe.arrayBaseOffset(byte[].class);
                            int n3 = unsafe.arrayIndexScale(byte[].class);
                            if (n3 != 1) {
                                throw new IllegalStateException("Byte array index scale must be 1, but is " + n3);
                            }
                        }
                        MessageBuffer.unsafe = unsafe;
                        ARRAY_BYTE_BASE_OFFSET = n2;
                        isUniversalBuffer = bl3;
                        if (!isUniversalBuffer) break block22;
                        string = UNIVERSAL_MESSAGE_BUFFER;
                        break block23;
                    }
                    catch (Exception exception) {
                        Object object;
                        block24: {
                            try {
                                Throwables.throwIfCritical(exception);
                                object = exception;
                                ((Throwable)object).printStackTrace(System.err);
                                bl3 = true;
                                MessageBuffer.unsafe = unsafe;
                                ARRAY_BYTE_BASE_OFFSET = n2;
                                isUniversalBuffer = bl3;
                                if (!isUniversalBuffer) break block24;
                                object = UNIVERSAL_MESSAGE_BUFFER;
                            }
                            catch (Throwable throwable) {
                                String string2;
                                MessageBuffer.unsafe = unsafe;
                                ARRAY_BYTE_BASE_OFFSET = n2;
                                isUniversalBuffer = bl3;
                                if (isUniversalBuffer) {
                                    string2 = UNIVERSAL_MESSAGE_BUFFER;
                                } else {
                                    boolean bl7 = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
                                    String string3 = string2 = bl7 ? DEFAULT_MESSAGE_BUFFER : BIGENDIAN_MESSAGE_BUFFER;
                                }
                                if (DEFAULT_MESSAGE_BUFFER.equals(string2)) {
                                    mbArrConstructor = null;
                                    mbBBConstructor = null;
                                } else {
                                    try {
                                        Class<?> clazz = Class.forName(string2);
                                        Constructor<?> constructor = clazz.getDeclaredConstructor(byte[].class, Integer.TYPE, Integer.TYPE);
                                        constructor.setAccessible(true);
                                        mbArrConstructor = constructor;
                                        Constructor<?> constructor2 = clazz.getDeclaredConstructor(ByteBuffer.class);
                                        constructor2.setAccessible(true);
                                        mbBBConstructor = constructor2;
                                    }
                                    catch (Exception exception3) {
                                        Throwables.throwIfCritical(exception3);
                                        Exception exception4 = exception3;
                                        exception4.printStackTrace(System.err);
                                        throw new RuntimeException(exception4);
                                    }
                                }
                                throw throwable;
                            }
                        }
                        boolean bl8 = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
                        Object object2 = object = bl8 ? DEFAULT_MESSAGE_BUFFER : BIGENDIAN_MESSAGE_BUFFER;
                        if (DEFAULT_MESSAGE_BUFFER.equals(object)) {
                            mbArrConstructor = null;
                            mbBBConstructor = null;
                            break block25;
                        }
                        try {
                            Class<?> clazz = Class.forName((String)object);
                            Constructor<?> constructor = clazz.getDeclaredConstructor(byte[].class, Integer.TYPE, Integer.TYPE);
                            constructor.setAccessible(true);
                            mbArrConstructor = constructor;
                            Constructor<?> constructor3 = clazz.getDeclaredConstructor(ByteBuffer.class);
                            constructor3.setAccessible(true);
                            mbBBConstructor = constructor3;
                            break block25;
                        }
                        catch (Exception exception5) {
                            Throwables.throwIfCritical(exception5);
                            Exception exception6 = exception5;
                            exception6.printStackTrace(System.err);
                            throw new RuntimeException(exception6);
                        }
                    }
                }
                bl2 = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
                String string4 = string = bl2 ? DEFAULT_MESSAGE_BUFFER : BIGENDIAN_MESSAGE_BUFFER;
            }
            if (DEFAULT_MESSAGE_BUFFER.equals(string)) {
                mbArrConstructor = null;
                mbBBConstructor = null;
            } else {
                try {
                    Class<?> clazz = Class.forName(string);
                    Constructor<?> constructor = clazz.getDeclaredConstructor(byte[].class, Integer.TYPE, Integer.TYPE);
                    constructor.setAccessible(true);
                    mbArrConstructor = constructor;
                    accessibleObject = clazz.getDeclaredConstructor(ByteBuffer.class);
                    ((Constructor)accessibleObject).setAccessible(true);
                    mbBBConstructor = accessibleObject;
                }
                catch (Exception exception) {
                    Throwables.throwIfCritical(exception);
                    Exception exception7 = exception;
                    exception7.printStackTrace(System.err);
                    throw new RuntimeException(exception7);
                }
            }
        }
    }
}

