/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.omp.value.impl;

import com.contrastsecurity.thirdparty.omp.core.MessagePacker;
import com.contrastsecurity.thirdparty.omp.value.ExtensionValue;
import com.contrastsecurity.thirdparty.omp.value.ImmutableExtensionValue;
import com.contrastsecurity.thirdparty.omp.value.Value;
import com.contrastsecurity.thirdparty.omp.value.ValueType;
import com.contrastsecurity.thirdparty.omp.value.impl.AbstractImmutableValue;
import java.io.IOException;
import java.util.Arrays;

public class ImmutableExtensionValueImpl
extends AbstractImmutableValue
implements ImmutableExtensionValue {
    private final byte type;
    private final byte[] data;

    public ImmutableExtensionValueImpl(byte by, byte[] byArray) {
        this.type = by;
        this.data = byArray;
    }

    @Override
    public ValueType getValueType() {
        return ValueType.EXTENSION;
    }

    @Override
    public ImmutableExtensionValue immutableValue() {
        return this;
    }

    @Override
    public ImmutableExtensionValue asExtensionValue() {
        return this;
    }

    @Override
    public byte getType() {
        return this.type;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public void writeTo(MessagePacker messagePacker) throws IOException {
        messagePacker.packExtensionTypeHeader(this.type, this.data.length);
        messagePacker.writePayload(this.data);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Value)) {
            return false;
        }
        Value value = (Value)object;
        if (!value.isExtensionValue()) {
            return false;
        }
        ExtensionValue extensionValue = value.asExtensionValue();
        return this.type == extensionValue.getType() && Arrays.equals(this.data, extensionValue.getData());
    }

    public int hashCode() {
        int n2 = 31 + this.type;
        for (byte by : this.data) {
            n2 = 31 * n2 + by;
        }
        return n2;
    }

    @Override
    public String toJson() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        stringBuilder.append(Byte.toString(this.type));
        stringBuilder.append(",\"");
        for (byte by : this.data) {
            stringBuilder.append(Integer.toString(by, 16));
        }
        stringBuilder.append("\"]");
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        stringBuilder.append(Byte.toString(this.type));
        stringBuilder.append(",0x");
        for (byte by : this.data) {
            stringBuilder.append(Integer.toString(by, 16));
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

