/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.omv2.conversion;

import com.contrastsecurity.thirdparty.omv2.ConversionException;
import com.contrastsecurity.thirdparty.omv2.ConversionHandler;
import com.contrastsecurity.thirdparty.omv2.conversion.Converter;
import java.util.HashMap;
import java.util.Map;

public class IntArrayCH
implements ConversionHandler {
    private static final Map<Class, Converter> CNV = new HashMap<Class, Converter>();

    public Object convertFrom(Object object) {
        if (!CNV.containsKey(object.getClass())) {
            throw new ConversionException("cannot convert type: " + object.getClass().getName() + " to: " + Boolean.class.getName());
        }
        return CNV.get(object.getClass()).convert(object);
    }

    public boolean canConvertFrom(Class clazz) {
        return CNV.containsKey(clazz);
    }

    static {
        CNV.put(String[].class, new Converter(){

            public Object convert(Object object) {
                String[] stringArray = (String[])object;
                Integer[] integerArray = new Integer[stringArray.length];
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    integerArray[i2] = Integer.parseInt(stringArray[i2]);
                }
                return integerArray;
            }
        });
        CNV.put(Object[].class, new Converter(){

            public Object convert(Object object) {
                Object[] objectArray = (Object[])object;
                Integer[] integerArray = new Integer[objectArray.length];
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    integerArray[i2] = Integer.parseInt(String.valueOf(objectArray[i2]));
                }
                return integerArray;
            }
        });
    }
}

