/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oobjw.asm;

import com.contrastsecurity.thirdparty.oobjw.asm.AnnotationVisitor;
import com.contrastsecurity.thirdparty.oobjw.asm.AnnotationWriter;
import com.contrastsecurity.thirdparty.oobjw.asm.Attribute;
import com.contrastsecurity.thirdparty.oobjw.asm.ByteVector;
import com.contrastsecurity.thirdparty.oobjw.asm.ClassReader;
import com.contrastsecurity.thirdparty.oobjw.asm.CurrentFrame;
import com.contrastsecurity.thirdparty.oobjw.asm.Edge;
import com.contrastsecurity.thirdparty.oobjw.asm.Frame;
import com.contrastsecurity.thirdparty.oobjw.asm.Handle;
import com.contrastsecurity.thirdparty.oobjw.asm.Handler;
import com.contrastsecurity.thirdparty.oobjw.asm.Label;
import com.contrastsecurity.thirdparty.oobjw.asm.MethodTooLargeException;
import com.contrastsecurity.thirdparty.oobjw.asm.MethodVisitor;
import com.contrastsecurity.thirdparty.oobjw.asm.Opcodes;
import com.contrastsecurity.thirdparty.oobjw.asm.Symbol;
import com.contrastsecurity.thirdparty.oobjw.asm.SymbolTable;
import com.contrastsecurity.thirdparty.oobjw.asm.Type;
import com.contrastsecurity.thirdparty.oobjw.asm.TypePath;

final class MethodWriter
extends MethodVisitor {
    static final int COMPUTE_NOTHING = 0;
    static final int COMPUTE_MAX_STACK_AND_LOCAL = 1;
    static final int COMPUTE_MAX_STACK_AND_LOCAL_FROM_FRAMES = 2;
    static final int COMPUTE_INSERTED_FRAMES = 3;
    static final int COMPUTE_ALL_FRAMES = 4;
    private static final int NA = 0;
    private static final int[] STACK_SIZE_DELTA = new int[]{0, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 2, 2, 1, 1, 1, 0, 0, 1, 2, 1, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, -1, 0, -1, -1, -1, -1, -1, -2, -1, -2, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -3, -4, -3, -4, -3, -3, -3, -3, -1, -2, 1, 1, 1, 2, 2, 2, 0, -1, -2, -1, -2, -1, -2, -1, -2, -1, -2, -1, -2, -1, -2, -1, -2, -1, -2, -1, -2, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -2, -1, -2, -1, -2, 0, 1, 0, 1, -1, -1, 0, 0, 1, 1, -1, 0, -1, 0, 0, 0, -3, -1, -1, -3, -3, -1, -1, -1, -1, -1, -1, -2, -2, -2, -2, -2, -2, -2, -2, 0, 1, 0, -1, -1, -1, -2, -1, -2, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, -1, -1, 0, 0, -1, -1, 0, 0};
    private final SymbolTable symbolTable;
    private final int accessFlags;
    private final int nameIndex;
    private final String name;
    private final int descriptorIndex;
    private final String descriptor;
    private int maxStack;
    private int maxLocals;
    private final ByteVector code = new ByteVector();
    private Handler firstHandler;
    private Handler lastHandler;
    private int lineNumberTableLength;
    private ByteVector lineNumberTable;
    private int localVariableTableLength;
    private ByteVector localVariableTable;
    private int localVariableTypeTableLength;
    private ByteVector localVariableTypeTable;
    private int stackMapTableNumberOfEntries;
    private ByteVector stackMapTableEntries;
    private AnnotationWriter lastCodeRuntimeVisibleTypeAnnotation;
    private AnnotationWriter lastCodeRuntimeInvisibleTypeAnnotation;
    private Attribute firstCodeAttribute;
    private final int numberOfExceptions;
    private final int[] exceptionIndexTable;
    private final int signatureIndex;
    private AnnotationWriter lastRuntimeVisibleAnnotation;
    private AnnotationWriter lastRuntimeInvisibleAnnotation;
    private int visibleAnnotableParameterCount;
    private AnnotationWriter[] lastRuntimeVisibleParameterAnnotations;
    private int invisibleAnnotableParameterCount;
    private AnnotationWriter[] lastRuntimeInvisibleParameterAnnotations;
    private AnnotationWriter lastRuntimeVisibleTypeAnnotation;
    private AnnotationWriter lastRuntimeInvisibleTypeAnnotation;
    private ByteVector defaultValue;
    private int parametersCount;
    private ByteVector parameters;
    private Attribute firstAttribute;
    private final int compute;
    private Label firstBasicBlock;
    private Label lastBasicBlock;
    private Label currentBasicBlock;
    private int relativeStackSize;
    private int maxRelativeStackSize;
    private int currentLocals;
    private int previousFrameOffset;
    private int[] previousFrame;
    private int[] currentFrame;
    private boolean hasSubroutines;
    private boolean hasAsmInstructions;
    private int lastBytecodeOffset;
    private int sourceOffset;
    private int sourceLength;

    MethodWriter(SymbolTable symbolTable, int n2, String string, String string2, String string3, String[] stringArray, int n3) {
        super(589824);
        int n4;
        this.symbolTable = symbolTable;
        this.accessFlags = "<init>".equals(string) ? n2 | 0x40000 : n2;
        this.nameIndex = symbolTable.addConstantUtf8(string);
        this.name = string;
        this.descriptorIndex = symbolTable.addConstantUtf8(string2);
        this.descriptor = string2;
        int n5 = this.signatureIndex = string3 == null ? 0 : symbolTable.addConstantUtf8(string3);
        if (stringArray != null && stringArray.length > 0) {
            this.numberOfExceptions = stringArray.length;
            this.exceptionIndexTable = new int[this.numberOfExceptions];
            for (n4 = 0; n4 < this.numberOfExceptions; ++n4) {
                this.exceptionIndexTable[n4] = symbolTable.addConstantClass((String)stringArray[n4]).index;
            }
        } else {
            this.numberOfExceptions = 0;
            this.exceptionIndexTable = null;
        }
        this.compute = n3;
        if (n3 != 0) {
            n4 = Type.getArgumentsAndReturnSizes(string2) >> 2;
            if ((n2 & 8) != 0) {
                --n4;
            }
            this.maxLocals = n4;
            this.currentLocals = n4;
            this.firstBasicBlock = new Label();
            this.visitLabel(this.firstBasicBlock);
        }
    }

    boolean hasFrames() {
        return this.stackMapTableNumberOfEntries > 0;
    }

    boolean hasAsmInstructions() {
        return this.hasAsmInstructions;
    }

    public void visitParameter(String string, int n2) {
        if (this.parameters == null) {
            this.parameters = new ByteVector();
        }
        ++this.parametersCount;
        this.parameters.putShort(string == null ? 0 : this.symbolTable.addConstantUtf8(string)).putShort(n2);
    }

    public AnnotationVisitor visitAnnotationDefault() {
        this.defaultValue = new ByteVector();
        return new AnnotationWriter(this.symbolTable, false, this.defaultValue, null);
    }

    public AnnotationVisitor visitAnnotation(String string, boolean bl2) {
        if (bl2) {
            this.lastRuntimeVisibleAnnotation = AnnotationWriter.create(this.symbolTable, string, this.lastRuntimeVisibleAnnotation);
            return this.lastRuntimeVisibleAnnotation;
        }
        this.lastRuntimeInvisibleAnnotation = AnnotationWriter.create(this.symbolTable, string, this.lastRuntimeInvisibleAnnotation);
        return this.lastRuntimeInvisibleAnnotation;
    }

    public AnnotationVisitor visitTypeAnnotation(int n2, TypePath typePath, String string, boolean bl2) {
        if (bl2) {
            this.lastRuntimeVisibleTypeAnnotation = AnnotationWriter.create(this.symbolTable, n2, typePath, string, this.lastRuntimeVisibleTypeAnnotation);
            return this.lastRuntimeVisibleTypeAnnotation;
        }
        this.lastRuntimeInvisibleTypeAnnotation = AnnotationWriter.create(this.symbolTable, n2, typePath, string, this.lastRuntimeInvisibleTypeAnnotation);
        return this.lastRuntimeInvisibleTypeAnnotation;
    }

    public void visitAnnotableParameterCount(int n2, boolean bl2) {
        if (bl2) {
            this.visibleAnnotableParameterCount = n2;
        } else {
            this.invisibleAnnotableParameterCount = n2;
        }
    }

    public AnnotationVisitor visitParameterAnnotation(int n2, String string, boolean bl2) {
        if (bl2) {
            if (this.lastRuntimeVisibleParameterAnnotations == null) {
                this.lastRuntimeVisibleParameterAnnotations = new AnnotationWriter[Type.getArgumentCount(this.descriptor)];
            }
            this.lastRuntimeVisibleParameterAnnotations[n2] = AnnotationWriter.create(this.symbolTable, string, this.lastRuntimeVisibleParameterAnnotations[n2]);
            return this.lastRuntimeVisibleParameterAnnotations[n2];
        }
        if (this.lastRuntimeInvisibleParameterAnnotations == null) {
            this.lastRuntimeInvisibleParameterAnnotations = new AnnotationWriter[Type.getArgumentCount(this.descriptor)];
        }
        this.lastRuntimeInvisibleParameterAnnotations[n2] = AnnotationWriter.create(this.symbolTable, string, this.lastRuntimeInvisibleParameterAnnotations[n2]);
        return this.lastRuntimeInvisibleParameterAnnotations[n2];
    }

    public void visitAttribute(Attribute attribute) {
        if (attribute.isCodeAttribute()) {
            attribute.nextAttribute = this.firstCodeAttribute;
            this.firstCodeAttribute = attribute;
        } else {
            attribute.nextAttribute = this.firstAttribute;
            this.firstAttribute = attribute;
        }
    }

    public void visitCode() {
    }

    public void visitFrame(int n2, int n3, Object[] objectArray, int n4, Object[] objectArray2) {
        int n5;
        int n6;
        if (this.compute == 4) {
            return;
        }
        if (this.compute == 3) {
            if (this.currentBasicBlock.frame == null) {
                this.currentBasicBlock.frame = new CurrentFrame(this.currentBasicBlock);
                this.currentBasicBlock.frame.setInputFrameFromDescriptor(this.symbolTable, this.accessFlags, this.descriptor, n3);
                this.currentBasicBlock.frame.accept(this);
            } else {
                if (n2 == -1) {
                    this.currentBasicBlock.frame.setInputFrameFromApiFormat(this.symbolTable, n3, objectArray, n4, objectArray2);
                }
                this.currentBasicBlock.frame.accept(this);
            }
        } else if (n2 == -1) {
            if (this.previousFrame == null) {
                n6 = Type.getArgumentsAndReturnSizes(this.descriptor) >> 2;
                Frame frame = new Frame(new Label());
                frame.setInputFrameFromDescriptor(this.symbolTable, this.accessFlags, this.descriptor, n6);
                frame.accept(this);
            }
            this.currentLocals = n3;
            n6 = this.visitFrameStart(this.code.length, n3, n4);
            for (n5 = 0; n5 < n3; ++n5) {
                this.currentFrame[n6++] = Frame.getAbstractTypeFromApiFormat(this.symbolTable, objectArray[n5]);
            }
            for (n5 = 0; n5 < n4; ++n5) {
                this.currentFrame[n6++] = Frame.getAbstractTypeFromApiFormat(this.symbolTable, objectArray2[n5]);
            }
            this.visitFrameEnd();
        } else {
            if (this.symbolTable.getMajorVersion() < 50) {
                throw new IllegalArgumentException("Class versions V1_5 or less must use F_NEW frames.");
            }
            if (this.stackMapTableEntries == null) {
                this.stackMapTableEntries = new ByteVector();
                n6 = this.code.length;
            } else {
                n6 = this.code.length - this.previousFrameOffset - 1;
                if (n6 < 0) {
                    if (n2 == 3) {
                        return;
                    }
                    throw new IllegalStateException();
                }
            }
            switch (n2) {
                case 0: {
                    this.currentLocals = n3;
                    this.stackMapTableEntries.putByte(255).putShort(n6).putShort(n3);
                    for (n5 = 0; n5 < n3; ++n5) {
                        this.putFrameType(objectArray[n5]);
                    }
                    this.stackMapTableEntries.putShort(n4);
                    for (n5 = 0; n5 < n4; ++n5) {
                        this.putFrameType(objectArray2[n5]);
                    }
                    break;
                }
                case 1: {
                    this.currentLocals += n3;
                    this.stackMapTableEntries.putByte(251 + n3).putShort(n6);
                    for (n5 = 0; n5 < n3; ++n5) {
                        this.putFrameType(objectArray[n5]);
                    }
                    break;
                }
                case 2: {
                    this.currentLocals -= n3;
                    this.stackMapTableEntries.putByte(251 - n3).putShort(n6);
                    break;
                }
                case 3: {
                    if (n6 < 64) {
                        this.stackMapTableEntries.putByte(n6);
                        break;
                    }
                    this.stackMapTableEntries.putByte(251).putShort(n6);
                    break;
                }
                case 4: {
                    if (n6 < 64) {
                        this.stackMapTableEntries.putByte(64 + n6);
                    } else {
                        this.stackMapTableEntries.putByte(247).putShort(n6);
                    }
                    this.putFrameType(objectArray2[0]);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            this.previousFrameOffset = this.code.length;
            ++this.stackMapTableNumberOfEntries;
        }
        if (this.compute == 2) {
            this.relativeStackSize = n4;
            for (n6 = 0; n6 < n4; ++n6) {
                if (objectArray2[n6] != Opcodes.LONG && objectArray2[n6] != Opcodes.DOUBLE) continue;
                ++this.relativeStackSize;
            }
            if (this.relativeStackSize > this.maxRelativeStackSize) {
                this.maxRelativeStackSize = this.relativeStackSize;
            }
        }
        this.maxStack = Math.max(this.maxStack, n4);
        this.maxLocals = Math.max(this.maxLocals, this.currentLocals);
    }

    public void visitInsn(int n2) {
        this.lastBytecodeOffset = this.code.length;
        this.code.putByte(n2);
        if (this.currentBasicBlock != null) {
            if (this.compute == 4 || this.compute == 3) {
                this.currentBasicBlock.frame.execute(n2, 0, null, null);
            } else {
                int n3 = this.relativeStackSize + STACK_SIZE_DELTA[n2];
                if (n3 > this.maxRelativeStackSize) {
                    this.maxRelativeStackSize = n3;
                }
                this.relativeStackSize = n3;
            }
            if (n2 >= 172 && n2 <= 177 || n2 == 191) {
                this.endCurrentBasicBlockWithNoSuccessor();
            }
        }
    }

    public void visitIntInsn(int n2, int n3) {
        this.lastBytecodeOffset = this.code.length;
        if (n2 == 17) {
            this.code.put12(n2, n3);
        } else {
            this.code.put11(n2, n3);
        }
        if (this.currentBasicBlock != null) {
            if (this.compute == 4 || this.compute == 3) {
                this.currentBasicBlock.frame.execute(n2, n3, null, null);
            } else if (n2 != 188) {
                int n4 = this.relativeStackSize + 1;
                if (n4 > this.maxRelativeStackSize) {
                    this.maxRelativeStackSize = n4;
                }
                this.relativeStackSize = n4;
            }
        }
    }

    public void visitVarInsn(int n2, int n3) {
        int n4;
        this.lastBytecodeOffset = this.code.length;
        if (n3 < 4 && n2 != 169) {
            n4 = n2 < 54 ? 26 + (n2 - 21 << 2) + n3 : 59 + (n2 - 54 << 2) + n3;
            this.code.putByte(n4);
        } else if (n3 >= 256) {
            this.code.putByte(196).put12(n2, n3);
        } else {
            this.code.put11(n2, n3);
        }
        if (this.currentBasicBlock != null) {
            if (this.compute == 4 || this.compute == 3) {
                this.currentBasicBlock.frame.execute(n2, n3, null, null);
            } else if (n2 == 169) {
                this.currentBasicBlock.flags = (short)(this.currentBasicBlock.flags | 0x40);
                this.currentBasicBlock.outputStackSize = (short)this.relativeStackSize;
                this.endCurrentBasicBlockWithNoSuccessor();
            } else {
                n4 = this.relativeStackSize + STACK_SIZE_DELTA[n2];
                if (n4 > this.maxRelativeStackSize) {
                    this.maxRelativeStackSize = n4;
                }
                this.relativeStackSize = n4;
            }
        }
        if (this.compute != 0 && (n4 = n2 == 22 || n2 == 24 || n2 == 55 || n2 == 57 ? n3 + 2 : n3 + 1) > this.maxLocals) {
            this.maxLocals = n4;
        }
        if (n2 >= 54 && this.compute == 4 && this.firstHandler != null) {
            this.visitLabel(new Label());
        }
    }

    public void visitTypeInsn(int n2, String string) {
        this.lastBytecodeOffset = this.code.length;
        Symbol symbol = this.symbolTable.addConstantClass(string);
        this.code.put12(n2, symbol.index);
        if (this.currentBasicBlock != null) {
            if (this.compute == 4 || this.compute == 3) {
                this.currentBasicBlock.frame.execute(n2, this.lastBytecodeOffset, symbol, this.symbolTable);
            } else if (n2 == 187) {
                int n3 = this.relativeStackSize + 1;
                if (n3 > this.maxRelativeStackSize) {
                    this.maxRelativeStackSize = n3;
                }
                this.relativeStackSize = n3;
            }
        }
    }

    public void visitFieldInsn(int n2, String string, String string2, String string3) {
        this.lastBytecodeOffset = this.code.length;
        Symbol symbol = this.symbolTable.addConstantFieldref(string, string2, string3);
        this.code.put12(n2, symbol.index);
        if (this.currentBasicBlock != null) {
            if (this.compute == 4 || this.compute == 3) {
                this.currentBasicBlock.frame.execute(n2, 0, symbol, this.symbolTable);
            } else {
                int n3;
                char c2 = string3.charAt(0);
                switch (n2) {
                    case 178: {
                        n3 = this.relativeStackSize + (c2 == 'D' || c2 == 'J' ? 2 : 1);
                        break;
                    }
                    case 179: {
                        n3 = this.relativeStackSize + (c2 == 'D' || c2 == 'J' ? -2 : -1);
                        break;
                    }
                    case 180: {
                        n3 = this.relativeStackSize + (c2 == 'D' || c2 == 'J' ? 1 : 0);
                        break;
                    }
                    default: {
                        n3 = this.relativeStackSize + (c2 == 'D' || c2 == 'J' ? -3 : -2);
                    }
                }
                if (n3 > this.maxRelativeStackSize) {
                    this.maxRelativeStackSize = n3;
                }
                this.relativeStackSize = n3;
            }
        }
    }

    public void visitMethodInsn(int n2, String string, String string2, String string3, boolean bl2) {
        this.lastBytecodeOffset = this.code.length;
        Symbol symbol = this.symbolTable.addConstantMethodref(string, string2, string3, bl2);
        if (n2 == 185) {
            this.code.put12(185, symbol.index).put11(symbol.getArgumentsAndReturnSizes() >> 2, 0);
        } else {
            this.code.put12(n2, symbol.index);
        }
        if (this.currentBasicBlock != null) {
            if (this.compute == 4 || this.compute == 3) {
                this.currentBasicBlock.frame.execute(n2, 0, symbol, this.symbolTable);
            } else {
                int n3 = symbol.getArgumentsAndReturnSizes();
                int n4 = (n3 & 3) - (n3 >> 2);
                int n5 = n2 == 184 ? this.relativeStackSize + n4 + 1 : this.relativeStackSize + n4;
                if (n5 > this.maxRelativeStackSize) {
                    this.maxRelativeStackSize = n5;
                }
                this.relativeStackSize = n5;
            }
        }
    }

    public void visitInvokeDynamicInsn(String string, String string2, Handle handle, Object ... objectArray) {
        this.lastBytecodeOffset = this.code.length;
        Symbol symbol = this.symbolTable.addConstantInvokeDynamic(string, string2, handle, objectArray);
        this.code.put12(186, symbol.index);
        this.code.putShort(0);
        if (this.currentBasicBlock != null) {
            if (this.compute == 4 || this.compute == 3) {
                this.currentBasicBlock.frame.execute(186, 0, symbol, this.symbolTable);
            } else {
                int n2 = symbol.getArgumentsAndReturnSizes();
                int n3 = (n2 & 3) - (n2 >> 2) + 1;
                int n4 = this.relativeStackSize + n3;
                if (n4 > this.maxRelativeStackSize) {
                    this.maxRelativeStackSize = n4;
                }
                this.relativeStackSize = n4;
            }
        }
    }

    public void visitJumpInsn(int n2, Label label) {
        this.lastBytecodeOffset = this.code.length;
        int n3 = n2 >= 200 ? n2 - 33 : n2;
        boolean bl2 = false;
        if ((label.flags & 4) != 0 && label.bytecodeOffset - this.code.length < Short.MIN_VALUE) {
            if (n3 == 167) {
                this.code.putByte(200);
            } else if (n3 == 168) {
                this.code.putByte(201);
            } else {
                this.code.putByte(n3 >= 198 ? n3 ^ 1 : (n3 + 1 ^ 1) - 1);
                this.code.putShort(8);
                this.code.putByte(220);
                this.hasAsmInstructions = true;
                bl2 = true;
            }
            label.put(this.code, this.code.length - 1, true);
        } else if (n3 != n2) {
            this.code.putByte(n2);
            label.put(this.code, this.code.length - 1, true);
        } else {
            this.code.putByte(n3);
            label.put(this.code, this.code.length - 1, false);
        }
        if (this.currentBasicBlock != null) {
            Label label2 = null;
            if (this.compute == 4) {
                this.currentBasicBlock.frame.execute(n3, 0, null, null);
                label.getCanonicalInstance().flags = (short)(label.getCanonicalInstance().flags | 2);
                this.addSuccessorToCurrentBasicBlock(0, label);
                if (n3 != 167) {
                    label2 = new Label();
                }
            } else if (this.compute == 3) {
                this.currentBasicBlock.frame.execute(n3, 0, null, null);
            } else if (this.compute == 2) {
                this.relativeStackSize += STACK_SIZE_DELTA[n3];
            } else if (n3 == 168) {
                if ((label.flags & 0x20) == 0) {
                    label.flags = (short)(label.flags | 0x20);
                    this.hasSubroutines = true;
                }
                this.currentBasicBlock.flags = (short)(this.currentBasicBlock.flags | 0x10);
                this.addSuccessorToCurrentBasicBlock(this.relativeStackSize + 1, label);
                label2 = new Label();
            } else {
                this.relativeStackSize += STACK_SIZE_DELTA[n3];
                this.addSuccessorToCurrentBasicBlock(this.relativeStackSize, label);
            }
            if (label2 != null) {
                if (bl2) {
                    label2.flags = (short)(label2.flags | 2);
                }
                this.visitLabel(label2);
            }
            if (n3 == 167) {
                this.endCurrentBasicBlockWithNoSuccessor();
            }
        }
    }

    public void visitLabel(Label label) {
        this.hasAsmInstructions |= label.resolve(this.code.data, this.stackMapTableEntries, this.code.length);
        if ((label.flags & 1) != 0) {
            return;
        }
        if (this.compute == 4) {
            if (this.currentBasicBlock != null) {
                if (label.bytecodeOffset == this.currentBasicBlock.bytecodeOffset) {
                    this.currentBasicBlock.flags = (short)(this.currentBasicBlock.flags | label.flags & 2);
                    label.frame = this.currentBasicBlock.frame;
                    return;
                }
                this.addSuccessorToCurrentBasicBlock(0, label);
            }
            if (this.lastBasicBlock != null) {
                if (label.bytecodeOffset == this.lastBasicBlock.bytecodeOffset) {
                    this.lastBasicBlock.flags = (short)(this.lastBasicBlock.flags | label.flags & 2);
                    label.frame = this.lastBasicBlock.frame;
                    this.currentBasicBlock = this.lastBasicBlock;
                    return;
                }
                this.lastBasicBlock.nextBasicBlock = label;
            }
            this.lastBasicBlock = label;
            this.currentBasicBlock = label;
            label.frame = new Frame(label);
        } else if (this.compute == 3) {
            if (this.currentBasicBlock == null) {
                this.currentBasicBlock = label;
            } else {
                this.currentBasicBlock.frame.owner = label;
            }
        } else if (this.compute == 1) {
            if (this.currentBasicBlock != null) {
                this.currentBasicBlock.outputStackMax = (short)this.maxRelativeStackSize;
                this.addSuccessorToCurrentBasicBlock(this.relativeStackSize, label);
            }
            this.currentBasicBlock = label;
            this.relativeStackSize = 0;
            this.maxRelativeStackSize = 0;
            if (this.lastBasicBlock != null) {
                this.lastBasicBlock.nextBasicBlock = label;
            }
            this.lastBasicBlock = label;
        } else if (this.compute == 2 && this.currentBasicBlock == null) {
            this.currentBasicBlock = label;
        }
    }

    public void visitLdcInsn(Object object) {
        char c2;
        boolean bl2;
        this.lastBytecodeOffset = this.code.length;
        Symbol symbol = this.symbolTable.addConstant(object);
        int n2 = symbol.index;
        boolean bl3 = bl2 = symbol.tag == 5 || symbol.tag == 6 || symbol.tag == 17 && ((c2 = symbol.value.charAt(0)) == 'J' || c2 == 'D');
        if (bl2) {
            this.code.put12(20, n2);
        } else if (n2 >= 256) {
            this.code.put12(19, n2);
        } else {
            this.code.put11(18, n2);
        }
        if (this.currentBasicBlock != null) {
            if (this.compute == 4 || this.compute == 3) {
                this.currentBasicBlock.frame.execute(18, 0, symbol, this.symbolTable);
            } else {
                int n3 = this.relativeStackSize + (bl2 ? 2 : 1);
                if (n3 > this.maxRelativeStackSize) {
                    this.maxRelativeStackSize = n3;
                }
                this.relativeStackSize = n3;
            }
        }
    }

    public void visitIincInsn(int n2, int n3) {
        int n4;
        this.lastBytecodeOffset = this.code.length;
        if (n2 > 255 || n3 > 127 || n3 < -128) {
            this.code.putByte(196).put12(132, n2).putShort(n3);
        } else {
            this.code.putByte(132).put11(n2, n3);
        }
        if (this.currentBasicBlock != null && (this.compute == 4 || this.compute == 3)) {
            this.currentBasicBlock.frame.execute(132, n2, null, null);
        }
        if (this.compute != 0 && (n4 = n2 + 1) > this.maxLocals) {
            this.maxLocals = n4;
        }
    }

    public void visitTableSwitchInsn(int n2, int n3, Label label, Label ... labelArray) {
        this.lastBytecodeOffset = this.code.length;
        this.code.putByte(170).putByteArray(null, 0, (4 - this.code.length % 4) % 4);
        label.put(this.code, this.lastBytecodeOffset, true);
        this.code.putInt(n2).putInt(n3);
        for (Label label2 : labelArray) {
            label2.put(this.code, this.lastBytecodeOffset, true);
        }
        this.visitSwitchInsn(label, labelArray);
    }

    public void visitLookupSwitchInsn(Label label, int[] nArray, Label[] labelArray) {
        this.lastBytecodeOffset = this.code.length;
        this.code.putByte(171).putByteArray(null, 0, (4 - this.code.length % 4) % 4);
        label.put(this.code, this.lastBytecodeOffset, true);
        this.code.putInt(labelArray.length);
        for (int i2 = 0; i2 < labelArray.length; ++i2) {
            this.code.putInt(nArray[i2]);
            labelArray[i2].put(this.code, this.lastBytecodeOffset, true);
        }
        this.visitSwitchInsn(label, labelArray);
    }

    private void visitSwitchInsn(Label label, Label[] labelArray) {
        if (this.currentBasicBlock != null) {
            if (this.compute == 4) {
                this.currentBasicBlock.frame.execute(171, 0, null, null);
                this.addSuccessorToCurrentBasicBlock(0, label);
                label.getCanonicalInstance().flags = (short)(label.getCanonicalInstance().flags | 2);
                for (Label label2 : labelArray) {
                    this.addSuccessorToCurrentBasicBlock(0, label2);
                    label2.getCanonicalInstance().flags = (short)(label2.getCanonicalInstance().flags | 2);
                }
            } else if (this.compute == 1) {
                --this.relativeStackSize;
                this.addSuccessorToCurrentBasicBlock(this.relativeStackSize, label);
                for (Label label3 : labelArray) {
                    this.addSuccessorToCurrentBasicBlock(this.relativeStackSize, label3);
                }
            }
            this.endCurrentBasicBlockWithNoSuccessor();
        }
    }

    public void visitMultiANewArrayInsn(String string, int n2) {
        this.lastBytecodeOffset = this.code.length;
        Symbol symbol = this.symbolTable.addConstantClass(string);
        this.code.put12(197, symbol.index).putByte(n2);
        if (this.currentBasicBlock != null) {
            if (this.compute == 4 || this.compute == 3) {
                this.currentBasicBlock.frame.execute(197, n2, symbol, this.symbolTable);
            } else {
                this.relativeStackSize += 1 - n2;
            }
        }
    }

    public AnnotationVisitor visitInsnAnnotation(int n2, TypePath typePath, String string, boolean bl2) {
        if (bl2) {
            this.lastCodeRuntimeVisibleTypeAnnotation = AnnotationWriter.create(this.symbolTable, n2 & 0xFF0000FF | this.lastBytecodeOffset << 8, typePath, string, this.lastCodeRuntimeVisibleTypeAnnotation);
            return this.lastCodeRuntimeVisibleTypeAnnotation;
        }
        this.lastCodeRuntimeInvisibleTypeAnnotation = AnnotationWriter.create(this.symbolTable, n2 & 0xFF0000FF | this.lastBytecodeOffset << 8, typePath, string, this.lastCodeRuntimeInvisibleTypeAnnotation);
        return this.lastCodeRuntimeInvisibleTypeAnnotation;
    }

    public void visitTryCatchBlock(Label label, Label label2, Label label3, String string) {
        Handler handler = new Handler(label, label2, label3, string != null ? this.symbolTable.addConstantClass((String)string).index : 0, string);
        if (this.firstHandler == null) {
            this.firstHandler = handler;
        } else {
            this.lastHandler.nextHandler = handler;
        }
        this.lastHandler = handler;
    }

    public AnnotationVisitor visitTryCatchAnnotation(int n2, TypePath typePath, String string, boolean bl2) {
        if (bl2) {
            this.lastCodeRuntimeVisibleTypeAnnotation = AnnotationWriter.create(this.symbolTable, n2, typePath, string, this.lastCodeRuntimeVisibleTypeAnnotation);
            return this.lastCodeRuntimeVisibleTypeAnnotation;
        }
        this.lastCodeRuntimeInvisibleTypeAnnotation = AnnotationWriter.create(this.symbolTable, n2, typePath, string, this.lastCodeRuntimeInvisibleTypeAnnotation);
        return this.lastCodeRuntimeInvisibleTypeAnnotation;
    }

    public void visitLocalVariable(String string, String string2, String string3, Label label, Label label2, int n2) {
        char c2;
        int n3;
        if (string3 != null) {
            if (this.localVariableTypeTable == null) {
                this.localVariableTypeTable = new ByteVector();
            }
            ++this.localVariableTypeTableLength;
            this.localVariableTypeTable.putShort(label.bytecodeOffset).putShort(label2.bytecodeOffset - label.bytecodeOffset).putShort(this.symbolTable.addConstantUtf8(string)).putShort(this.symbolTable.addConstantUtf8(string3)).putShort(n2);
        }
        if (this.localVariableTable == null) {
            this.localVariableTable = new ByteVector();
        }
        ++this.localVariableTableLength;
        this.localVariableTable.putShort(label.bytecodeOffset).putShort(label2.bytecodeOffset - label.bytecodeOffset).putShort(this.symbolTable.addConstantUtf8(string)).putShort(this.symbolTable.addConstantUtf8(string2)).putShort(n2);
        if (this.compute != 0 && (n3 = n2 + ((c2 = string2.charAt(0)) == 'J' || c2 == 'D' ? 2 : 1)) > this.maxLocals) {
            this.maxLocals = n3;
        }
    }

    public AnnotationVisitor visitLocalVariableAnnotation(int n2, TypePath typePath, Label[] labelArray, Label[] labelArray2, int[] nArray, String string, boolean bl2) {
        ByteVector byteVector = new ByteVector();
        byteVector.putByte(n2 >>> 24).putShort(labelArray.length);
        for (int i2 = 0; i2 < labelArray.length; ++i2) {
            byteVector.putShort(labelArray[i2].bytecodeOffset).putShort(labelArray2[i2].bytecodeOffset - labelArray[i2].bytecodeOffset).putShort(nArray[i2]);
        }
        TypePath.put(typePath, byteVector);
        byteVector.putShort(this.symbolTable.addConstantUtf8(string)).putShort(0);
        if (bl2) {
            this.lastCodeRuntimeVisibleTypeAnnotation = new AnnotationWriter(this.symbolTable, true, byteVector, this.lastCodeRuntimeVisibleTypeAnnotation);
            return this.lastCodeRuntimeVisibleTypeAnnotation;
        }
        this.lastCodeRuntimeInvisibleTypeAnnotation = new AnnotationWriter(this.symbolTable, true, byteVector, this.lastCodeRuntimeInvisibleTypeAnnotation);
        return this.lastCodeRuntimeInvisibleTypeAnnotation;
    }

    public void visitLineNumber(int n2, Label label) {
        if (this.lineNumberTable == null) {
            this.lineNumberTable = new ByteVector();
        }
        ++this.lineNumberTableLength;
        this.lineNumberTable.putShort(label.bytecodeOffset);
        this.lineNumberTable.putShort(n2);
    }

    public void visitMaxs(int n2, int n3) {
        if (this.compute == 4) {
            this.computeAllFrames();
        } else if (this.compute == 1) {
            this.computeMaxStackAndLocal();
        } else if (this.compute == 2) {
            this.maxStack = this.maxRelativeStackSize;
        } else {
            this.maxStack = n2;
            this.maxLocals = n3;
        }
    }

    private void computeAllFrames() {
        int n2;
        Label label;
        Object object;
        Handler handler = this.firstHandler;
        while (handler != null) {
            object = handler.catchTypeDescriptor == null ? "java/lang/Throwable" : handler.catchTypeDescriptor;
            int n3 = Frame.getAbstractTypeFromInternalName(this.symbolTable, (String)object);
            Label label2 = handler.handlerPc.getCanonicalInstance();
            label2.flags = (short)(label2.flags | 2);
            label = handler.startPc.getCanonicalInstance();
            Label label3 = handler.endPc.getCanonicalInstance();
            while (label != label3) {
                label.outgoingEdges = new Edge(n3, label2, label.outgoingEdges);
                label = label.nextBasicBlock;
            }
            handler = handler.nextHandler;
        }
        object = this.firstBasicBlock.frame;
        ((Frame)object).setInputFrameFromDescriptor(this.symbolTable, this.accessFlags, this.descriptor, this.maxLocals);
        ((Frame)object).accept(this);
        Label label4 = this.firstBasicBlock;
        label4.nextListElement = Label.EMPTY_LIST;
        int n4 = 0;
        while (label4 != Label.EMPTY_LIST) {
            label = label4;
            label4 = label4.nextListElement;
            label.nextListElement = null;
            label.flags = (short)(label.flags | 8);
            int n5 = label.frame.getInputStackSize() + label.outputStackMax;
            if (n5 > n4) {
                n4 = n5;
            }
            Edge edge = label.outgoingEdges;
            while (edge != null) {
                Label label5 = edge.successor.getCanonicalInstance();
                n2 = label.frame.merge(this.symbolTable, label5.frame, edge.info) ? 1 : 0;
                if (n2 != 0 && label5.nextListElement == null) {
                    label5.nextListElement = label4;
                    label4 = label5;
                }
                edge = edge.nextEdge;
            }
        }
        label = this.firstBasicBlock;
        while (label != null) {
            int n6;
            Label label6;
            int n7;
            if ((label.flags & 0xA) == 10) {
                label.frame.accept(this);
            }
            if ((label.flags & 8) == 0 && (n7 = ((label6 = label.nextBasicBlock) == null ? this.code.length : label6.bytecodeOffset) - 1) >= (n6 = label.bytecodeOffset)) {
                for (n2 = n6; n2 < n7; ++n2) {
                    this.code.data[n2] = 0;
                }
                this.code.data[n7] = -65;
                n2 = this.visitFrameStart(n6, 0, 1);
                this.currentFrame[n2] = Frame.getAbstractTypeFromInternalName(this.symbolTable, "java/lang/Throwable");
                this.visitFrameEnd();
                this.firstHandler = Handler.removeRange(this.firstHandler, label, label6);
                n4 = Math.max(n4, 1);
            }
            label = label.nextBasicBlock;
        }
        this.maxStack = n4;
    }

    private void computeMaxStackAndLocal() {
        Label label;
        Label label2;
        Handler handler = this.firstHandler;
        while (handler != null) {
            Label label3 = handler.handlerPc;
            label2 = handler.startPc;
            label = handler.endPc;
            while (label2 != label) {
                if ((label2.flags & 0x10) == 0) {
                    label2.outgoingEdges = new Edge(Integer.MAX_VALUE, label3, label2.outgoingEdges);
                } else {
                    label2.outgoingEdges.nextEdge.nextEdge = new Edge(Integer.MAX_VALUE, label3, label2.outgoingEdges.nextEdge.nextEdge);
                }
                label2 = label2.nextBasicBlock;
            }
            handler = handler.nextHandler;
        }
        if (this.hasSubroutines) {
            short s2 = 1;
            this.firstBasicBlock.markSubroutine(s2);
            for (short s3 = 1; s3 <= s2; s3 = (short)(s3 + 1)) {
                label = this.firstBasicBlock;
                while (label != null) {
                    if ((label.flags & 0x10) != 0 && label.subroutineId == s3) {
                        Label label4 = label.outgoingEdges.nextEdge.successor;
                        if (label4.subroutineId == 0) {
                            s2 = (short)(s2 + 1);
                            label4.markSubroutine(s2);
                        }
                    }
                    label = label.nextBasicBlock;
                }
            }
            label2 = this.firstBasicBlock;
            while (label2 != null) {
                if ((label2.flags & 0x10) != 0) {
                    label = label2.outgoingEdges.nextEdge.successor;
                    label.addSubroutineRetSuccessors(label2);
                }
                label2 = label2.nextBasicBlock;
            }
        }
        Label label5 = this.firstBasicBlock;
        label5.nextListElement = Label.EMPTY_LIST;
        int n2 = this.maxStack;
        while (label5 != Label.EMPTY_LIST) {
            label = label5;
            label5 = label5.nextListElement;
            short s4 = label.inputStackSize;
            int n3 = s4 + label.outputStackMax;
            if (n3 > n2) {
                n2 = n3;
            }
            Edge edge = label.outgoingEdges;
            if ((label.flags & 0x10) != 0) {
                edge = edge.nextEdge;
            }
            while (edge != null) {
                Label label6 = edge.successor;
                if (label6.nextListElement == null) {
                    label6.inputStackSize = (short)(edge.info == Integer.MAX_VALUE ? 1 : s4 + edge.info);
                    label6.nextListElement = label5;
                    label5 = label6;
                }
                edge = edge.nextEdge;
            }
        }
        this.maxStack = n2;
    }

    public void visitEnd() {
    }

    private void addSuccessorToCurrentBasicBlock(int n2, Label label) {
        this.currentBasicBlock.outgoingEdges = new Edge(n2, label, this.currentBasicBlock.outgoingEdges);
    }

    private void endCurrentBasicBlockWithNoSuccessor() {
        if (this.compute == 4) {
            Label label = new Label();
            label.frame = new Frame(label);
            label.resolve(this.code.data, this.stackMapTableEntries, this.code.length);
            this.lastBasicBlock.nextBasicBlock = label;
            this.lastBasicBlock = label;
            this.currentBasicBlock = null;
        } else if (this.compute == 1) {
            this.currentBasicBlock.outputStackMax = (short)this.maxRelativeStackSize;
            this.currentBasicBlock = null;
        }
    }

    int visitFrameStart(int n2, int n3, int n4) {
        int n5 = 3 + n3 + n4;
        if (this.currentFrame == null || this.currentFrame.length < n5) {
            this.currentFrame = new int[n5];
        }
        this.currentFrame[0] = n2;
        this.currentFrame[1] = n3;
        this.currentFrame[2] = n4;
        return 3;
    }

    void visitAbstractType(int n2, int n3) {
        this.currentFrame[n2] = n3;
    }

    void visitFrameEnd() {
        if (this.previousFrame != null) {
            if (this.stackMapTableEntries == null) {
                this.stackMapTableEntries = new ByteVector();
            }
            this.putFrame();
            ++this.stackMapTableNumberOfEntries;
        }
        this.previousFrame = this.currentFrame;
        this.currentFrame = null;
    }

    private void putFrame() {
        int n2 = this.currentFrame[1];
        int n3 = this.currentFrame[2];
        if (this.symbolTable.getMajorVersion() < 50) {
            this.stackMapTableEntries.putShort(this.currentFrame[0]).putShort(n2);
            this.putAbstractTypes(3, 3 + n2);
            this.stackMapTableEntries.putShort(n3);
            this.putAbstractTypes(3 + n2, 3 + n2 + n3);
            return;
        }
        int n4 = this.stackMapTableNumberOfEntries == 0 ? this.currentFrame[0] : this.currentFrame[0] - this.previousFrame[0] - 1;
        int n5 = this.previousFrame[1];
        int n6 = n2 - n5;
        int n7 = 255;
        if (n3 == 0) {
            switch (n6) {
                case -3: 
                case -2: 
                case -1: {
                    n7 = 248;
                    break;
                }
                case 0: {
                    n7 = n4 < 64 ? 0 : 251;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n7 = 252;
                    break;
                }
            }
        } else if (n6 == 0 && n3 == 1) {
            int n8 = n7 = n4 < 63 ? 64 : 247;
        }
        if (n7 != 255) {
            int n9 = 3;
            for (int i2 = 0; i2 < n5 && i2 < n2; ++i2) {
                if (this.currentFrame[n9] != this.previousFrame[n9]) {
                    n7 = 255;
                    break;
                }
                ++n9;
            }
        }
        switch (n7) {
            case 0: {
                this.stackMapTableEntries.putByte(n4);
                break;
            }
            case 64: {
                this.stackMapTableEntries.putByte(64 + n4);
                this.putAbstractTypes(3 + n2, 4 + n2);
                break;
            }
            case 247: {
                this.stackMapTableEntries.putByte(247).putShort(n4);
                this.putAbstractTypes(3 + n2, 4 + n2);
                break;
            }
            case 251: {
                this.stackMapTableEntries.putByte(251).putShort(n4);
                break;
            }
            case 248: {
                this.stackMapTableEntries.putByte(251 + n6).putShort(n4);
                break;
            }
            case 252: {
                this.stackMapTableEntries.putByte(251 + n6).putShort(n4);
                this.putAbstractTypes(3 + n5, 3 + n2);
                break;
            }
            default: {
                this.stackMapTableEntries.putByte(255).putShort(n4).putShort(n2);
                this.putAbstractTypes(3, 3 + n2);
                this.stackMapTableEntries.putShort(n3);
                this.putAbstractTypes(3 + n2, 3 + n2 + n3);
            }
        }
    }

    private void putAbstractTypes(int n2, int n3) {
        for (int i2 = n2; i2 < n3; ++i2) {
            Frame.putAbstractType(this.symbolTable, this.currentFrame[i2], this.stackMapTableEntries);
        }
    }

    private void putFrameType(Object object) {
        if (object instanceof Integer) {
            this.stackMapTableEntries.putByte((Integer)object);
        } else if (object instanceof String) {
            this.stackMapTableEntries.putByte(7).putShort(this.symbolTable.addConstantClass((String)((String)object)).index);
        } else {
            this.stackMapTableEntries.putByte(8);
            ((Label)object).put(this.stackMapTableEntries);
        }
    }

    boolean canCopyMethodAttributes(ClassReader classReader, boolean bl2, boolean bl3, int n2, int n3, int n4) {
        boolean bl4;
        if (classReader != this.symbolTable.getSource() || n2 != this.descriptorIndex || n3 != this.signatureIndex || bl3 != ((this.accessFlags & 0x20000) != 0)) {
            return false;
        }
        boolean bl5 = bl4 = this.symbolTable.getMajorVersion() < 49 && (this.accessFlags & 0x1000) != 0;
        if (bl2 != bl4) {
            return false;
        }
        if (n4 == 0) {
            if (this.numberOfExceptions != 0) {
                return false;
            }
        } else if (classReader.readUnsignedShort(n4) == this.numberOfExceptions) {
            int n5 = n4 + 2;
            for (int i2 = 0; i2 < this.numberOfExceptions; ++i2) {
                if (classReader.readUnsignedShort(n5) != this.exceptionIndexTable[i2]) {
                    return false;
                }
                n5 += 2;
            }
        }
        return true;
    }

    void setMethodAttributesSource(int n2, int n3) {
        this.sourceOffset = n2 + 6;
        this.sourceLength = n3 - 6;
    }

    int computeMethodInfoSize() {
        if (this.sourceOffset != 0) {
            return 6 + this.sourceLength;
        }
        int n2 = 8;
        if (this.code.length > 0) {
            if (this.code.length > 65535) {
                throw new MethodTooLargeException(this.symbolTable.getClassName(), this.name, this.descriptor, this.code.length);
            }
            this.symbolTable.addConstantUtf8("Code");
            n2 += 16 + this.code.length + Handler.getExceptionTableSize(this.firstHandler);
            if (this.stackMapTableEntries != null) {
                boolean bl2 = this.symbolTable.getMajorVersion() >= 50;
                this.symbolTable.addConstantUtf8(bl2 ? "StackMapTable" : "StackMap");
                n2 += 8 + this.stackMapTableEntries.length;
            }
            if (this.lineNumberTable != null) {
                this.symbolTable.addConstantUtf8("LineNumberTable");
                n2 += 8 + this.lineNumberTable.length;
            }
            if (this.localVariableTable != null) {
                this.symbolTable.addConstantUtf8("LocalVariableTable");
                n2 += 8 + this.localVariableTable.length;
            }
            if (this.localVariableTypeTable != null) {
                this.symbolTable.addConstantUtf8("LocalVariableTypeTable");
                n2 += 8 + this.localVariableTypeTable.length;
            }
            if (this.lastCodeRuntimeVisibleTypeAnnotation != null) {
                n2 += this.lastCodeRuntimeVisibleTypeAnnotation.computeAnnotationsSize("RuntimeVisibleTypeAnnotations");
            }
            if (this.lastCodeRuntimeInvisibleTypeAnnotation != null) {
                n2 += this.lastCodeRuntimeInvisibleTypeAnnotation.computeAnnotationsSize("RuntimeInvisibleTypeAnnotations");
            }
            if (this.firstCodeAttribute != null) {
                n2 += this.firstCodeAttribute.computeAttributesSize(this.symbolTable, this.code.data, this.code.length, this.maxStack, this.maxLocals);
            }
        }
        if (this.numberOfExceptions > 0) {
            this.symbolTable.addConstantUtf8("Exceptions");
            n2 += 8 + 2 * this.numberOfExceptions;
        }
        n2 += Attribute.computeAttributesSize(this.symbolTable, this.accessFlags, this.signatureIndex);
        n2 += AnnotationWriter.computeAnnotationsSize(this.lastRuntimeVisibleAnnotation, this.lastRuntimeInvisibleAnnotation, this.lastRuntimeVisibleTypeAnnotation, this.lastRuntimeInvisibleTypeAnnotation);
        if (this.lastRuntimeVisibleParameterAnnotations != null) {
            n2 += AnnotationWriter.computeParameterAnnotationsSize("RuntimeVisibleParameterAnnotations", this.lastRuntimeVisibleParameterAnnotations, this.visibleAnnotableParameterCount == 0 ? this.lastRuntimeVisibleParameterAnnotations.length : this.visibleAnnotableParameterCount);
        }
        if (this.lastRuntimeInvisibleParameterAnnotations != null) {
            n2 += AnnotationWriter.computeParameterAnnotationsSize("RuntimeInvisibleParameterAnnotations", this.lastRuntimeInvisibleParameterAnnotations, this.invisibleAnnotableParameterCount == 0 ? this.lastRuntimeInvisibleParameterAnnotations.length : this.invisibleAnnotableParameterCount);
        }
        if (this.defaultValue != null) {
            this.symbolTable.addConstantUtf8("AnnotationDefault");
            n2 += 6 + this.defaultValue.length;
        }
        if (this.parameters != null) {
            this.symbolTable.addConstantUtf8("MethodParameters");
            n2 += 7 + this.parameters.length;
        }
        if (this.firstAttribute != null) {
            n2 += this.firstAttribute.computeAttributesSize(this.symbolTable);
        }
        return n2;
    }

    void putMethodInfo(ByteVector byteVector) {
        boolean bl2 = this.symbolTable.getMajorVersion() < 49;
        int n2 = bl2 ? 4096 : 0;
        byteVector.putShort(this.accessFlags & ~n2).putShort(this.nameIndex).putShort(this.descriptorIndex);
        if (this.sourceOffset != 0) {
            byteVector.putByteArray(this.symbolTable.getSource().classFileBuffer, this.sourceOffset, this.sourceLength);
            return;
        }
        int n3 = 0;
        if (this.code.length > 0) {
            ++n3;
        }
        if (this.numberOfExceptions > 0) {
            ++n3;
        }
        if ((this.accessFlags & 0x1000) != 0 && bl2) {
            ++n3;
        }
        if (this.signatureIndex != 0) {
            ++n3;
        }
        if ((this.accessFlags & 0x20000) != 0) {
            ++n3;
        }
        if (this.lastRuntimeVisibleAnnotation != null) {
            ++n3;
        }
        if (this.lastRuntimeInvisibleAnnotation != null) {
            ++n3;
        }
        if (this.lastRuntimeVisibleParameterAnnotations != null) {
            ++n3;
        }
        if (this.lastRuntimeInvisibleParameterAnnotations != null) {
            ++n3;
        }
        if (this.lastRuntimeVisibleTypeAnnotation != null) {
            ++n3;
        }
        if (this.lastRuntimeInvisibleTypeAnnotation != null) {
            ++n3;
        }
        if (this.defaultValue != null) {
            ++n3;
        }
        if (this.parameters != null) {
            ++n3;
        }
        if (this.firstAttribute != null) {
            n3 += this.firstAttribute.getAttributeCount();
        }
        byteVector.putShort(n3);
        if (this.code.length > 0) {
            int n4 = 10 + this.code.length + Handler.getExceptionTableSize(this.firstHandler);
            int n5 = 0;
            if (this.stackMapTableEntries != null) {
                n4 += 8 + this.stackMapTableEntries.length;
                ++n5;
            }
            if (this.lineNumberTable != null) {
                n4 += 8 + this.lineNumberTable.length;
                ++n5;
            }
            if (this.localVariableTable != null) {
                n4 += 8 + this.localVariableTable.length;
                ++n5;
            }
            if (this.localVariableTypeTable != null) {
                n4 += 8 + this.localVariableTypeTable.length;
                ++n5;
            }
            if (this.lastCodeRuntimeVisibleTypeAnnotation != null) {
                n4 += this.lastCodeRuntimeVisibleTypeAnnotation.computeAnnotationsSize("RuntimeVisibleTypeAnnotations");
                ++n5;
            }
            if (this.lastCodeRuntimeInvisibleTypeAnnotation != null) {
                n4 += this.lastCodeRuntimeInvisibleTypeAnnotation.computeAnnotationsSize("RuntimeInvisibleTypeAnnotations");
                ++n5;
            }
            if (this.firstCodeAttribute != null) {
                n4 += this.firstCodeAttribute.computeAttributesSize(this.symbolTable, this.code.data, this.code.length, this.maxStack, this.maxLocals);
                n5 += this.firstCodeAttribute.getAttributeCount();
            }
            byteVector.putShort(this.symbolTable.addConstantUtf8("Code")).putInt(n4).putShort(this.maxStack).putShort(this.maxLocals).putInt(this.code.length).putByteArray(this.code.data, 0, this.code.length);
            Handler.putExceptionTable(this.firstHandler, byteVector);
            byteVector.putShort(n5);
            if (this.stackMapTableEntries != null) {
                int n6 = this.symbolTable.getMajorVersion() >= 50 ? 1 : 0;
                byteVector.putShort(this.symbolTable.addConstantUtf8(n6 != 0 ? "StackMapTable" : "StackMap")).putInt(2 + this.stackMapTableEntries.length).putShort(this.stackMapTableNumberOfEntries).putByteArray(this.stackMapTableEntries.data, 0, this.stackMapTableEntries.length);
            }
            if (this.lineNumberTable != null) {
                byteVector.putShort(this.symbolTable.addConstantUtf8("LineNumberTable")).putInt(2 + this.lineNumberTable.length).putShort(this.lineNumberTableLength).putByteArray(this.lineNumberTable.data, 0, this.lineNumberTable.length);
            }
            if (this.localVariableTable != null) {
                byteVector.putShort(this.symbolTable.addConstantUtf8("LocalVariableTable")).putInt(2 + this.localVariableTable.length).putShort(this.localVariableTableLength).putByteArray(this.localVariableTable.data, 0, this.localVariableTable.length);
            }
            if (this.localVariableTypeTable != null) {
                byteVector.putShort(this.symbolTable.addConstantUtf8("LocalVariableTypeTable")).putInt(2 + this.localVariableTypeTable.length).putShort(this.localVariableTypeTableLength).putByteArray(this.localVariableTypeTable.data, 0, this.localVariableTypeTable.length);
            }
            if (this.lastCodeRuntimeVisibleTypeAnnotation != null) {
                this.lastCodeRuntimeVisibleTypeAnnotation.putAnnotations(this.symbolTable.addConstantUtf8("RuntimeVisibleTypeAnnotations"), byteVector);
            }
            if (this.lastCodeRuntimeInvisibleTypeAnnotation != null) {
                this.lastCodeRuntimeInvisibleTypeAnnotation.putAnnotations(this.symbolTable.addConstantUtf8("RuntimeInvisibleTypeAnnotations"), byteVector);
            }
            if (this.firstCodeAttribute != null) {
                this.firstCodeAttribute.putAttributes(this.symbolTable, this.code.data, this.code.length, this.maxStack, this.maxLocals, byteVector);
            }
        }
        if (this.numberOfExceptions > 0) {
            byteVector.putShort(this.symbolTable.addConstantUtf8("Exceptions")).putInt(2 + 2 * this.numberOfExceptions).putShort(this.numberOfExceptions);
            for (int n7 : this.exceptionIndexTable) {
                byteVector.putShort(n7);
            }
        }
        Attribute.putAttributes(this.symbolTable, this.accessFlags, this.signatureIndex, byteVector);
        AnnotationWriter.putAnnotations(this.symbolTable, this.lastRuntimeVisibleAnnotation, this.lastRuntimeInvisibleAnnotation, this.lastRuntimeVisibleTypeAnnotation, this.lastRuntimeInvisibleTypeAnnotation, byteVector);
        if (this.lastRuntimeVisibleParameterAnnotations != null) {
            AnnotationWriter.putParameterAnnotations(this.symbolTable.addConstantUtf8("RuntimeVisibleParameterAnnotations"), this.lastRuntimeVisibleParameterAnnotations, this.visibleAnnotableParameterCount == 0 ? this.lastRuntimeVisibleParameterAnnotations.length : this.visibleAnnotableParameterCount, byteVector);
        }
        if (this.lastRuntimeInvisibleParameterAnnotations != null) {
            AnnotationWriter.putParameterAnnotations(this.symbolTable.addConstantUtf8("RuntimeInvisibleParameterAnnotations"), this.lastRuntimeInvisibleParameterAnnotations, this.invisibleAnnotableParameterCount == 0 ? this.lastRuntimeInvisibleParameterAnnotations.length : this.invisibleAnnotableParameterCount, byteVector);
        }
        if (this.defaultValue != null) {
            byteVector.putShort(this.symbolTable.addConstantUtf8("AnnotationDefault")).putInt(this.defaultValue.length).putByteArray(this.defaultValue.data, 0, this.defaultValue.length);
        }
        if (this.parameters != null) {
            byteVector.putShort(this.symbolTable.addConstantUtf8("MethodParameters")).putInt(1 + this.parameters.length).putByte(this.parametersCount).putByteArray(this.parameters.data, 0, this.parameters.length);
        }
        if (this.firstAttribute != null) {
            this.firstAttribute.putAttributes(this.symbolTable, byteVector);
        }
    }

    final void collectAttributePrototypes(Attribute.Set set) {
        set.addAttributes(this.firstAttribute);
        set.addAttributes(this.firstCodeAttribute);
    }
}

