/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oobjw.asm.util;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.oobjw.asm.Opcodes;
import com.contrastsecurity.thirdparty.oobjw.asm.Type;
import com.contrastsecurity.thirdparty.oobjw.asm.tree.AbstractInsnNode;
import com.contrastsecurity.thirdparty.oobjw.asm.tree.FrameNode;
import com.contrastsecurity.thirdparty.oobjw.asm.tree.InsnList;
import com.contrastsecurity.thirdparty.oobjw.asm.tree.InsnNode;
import com.contrastsecurity.thirdparty.oobjw.asm.tree.JumpInsnNode;
import com.contrastsecurity.thirdparty.oobjw.asm.tree.LabelNode;
import com.contrastsecurity.thirdparty.oobjw.asm.tree.LookupSwitchInsnNode;
import com.contrastsecurity.thirdparty.oobjw.asm.tree.MethodNode;
import com.contrastsecurity.thirdparty.oobjw.asm.tree.TableSwitchInsnNode;
import com.contrastsecurity.thirdparty.oobjw.asm.tree.TryCatchBlockNode;
import com.contrastsecurity.thirdparty.oobjw.asm.tree.TypeInsnNode;
import com.contrastsecurity.thirdparty.oobjw.asm.tree.analysis.Analyzer;
import com.contrastsecurity.thirdparty.oobjw.asm.tree.analysis.AnalyzerException;
import com.contrastsecurity.thirdparty.oobjw.asm.tree.analysis.Frame;
import com.contrastsecurity.thirdparty.oobjw.asm.tree.analysis.Interpreter;
import com.contrastsecurity.thirdparty.oobjw.asm.tree.analysis.Value;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CheckFrameAnalyzer<V extends Value>
extends Analyzer<V> {
    private final Interpreter<V> interpreter;
    private InsnList insnList;
    private int currentLocals;

    CheckFrameAnalyzer(Interpreter<V> interpreter) {
        super(interpreter);
        this.interpreter = interpreter;
    }

    @Override
    protected void init(String string, MethodNode methodNode) throws AnalyzerException {
        this.insnList = methodNode.instructions;
        this.currentLocals = Type.getArgumentsAndReturnSizes(methodNode.desc) >> 2;
        if ((methodNode.access & 8) != 0) {
            --this.currentLocals;
        }
        Frame<V>[] frameArray = this.getFrames();
        Frame frame = this.newFrame(frameArray[0]);
        this.expandFrames(string, methodNode, frame);
        for (int i2 = 0; i2 < this.insnList.size(); ++i2) {
            Frame frame2 = frameArray[i2];
            AbstractInsnNode abstractInsnNode = null;
            try {
                Object object;
                Object object2;
                abstractInsnNode = methodNode.instructions.get(i2);
                int n2 = abstractInsnNode.getOpcode();
                int n3 = abstractInsnNode.getType();
                if (n3 == 8 || n3 == 15 || n3 == 14) {
                    this.checkFrame(i2 + 1, frame2, false);
                } else {
                    int n4;
                    frame.init(frame2).execute(abstractInsnNode, this.interpreter);
                    if (abstractInsnNode instanceof JumpInsnNode) {
                        if (n2 == 168) {
                            throw new AnalyzerException(abstractInsnNode, "JSR instructions are unsupported");
                        }
                        object2 = (JumpInsnNode)abstractInsnNode;
                        int n5 = this.insnList.indexOf(((JumpInsnNode)object2).label);
                        this.checkFrame(n5, frame, true);
                        if (n2 == 167) {
                            this.endControlFlow(i2);
                        } else {
                            this.checkFrame(i2 + 1, frame, false);
                        }
                    } else if (abstractInsnNode instanceof LookupSwitchInsnNode) {
                        object2 = (LookupSwitchInsnNode)abstractInsnNode;
                        int n6 = this.insnList.indexOf(((LookupSwitchInsnNode)object2).dflt);
                        this.checkFrame(n6, frame, true);
                        for (n4 = 0; n4 < ((LookupSwitchInsnNode)object2).labels.size(); ++n4) {
                            object = ((LookupSwitchInsnNode)object2).labels.get(n4);
                            n6 = this.insnList.indexOf((AbstractInsnNode)object);
                            frame.initJumpTarget(n2, (LabelNode)object);
                            this.checkFrame(n6, frame, true);
                        }
                        this.endControlFlow(i2);
                    } else if (abstractInsnNode instanceof TableSwitchInsnNode) {
                        object2 = (TableSwitchInsnNode)abstractInsnNode;
                        int n7 = this.insnList.indexOf(((TableSwitchInsnNode)object2).dflt);
                        frame.initJumpTarget(n2, ((TableSwitchInsnNode)object2).dflt);
                        this.checkFrame(n7, frame, true);
                        this.newControlFlowEdge(i2, n7);
                        for (n4 = 0; n4 < ((TableSwitchInsnNode)object2).labels.size(); ++n4) {
                            object = ((TableSwitchInsnNode)object2).labels.get(n4);
                            frame.initJumpTarget(n2, (LabelNode)object);
                            n7 = this.insnList.indexOf((AbstractInsnNode)object);
                            this.checkFrame(n7, frame, true);
                        }
                        this.endControlFlow(i2);
                    } else {
                        if (n2 == 169) {
                            throw new AnalyzerException(abstractInsnNode, "RET instructions are unsupported");
                        }
                        if (n2 != 191 && (n2 < 172 || n2 > 177)) {
                            this.checkFrame(i2 + 1, frame, false);
                        } else {
                            this.endControlFlow(i2);
                        }
                    }
                }
                object2 = this.getHandlers(i2);
                if (object2 != null) {
                    Iterator<TryCatchBlockNode> iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        TryCatchBlockNode tryCatchBlockNode = iterator.next();
                        object = tryCatchBlockNode.type == null ? Type.getObjectType("java/lang/Throwable") : Type.getObjectType(tryCatchBlockNode.type);
                        Frame<V> frame3 = this.newFrame(frame2);
                        frame3.clearStack();
                        frame3.push(this.interpreter.newExceptionValue(tryCatchBlockNode, frame3, (Type)object));
                        this.checkFrame(this.insnList.indexOf(tryCatchBlockNode.handler), frame3, true);
                    }
                }
                if (this.hasNextJvmInsnOrFrame(i2)) continue;
                break;
            }
            catch (AnalyzerException analyzerException) {
                throw new AnalyzerException(analyzerException.node, CheckFrameAnalyzer.stringConcat$0(i2, analyzerException.getMessage()), analyzerException);
            }
            catch (RuntimeException runtimeException) {
                Throwables.throwIfCritical(runtimeException);
                RuntimeException runtimeException2 = runtimeException;
                throw new AnalyzerException(abstractInsnNode, CheckFrameAnalyzer.stringConcat$1(i2, runtimeException2.getMessage()), runtimeException2);
            }
        }
    }

    private static /* synthetic */ String stringConcat$0(int n2, String string) {
        return "Error at instruction " + n2 + ": " + string;
    }

    private static /* synthetic */ String stringConcat$1(int n2, String string) {
        return "Error at instruction " + n2 + ": " + string;
    }

    private void expandFrames(String string, MethodNode methodNode, Frame<V> frame) throws AnalyzerException {
        int n2 = -1;
        Frame<V> frame2 = frame;
        int n3 = 0;
        for (AbstractInsnNode abstractInsnNode : methodNode.instructions) {
            if (abstractInsnNode instanceof FrameNode) {
                try {
                    frame2 = this.expandFrame(string, frame2, (FrameNode)abstractInsnNode);
                }
                catch (AnalyzerException analyzerException) {
                    throw new AnalyzerException(analyzerException.node, CheckFrameAnalyzer.stringConcat$2(n3, analyzerException.getMessage()), analyzerException);
                }
                for (int i2 = n2 + 1; i2 <= n3; ++i2) {
                    this.getFrames()[i2] = frame2;
                }
            }
            if (CheckFrameAnalyzer.isJvmInsnNode(abstractInsnNode) || abstractInsnNode instanceof FrameNode) {
                n2 = n3;
            }
            ++n3;
        }
    }

    private static /* synthetic */ String stringConcat$2(int n2, String string) {
        return "Error at instruction " + n2 + ": " + string;
    }

    private Frame<V> expandFrame(String string, Frame<V> frame, FrameNode frameNode) throws AnalyzerException {
        Object object;
        Frame<Object> frame2 = this.newFrame(frame);
        List<Object> list = frameNode.local == null ? Collections.emptyList() : frameNode.local;
        int n2 = this.currentLocals;
        switch (frameNode.type) {
            case -1: 
            case 0: {
                n2 = 0;
            }
            case 1: {
                for (Object iterator2 : list) {
                    object = this.newFrameValue(string, frameNode, iterator2);
                    if (n2 + object.getSize() > frame2.getLocals()) {
                        throw new AnalyzerException(frameNode, "Cannot append more locals than maxLocals");
                    }
                    frame2.setLocal(n2++, object);
                    if (object.getSize() != 2) continue;
                    frame2.setLocal(n2++, this.interpreter.newValue(null));
                }
                break;
            }
            case 2: {
                for (Object object2 : list) {
                    if (n2 <= 0) {
                        throw new AnalyzerException(frameNode, "Cannot chop more locals than defined");
                    }
                    if (n2 > 1 && frame2.getLocal(n2 - 2).getSize() == 2) {
                        n2 -= 2;
                        continue;
                    }
                    --n2;
                }
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new AnalyzerException(frameNode, CheckFrameAnalyzer.stringConcat$3(frameNode.type));
            }
        }
        this.currentLocals = n2;
        while (n2 < frame2.getLocals()) {
            frame2.setLocal(n2++, this.interpreter.newValue(null));
        }
        List<Object> list2 = frameNode.stack == null ? Collections.emptyList() : frameNode.stack;
        frame2.clearStack();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            frame2.push(this.newFrameValue(string, frameNode, object));
        }
        return frame2;
    }

    private static /* synthetic */ String stringConcat$3(int n2) {
        return "Illegal frame type " + n2;
    }

    private V newFrameValue(String string, FrameNode frameNode, Object object) throws AnalyzerException {
        if (object == Opcodes.TOP) {
            return this.interpreter.newValue(null);
        }
        if (object == Opcodes.INTEGER) {
            return this.interpreter.newValue(Type.INT_TYPE);
        }
        if (object == Opcodes.FLOAT) {
            return this.interpreter.newValue(Type.FLOAT_TYPE);
        }
        if (object == Opcodes.LONG) {
            return this.interpreter.newValue(Type.LONG_TYPE);
        }
        if (object == Opcodes.DOUBLE) {
            return this.interpreter.newValue(Type.DOUBLE_TYPE);
        }
        if (object == Opcodes.NULL) {
            return this.interpreter.newOperation(new InsnNode(1));
        }
        if (object == Opcodes.UNINITIALIZED_THIS) {
            return this.interpreter.newValue(Type.getObjectType(string));
        }
        if (object instanceof String) {
            return this.interpreter.newValue(Type.getObjectType((String)object));
        }
        if (object instanceof LabelNode) {
            AbstractInsnNode abstractInsnNode;
            for (abstractInsnNode = (LabelNode)object; abstractInsnNode != null && !CheckFrameAnalyzer.isJvmInsnNode(abstractInsnNode); abstractInsnNode = abstractInsnNode.getNext()) {
            }
            if (abstractInsnNode == null || abstractInsnNode.getOpcode() != 187) {
                throw new AnalyzerException(frameNode, "LabelNode does not designate a NEW instruction");
            }
            return this.interpreter.newValue(Type.getObjectType(((TypeInsnNode)abstractInsnNode).desc));
        }
        throw new AnalyzerException(frameNode, CheckFrameAnalyzer.stringConcat$4(object));
    }

    private static /* synthetic */ String stringConcat$4(Object object) {
        return "Illegal stack map frame value " + object;
    }

    private void checkFrame(int n2, Frame<V> frame, boolean bl2) throws AnalyzerException {
        Frame frame2 = this.getFrames()[n2];
        if (frame2 == null) {
            if (bl2) {
                throw new AnalyzerException(null, CheckFrameAnalyzer.stringConcat$5(n2));
            }
            this.getFrames()[n2] = this.newFrame(frame);
        } else {
            String string = this.checkMerge(frame, frame2);
            if (string != null) {
                throw new AnalyzerException(null, CheckFrameAnalyzer.stringConcat$6(n2, string));
            }
        }
    }

    private static /* synthetic */ String stringConcat$5(int n2) {
        return "Expected stack map frame at instruction " + n2;
    }

    private static /* synthetic */ String stringConcat$6(int n2, String string) {
        return "Stack map frame incompatible with frame at instruction " + n2 + " (" + string + ")";
    }

    private String checkMerge(Frame<V> frame, Frame<V> frame2) {
        int n2;
        int n3 = frame.getLocals();
        if (n3 != frame2.getLocals()) {
            throw new AssertionError();
        }
        for (n2 = 0; n2 < n3; ++n2) {
            V v2 = this.interpreter.merge(frame.getLocal(n2), frame2.getLocal(n2));
            if (v2.equals(frame2.getLocal(n2))) continue;
            return CheckFrameAnalyzer.stringConcat$7(n2, frame.getLocal(n2), frame2.getLocal(n2));
        }
        n2 = frame.getStackSize();
        if (n2 != frame2.getStackSize()) {
            return "incompatible stack heights";
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            V v3 = this.interpreter.merge(frame.getStack(i2), frame2.getStack(i2));
            if (v3.equals(frame2.getStack(i2))) continue;
            return CheckFrameAnalyzer.stringConcat$8(i2, frame.getStack(i2), frame2.getStack(i2));
        }
        return null;
    }

    private static /* synthetic */ String stringConcat$7(int n2, Value value, Value value2) {
        return "incompatible types at local " + n2 + ": " + value + " and " + value2;
    }

    private static /* synthetic */ String stringConcat$8(int n2, Value value, Value value2) {
        return "incompatible types at stack item " + n2 + ": " + value + " and " + value2;
    }

    private void endControlFlow(int n2) throws AnalyzerException {
        if (this.hasNextJvmInsnOrFrame(n2) && this.getFrames()[n2 + 1] == null) {
            throw new AnalyzerException(null, CheckFrameAnalyzer.stringConcat$9(n2 + 1));
        }
    }

    private static /* synthetic */ String stringConcat$9(int n2) {
        return "Expected stack map frame at instruction " + n2;
    }

    private boolean hasNextJvmInsnOrFrame(int n2) {
        for (AbstractInsnNode abstractInsnNode = this.insnList.get(n2).getNext(); abstractInsnNode != null; abstractInsnNode = abstractInsnNode.getNext()) {
            if (!CheckFrameAnalyzer.isJvmInsnNode(abstractInsnNode) && !(abstractInsnNode instanceof FrameNode)) continue;
            return true;
        }
        return false;
    }

    private static boolean isJvmInsnNode(AbstractInsnNode abstractInsnNode) {
        return abstractInsnNode.getOpcode() >= 0;
    }
}

