/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent;

import com.contrastsecurity.agent.boot.DenylistedProcessCheck;
import com.contrastsecurity.agent.commons.StartupTiming;
import com.contrastsecurity.agent.core.ContrastAgent;
import com.contrastsecurity.agent.core.ContrastAgentDiagnostic;
import com.contrastsecurity.agent.injection.ClassInjector;
import com.contrastsecurity.agent.util.ContrastAgentUtil;
import java.io.File;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ContrastStarter {
    private static final AtomicBoolean ATTACHED = new AtomicBoolean();
    private static final boolean STRICT_STARTUP = "true".equalsIgnoreCase(ContrastStarter.getProperty("contrast.agent.java.strict.startup"));

    public static void start(String args, Instrumentation inst) {
        if (ATTACHED.getAndSet(true)) {
            System.err.println("The Contrast Agent is already attached, verify that your VM arguments don't include `-javaagent` twice for the Contrast Agent.");
            return;
        }
        if (DenylistedProcessCheck.isDenied(ContrastStarter.getStartCommand())) {
            return;
        }
        File agentJarFile = ContrastAgentUtil.findAgentJar();
        if (agentJarFile == null) {
            System.err.println("The Contrast Agent is missing a required configuration of the `contrast.agent.location` system property. Continuing application startup without Contrast Agent....");
            ContrastStarter.crashIfStrict();
            return;
        }
        long premainStart = System.nanoTime();
        long jvmUptime = ContrastStarter.getJvmUptime();
        try {
            ClassInjector.inject(inst, agentJarFile);
            long timeForInjectNs = System.nanoTime() - premainStart;
            StartupTiming startupTiming = new StartupTiming(premainStart, jvmUptime, timeForInjectNs);
            ContrastAgent.setup(STRICT_STARTUP, args, inst, agentJarFile, startupTiming);
        }
        catch (AccessControlException e2) {
            System.err.println("When using a Java SecurityManager, the Contrast agent requires the java.security.AllPermission. Continuing without Contrast...");
            e2.printStackTrace(System.err);
            ContrastStarter.crashIfStrict();
        }
        catch (Exception e3) {
            e3.printStackTrace(System.err);
            System.err.println("Unexpected error during Contrast Agent initialization. Continuing application startup without Contrast Agent....");
            ContrastStarter.crashIfStrict();
        }
    }

    private static void crashIfStrict() {
        if (STRICT_STARTUP) {
            System.err.println("Error occurred during Contrast strict startup. Shutting down application.");
            System.exit(1);
        }
    }

    private static long getJvmUptime() {
        RuntimeMXBean mxBean = ManagementFactory.getRuntimeMXBean();
        return mxBean != null ? mxBean.getUptime() : 0L;
    }

    private static String getStartCommand() {
        try {
            return ContrastStarter.getProperty("sun.java.command");
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static String getProperty(String property) {
        return System.getSecurityManager() == null ? System.getProperty(property) : AccessController.doPrivileged(() -> System.getProperty(property));
    }

    public static void diagnostics(String[] args) {
        File agentJarFile = ContrastAgentUtil.findAgentJar();
        if (agentJarFile == null) {
            System.err.println("The Contrast Agent is missing a required configuration of the `contrast.agent.location` system property. Cannot run diagnostics.");
            return;
        }
        ContrastAgentDiagnostic.runDiagnosticTool(agentJarFile, args);
    }

    private ContrastStarter() {
    }
}

