/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.commons;

import com.contrastsecurity.agent.DontObfuscate;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;

@DontObfuscate
public final class Iterators {
    private Iterators() {
    }

    public static <E, W> Iterable<E> convertIterable(Iterable<W> iterable, Function<? super W, ? extends E> function) {
        Objects.requireNonNull(iterable);
        Objects.requireNonNull(function);
        return () -> new a(iterable, function);
    }

    public static <E> Iterator<E> unmodifiable(Iterable<E> iterable) {
        final Iterator<E> iterator = Objects.requireNonNull(iterable).iterator();
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public E next() {
                return iterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <E> Iterator<E> filterIterator(Collection<? extends E> collection, Predicate<? super E> predicate) {
        return new b(collection, predicate);
    }

    public static <E> Iterator<E> fixedList(List<? extends E> list) {
        return list == null || list.isEmpty() ? Collections.emptyIterator() : new c<E>(list);
    }

    private static final class b<E>
    implements Iterator<E> {
        private final Iterator<? extends E> a;
        private final Predicate<? super E> b;
        private E c;
        private boolean d;

        private b(Collection<? extends E> collection, Predicate<? super E> predicate) {
            this.a = Objects.requireNonNull(collection).iterator();
            this.b = Objects.requireNonNull(predicate);
        }

        @Override
        public boolean hasNext() {
            return this.d || this.a();
        }

        @Override
        public E next() {
            if (!this.d && !this.a()) {
                throw new NoSuchElementException();
            }
            this.d = false;
            return this.c;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private boolean a() {
            while (this.a.hasNext()) {
                E e2 = this.a.next();
                if (!this.b.test(e2)) continue;
                this.c = e2;
                this.d = true;
                return true;
            }
            return false;
        }
    }

    private static final class c<E>
    implements Iterator<E> {
        private final List<? extends E> a;
        private final int b;
        private int c;

        public c(List<? extends E> list) {
            this.a = list;
            this.b = list.size();
        }

        @Override
        public boolean hasNext() {
            return this.c < this.b;
        }

        @Override
        public E next() {
            return this.a.get(this.c++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Removal is not supported");
        }
    }

    private static final class a<E, W>
    implements Iterator<E> {
        final Iterator<W> a;
        final Function<? super W, ? extends E> b;

        private a(Iterable<W> iterable, Function<? super W, ? extends E> function) {
            this.a = Objects.requireNonNull(iterable).iterator();
            this.b = Objects.requireNonNull(function);
        }

        @Override
        public boolean hasNext() {
            return this.a.hasNext();
        }

        @Override
        public E next() {
            return this.b.apply(this.a.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

