/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.commons;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.Preconditions;
import com.contrastsecurity.agent.commons.Sets;
import com.contrastsecurity.agent.commons.throwables.ClassNotFound;
import com.contrastsecurity.agent.commons.throwables.ClassNotFoundException;
import com.contrastsecurity.agent.commons.throwables.NoClassDefFoundError;
import com.contrastsecurity.agent.commons.throwables.UnhandledException;
import com.contrastsecurity.agent.plugins.protect.AttackBlockedException;
import com.contrastsecurity.agent.util.ContrastAgentUtil;
import java.lang.reflect.InvocationTargetException;
import java.security.PrivilegedActionException;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;

@DontObfuscate
public final class Throwables {
    public static final Set<Class<? extends Throwable>> CRITICAL_THROWABLES = Sets.of(ThreadDeath.class, OutOfMemoryError.class, AttackBlockedException.class);
    public static final Set<Class<? extends Throwable>> WRAPPER_THROWABLES = Sets.of(InvocationTargetException.class, PrivilegedActionException.class);

    public static <T extends Throwable> T addSuppressed(T t2, Collection<Throwable> collection) {
        for (Throwable throwable : collection) {
            t2.addSuppressed(throwable);
        }
        return t2;
    }

    public static void throwIfCritical(Throwable throwable) {
        throwable = Throwables.unwrap(throwable, 5);
        for (Class<? extends Throwable> clazz : CRITICAL_THROWABLES) {
            if (!clazz.isInstance(throwable)) continue;
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new IllegalStateException("Unexpected critical checked exception found " + throwable.getClass().getTypeName());
        }
    }

    private static Throwable unwrap(Throwable throwable, int n2) {
        Throwable throwable2 = throwable;
        while (n2 >= 0 && (throwable instanceof PrivilegedActionException || throwable instanceof InvocationTargetException)) {
            throwable = throwable.getCause();
            --n2;
        }
        if (n2 < 0 || throwable == null) {
            return throwable2;
        }
        return throwable;
    }

    public static Throwable unwrap(InvocationTargetException invocationTargetException, int n2) {
        return Throwables.unwrap((Throwable)invocationTargetException, n2);
    }

    public static Throwable unwrap(PrivilegedActionException privilegedActionException, int n2) {
        return Throwables.unwrap((Throwable)privilegedActionException, n2);
    }

    public static Throwable addClassLoaderInfoIfNecessary(Throwable throwable) {
        if (!(throwable instanceof java.lang.ClassNotFoundException) && !(throwable instanceof java.lang.NoClassDefFoundError)) {
            return throwable;
        }
        if (throwable instanceof ClassNotFound) {
            return throwable;
        }
        String string = null;
        for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
            if (!ContrastAgentUtil.isAgentClass(stackTraceElement.getClassName())) continue;
            try {
                ClassLoader classLoader = Class.forName(stackTraceElement.getClassName(), false, Throwables.class.getClassLoader()).getClassLoader();
                string = Throwables.classNotFoundErrorMessage(throwable.getMessage(), classLoader);
                break;
            }
            catch (Throwable throwable2) {
                Throwables.throwIfCritical(throwable2);
                Throwable throwable3 = throwable2;
                return throwable;
            }
        }
        if (string == null) {
            return throwable;
        }
        return throwable instanceof java.lang.ClassNotFoundException ? new ClassNotFoundException(string, throwable) : new NoClassDefFoundError(string, throwable);
    }

    public static String classNotFoundErrorMessage(String string, ClassLoader classLoader) {
        if (classLoader == null) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null) {
            stringBuilder.append(string).append(" ");
        }
        stringBuilder.append("Unable to define or load class. Attempted to define class with: ").append(classLoader.getClass().getTypeName()).append(". Attempted to load class with:\n");
        for (int n2 = 5; classLoader != null && n2 > 0; classLoader = classLoader.getParent(), --n2) {
            stringBuilder.append(classLoader.getClass().getTypeName()).append("\n");
        }
        if (classLoader != null) {
            stringBuilder.append("\n...truncated...");
        }
        return stringBuilder.toString();
    }

    public static <T extends Throwable> T propagate(InvocationTargetException invocationTargetException, Class<T> clazz) throws T {
        return Throwables.propagate((Throwable)invocationTargetException, clazz);
    }

    public static <T extends Throwable> T propagate(PrivilegedActionException privilegedActionException, Class<T> clazz) throws T {
        return Throwables.propagate((Throwable)privilegedActionException, clazz);
    }

    private static <T extends Throwable> T propagate(Throwable throwable, Class<T> clazz) throws T {
        Preconditions.check(throwable instanceof InvocationTargetException || throwable instanceof PrivilegedActionException, "Unexpected throwable of type: " + throwable.getClass().getTypeName() + ". Throwable may not be a wrapper type.");
        Preconditions.check(clazz == null || !clazz.isAssignableFrom(RuntimeException.class) || !clazz.isAssignableFrom(Error.class), "expectedCheckedThrowableType must be a checked exception type.");
        throwable = Throwables.unwrap(throwable, 5);
        Objects.requireNonNull(throwable);
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (null != clazz && clazz.isInstance(throwable)) {
            throw (Throwable)clazz.cast(throwable);
        }
        throw new UnhandledException(throwable);
    }

    private Throwables() {
    }
}

