/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.context;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.ApplicationContext;
import com.contrastsecurity.agent.commons.b;
import com.contrastsecurity.agent.context.d;
import com.contrastsecurity.agent.http.HttpContext;
import com.contrastsecurity.agent.plugins.observe.RootSpan;
import com.contrastsecurity.agent.plugins.protect.ProtectContext;
import com.contrastsecurity.agent.plugins.security.AssessmentContext;
import com.contrastsecurity.agent.q;
import com.contrastsecurity.agent.scope.ScopeArchitecture;
import com.contrastsecurity.agent.scope.ScopeAssess;
import com.contrastsecurity.agent.scope.ScopeGeneral;
import com.contrastsecurity.agent.scope.ScopeProvider;
import com.contrastsecurity.agent.scope.ScopeProviderImpl;
import com.contrastsecurity.agent.scope.ScopeType;
import com.contrastsecurity.agent.scope.Scoping;
import java.util.HashMap;
import java.util.Map;

@DontObfuscate
public class ContrastContext
implements b<ContrastContext> {
    private final HttpContext http;
    private final ApplicationContext application;
    private final ScopeProvider scopeProvider;
    private final ScopeArchitecture scopeArchitecture;
    private final Scoping scoping;
    private final Map<String, ScopeGeneral> codeExclusions;
    private AssessmentContext assessment;
    private ProtectContext protect;
    private RootSpan observe;
    private final d threadLocals;
    protected static ThreadLocal<ContrastContext> CONTEXT;

    protected ContrastContext() {
        this.http = new HttpContext();
        this.application = new ApplicationContext();
        this.scoping = new Scoping();
        this.scopeProvider = new ScopeProviderImpl(this.scoping);
        this.scopeArchitecture = new ScopeArchitecture();
        this.codeExclusions = new HashMap<String, ScopeGeneral>();
        this.threadLocals = new d();
    }

    protected ContrastContext(ContrastContext contrastContext) {
        this.http = contrastContext.http().copy();
        this.application = contrastContext.application().copy();
        this.assessment = contrastContext.assessment();
        this.protect = contrastContext.protect();
        this.observe = contrastContext.observe();
        this.scoping = new Scoping();
        this.scopeProvider = new ScopeProviderImpl(this.scoping);
        this.scopeArchitecture = new ScopeArchitecture();
        this.codeExclusions = new HashMap<String, ScopeGeneral>();
        this.threadLocals = new d();
    }

    public static void initialize() {
        ApplicationContext.class.getName();
        AssessmentContext.class.getName();
        HttpContext.class.getName();
        ProtectContext.class.getName();
        RootSpan.class.getName();
        Scoping.class.getName();
        ScopeType.class.getName();
        ScopeProvider.class.getName();
        ScopeProviderImpl.class.getName();
        ScopeArchitecture.class.getName();
        ScopeAssess.class.getName();
        d.class.getName();
    }

    public void clear() {
        this.assessment = null;
        this.protect = null;
        this.observe = null;
        this.application.clear();
        this.http.clear();
        this.threadLocals.g();
    }

    @q
    public void resetForTesting() {
        this.clear();
        this.scoping.reset();
        this.codeExclusions.clear();
    }

    public ApplicationContext application() {
        return this.application;
    }

    public AssessmentContext assessment() {
        if (this.assessment != null) {
            this.assessment.updateLastAccess();
        }
        return this.assessment;
    }

    public AssessmentContext assessment(AssessmentContext assessmentContext) {
        this.assessment = assessmentContext;
        return assessmentContext;
    }

    public HttpContext http() {
        return this.http;
    }

    public RootSpan observe() {
        return this.observe;
    }

    public RootSpan observe(RootSpan rootSpan) {
        this.observe = rootSpan;
        return rootSpan;
    }

    public ProtectContext protect() {
        if (this.protect == null) {
            this.protect = new ProtectContext();
        }
        return this.protect;
    }

    public ProtectContext protect(ProtectContext protectContext) {
        this.protect = protectContext;
        return protectContext;
    }

    public ScopeProvider scopeProvider() {
        return this.scopeProvider;
    }

    public Scoping scope() {
        return this.scoping;
    }

    public ScopeArchitecture scopeArchitecture() {
        return this.scopeArchitecture;
    }

    public Map<String, ScopeGeneral> codeExclusions() {
        return this.codeExclusions;
    }

    public d threadLocals() {
        return this.threadLocals;
    }

    @Override
    public ContrastContext copy() {
        return new ContrastContext(this);
    }

    public String toString() {
        return "ContrastContext{application=" + this.application + ", http=" + this.http + ", scopeProvider=" + this.scopeProvider + ", scopeArchitecture=" + this.scopeArchitecture + ", additionalScopes=" + this.scoping + ", assessment=" + this.assessment + ", protect=" + this.protect + ", observe=" + this.observe + '}';
    }

    public static ContrastContext current() {
        return CONTEXT.get();
    }

    public static void enableThreadLocal() {
        CONTEXT = ThreadLocal.withInitial(ContrastContext::new);
    }

    public String toSummaryString() {
        return "ContrastContext{http=" + this.http.identities() + ", uri='" + this.http.toUriString() + "', assessment=" + (this.assessment != null ? this.assessment.toSummaryString() : "null") + '}';
    }
}

