/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.observe.java.file;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.config.Config;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.o;
import com.contrastsecurity.agent.plugins.observe.RootSpan;
import com.contrastsecurity.agent.plugins.observe.d;
import com.contrastsecurity.thirdparty.ccsso.semconv.ContrastSemanticAttributes;
import com.contrastsecurity.thirdparty.iot.api.common.Attributes;
import com.contrastsecurity.thirdparty.iot.api.trace.Span;
import com.contrastsecurity.thirdparty.iot.context.Context;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;

@DontObfuscate
@o
public final class FileOpenCreateDispatcherImpl
implements ContrastObserveFileOpenCreateDispatcher {
    private final Config config;
    private static final Logger logger = LoggerFactory.getLogger(FileOpenCreateDispatcherImpl.class);

    public FileOpenCreateDispatcherImpl(Config config) {
        this.config = config;
    }

    public Object string(Object object, String string, String string2) {
        if (!this.config.getBoolean(ConfigProperty.OBSERVE_ENABLE)) {
            return null;
        }
        ContrastContext contrastContext = (ContrastContext)object;
        HttpRequest httpRequest = contrastContext.http().getRequest();
        if (httpRequest == null) {
            return null;
        }
        if (FileOpenCreateDispatcherImpl.shouldIgnore(string2)) {
            return null;
        }
        Span span = this.onFileAccess(contrastContext, string);
        if (span != null) {
            span.setAttribute(ContrastSemanticAttributes.FILE_OPEN_PATH, string2);
        }
        return span;
    }

    public Object uri(Object object, String string, URI uRI) {
        if (!this.config.getBoolean(ConfigProperty.OBSERVE_ENABLE)) {
            return null;
        }
        ContrastContext contrastContext = (ContrastContext)object;
        HttpRequest httpRequest = contrastContext.http().getRequest();
        if (httpRequest == null) {
            return null;
        }
        String string2 = uRI.getPath();
        if (FileOpenCreateDispatcherImpl.shouldIgnore(string2)) {
            return null;
        }
        Span span = this.onFileAccess(contrastContext, string);
        if (span != null) {
            span.setAttribute(ContrastSemanticAttributes.FILE_OPEN_PATH, string2);
        }
        return span;
    }

    public void onFileReturnObserved(Object object, File file, String string) {
        if (file == null) {
            return;
        }
        try {
            this.startAndStopFileSpan((ContrastContext)object, file.getPath(), string);
        }
        catch (NullPointerException nullPointerException) {
            logger.debug("Encountered an NPE attempting to get the path of a file", nullPointerException);
        }
    }

    public void onPathObserved(Object object, Path path, String string) {
        if (path == null) {
            return;
        }
        try {
            this.startAndStopFileSpan((ContrastContext)object, path.toString(), string);
        }
        catch (NullPointerException nullPointerException) {
            logger.debug("Encountered an NPE attempting to get the path of a file", nullPointerException);
        }
    }

    private void startAndStopFileSpan(ContrastContext contrastContext, String string, String string2) {
        if (!this.config.getBoolean(ConfigProperty.OBSERVE_ENABLE)) {
            return;
        }
        Application application = contrastContext.application().current();
        if (application == null) {
            return;
        }
        if (FileOpenCreateDispatcherImpl.shouldIgnore(string)) {
            return;
        }
        RootSpan rootSpan = contrastContext.observe();
        if (rootSpan == null || !rootSpan.isRecording()) {
            return;
        }
        Span span = FileOpenCreateDispatcherImpl.onFileAccess(contrastContext, rootSpan, string2);
        if (span == null) {
            return;
        }
        span.setAttribute(ContrastSemanticAttributes.FILE_OPEN_PATH, string);
        span.end();
        rootSpan.popContext();
        application.otel().c().add(1L, Attributes.of(ContrastSemanticAttributes.ACTION, "file-open-create", ContrastSemanticAttributes.HTTP_REQUEST_METHOD, rootSpan.getHttpMethod(), ContrastSemanticAttributes.HTTP_ROUTE, rootSpan.getHttpRoute()), span.storeInContext(Context.current()));
    }

    public void onActionEnd(Object object, Object object2) {
        ContrastContext contrastContext = (ContrastContext)object;
        d.a(this.config, object2, contrastContext.observe(), contrastContext.application().current(), "file-open-create");
    }

    private Span onFileAccess(ContrastContext contrastContext, String string) {
        return FileOpenCreateDispatcherImpl.onFileAccess(contrastContext, contrastContext.observe(), string);
    }

    private static Span onFileAccess(ContrastContext contrastContext, RootSpan rootSpan, String string) {
        return rootSpan != null && rootSpan.isRecording() ? rootSpan.startChildSpan(contrastContext, "file-open-create", string) : null;
    }

    private static boolean shouldIgnore(String string) {
        return string == null || string.isEmpty() || string.endsWith(".class") || string.endsWith(".jar") || string.endsWith(".war") || string.endsWith(".ear") || string.endsWith(".css");
    }
}

