/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.protect;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.exclusions.d;
import com.contrastsecurity.agent.apps.exclusions.e;
import com.contrastsecurity.agent.commons.Clock;
import com.contrastsecurity.agent.commons.Iterators;
import com.contrastsecurity.agent.commons.Lists;
import com.contrastsecurity.agent.config.Config;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.contrastapi_v1_0.settings.server.ServerSettingsProtectDTM;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.messages.app.activity.protect.details.UserInputDTM;
import com.contrastsecurity.agent.messages.app.settings.ExceptionInputTypeDTM;
import com.contrastsecurity.agent.messages.app.settings.protect.CommonConfigProtectionMode;
import com.contrastsecurity.agent.messages.app.settings.protect.ProtectionModeDTM;
import com.contrastsecurity.agent.messages.server.features.protect.LogEnhancerDTM;
import com.contrastsecurity.agent.o;
import com.contrastsecurity.agent.plugins.protect.AttackBlockedException;
import com.contrastsecurity.agent.plugins.protect.F;
import com.contrastsecurity.agent.plugins.protect.ProtectContext;
import com.contrastsecurity.agent.plugins.protect.ProtectRuleId;
import com.contrastsecurity.agent.plugins.protect.g.e;
import com.contrastsecurity.agent.plugins.protect.rules.k;
import com.contrastsecurity.agent.plugins.protect.rules.l;
import com.contrastsecurity.agent.plugins.protect.rules.p;
import com.contrastsecurity.agent.q;
import com.contrastsecurity.agent.scope.DequeScope;
import com.contrastsecurity.agent.telemetry.metrics.TelemetryMetrics;
import com.contrastsecurity.agent.telemetry.metrics.b.b;
import com.contrastsecurity.agent.telemetry.metrics.d;
import com.contrastsecurity.agent.telemetry.metrics.i;
import com.contrastsecurity.agent.util.PreConfigUtil;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

@DontObfuscate
@o
public class ProtectManager
implements e {
    private final CommonConfigProtectionMode globalOverrideMode;
    private final Config config;
    private final com.contrastsecurity.agent.plugins.protect.b.c canonicalizer;
    private final TelemetryMetrics metrics;
    private final Clock clock;
    private final d.b<F, i> requestTimeMetrics;
    private final com.contrastsecurity.agent.telemetry.metrics.b.b timingAnomalyEventFactory;
    private com.contrastsecurity.agent.plugins.protect.c.c deadzoneManager;
    private Collection<p> rules;
    private Map<ProtectRuleId, p> ruleById;
    private List<k> inputAwareRules;
    private Map<Long, LogEnhancerDTM> logEnhancers;
    private List<com.contrastsecurity.agent.plugins.protect.a> logEnhancerList;
    private Set<String> userTargetedClasses;
    private volatile boolean activated;
    private static final Logger logger = LoggerFactory.getLogger(ProtectManager.class);

    @q
    public static d.b<F, i> buildRequestTimeMetrics(TelemetryMetrics telemetryMetrics) {
        i.a a2 = telemetryMetrics.newTimer("requestTime", TelemetryMetrics.TelemetryCategory.PERFORMANCE_PROTECT).a("Records time taken to handle requests end-to-end, split by constituent parts (e.g. source analysis, sink analysis, etc.)").a(Duration.ofNanos(10000L), Duration.ofNanos(100000L), Duration.ofNanos(500000L), Duration.ofMillis(1L), Duration.ofMillis(5L), Duration.ofMillis(10L), Duration.ofMillis(50L), Duration.ofMillis(100L), Duration.ofMillis(250L), Duration.ofMillis(500L), Duration.ofSeconds(1L), Duration.ofSeconds(10L), Duration.ofMinutes(1L));
        return telemetryMetrics.newGrouped(a2).a("aspect").a(F.class);
    }

    public ProtectManager(Config config, TelemetryMetrics telemetryMetrics, com.contrastsecurity.agent.telemetry.metrics.b.b b2, Clock clock) {
        this.config = Objects.requireNonNull(config);
        this.metrics = Objects.requireNonNull(telemetryMetrics);
        this.clock = Objects.requireNonNull(clock);
        this.requestTimeMetrics = ProtectManager.buildRequestTimeMetrics(telemetryMetrics);
        this.timingAnomalyEventFactory = b2;
        this.canonicalizer = new com.contrastsecurity.agent.plugins.protect.b.c(telemetryMetrics, clock);
        if (!config.getBoolean(ConfigProperty.PROTECT_SINKS)) {
            PreConfigUtil.out("Disabling defensive instrumentation sensors. No attacks can be blocked or confirmed exploited.");
        }
        this.globalOverrideMode = ProtectManager.calcGlobalModeOverride(config);
    }

    @q
    public ProtectManager(Config config, TelemetryMetrics telemetryMetrics, com.contrastsecurity.agent.plugins.protect.c.c c2, b.a a2, Collection<p> collection, Clock clock) {
        this(config, telemetryMetrics, a2, clock);
        this.initializeDeadzoneManager(c2);
        this.setRules(collection);
    }

    void initializeDeadzoneManager(com.contrastsecurity.agent.plugins.protect.c.c c2) {
        Objects.requireNonNull(c2);
        if (this.deadzoneManager != null) {
            throw new IllegalStateException("DeadzoneManager has already been initialized");
        }
        this.deadzoneManager = c2;
    }

    void setRules(Collection<p> collection) {
        Objects.requireNonNull(collection);
        if (this.rules != null) {
            throw new IllegalStateException("rules have already been set");
        }
        if (this.deadzoneManager == null) {
            throw new IllegalStateException("DeadzoneManager has not yet been initialized");
        }
        Lists.Builder<p> builder = Lists.builder();
        this.inputAwareRules = new ArrayList<k>(collection.size());
        this.ruleById = new EnumMap<ProtectRuleId, p>(ProtectRuleId.class);
        for (p p2 : collection) {
            this.ruleById.put(p2.getRuleId(), p2);
            if (p2 instanceof k) {
                if (p2.g() && this.metrics.isEnabled()) {
                    p2 = new l((k)p2, this.metrics);
                }
                this.inputAwareRules.add((k)p2);
            }
            builder.add(p2);
        }
        this.rules = builder.build();
    }

    public Set<String> getUserTargetedClasses() {
        if (this.userTargetedClasses == null && this.logEnhancerList != null) {
            this.userTargetedClasses = new HashSet<String>();
            for (com.contrastsecurity.agent.plugins.protect.a a2 : this.logEnhancerList) {
                if (a2 == null) continue;
                this.userTargetedClasses.add(a2.b());
            }
        }
        return this.userTargetedClasses;
    }

    public void onServerFeatureUpdate(ServerSettingsProtectDTM serverSettingsProtectDTM) {
        if (serverSettingsProtectDTM != null) {
            List<LogEnhancerDTM> list = serverSettingsProtectDTM.getLogEnhancers();
            if (list != null) {
                this.logEnhancers = this.toLogEnhancerMap(list);
                this.logEnhancerList = this.toList(list);
                logger.info("Enabling log enhancers of size={}", (Object)this.logEnhancerList.size());
            } else {
                this.logEnhancers = Collections.emptyMap();
                this.logEnhancerList = Collections.emptyList();
                logger.info("No log enhancers provided");
            }
        }
    }

    private List<com.contrastsecurity.agent.plugins.protect.a> toList(List<LogEnhancerDTM> list) {
        ArrayList<com.contrastsecurity.agent.plugins.protect.a> arrayList = new ArrayList<com.contrastsecurity.agent.plugins.protect.a>();
        if (list != null) {
            for (LogEnhancerDTM logEnhancerDTM : list) {
                arrayList.add(new com.contrastsecurity.agent.plugins.protect.a(logEnhancerDTM));
            }
        }
        return arrayList;
    }

    private Map<Long, LogEnhancerDTM> toLogEnhancerMap(List<LogEnhancerDTM> list) {
        HashMap<Long, LogEnhancerDTM> hashMap = new HashMap<Long, LogEnhancerDTM>();
        for (LogEnhancerDTM logEnhancerDTM : list) {
            hashMap.put(logEnhancerDTM.getId(), logEnhancerDTM);
        }
        return hashMap;
    }

    Collection<p> getRules() {
        return this.rules;
    }

    public Iterable<p> getEnabledRules(ContrastContext contrastContext) {
        return this.filterEnabled(contrastContext, this.rules);
    }

    public List<k> getEnabledInputRulesCalculated(ContrastContext contrastContext) {
        ArrayList<k> arrayList = new ArrayList<k>();
        for (k k2 : this.getEnabledInputAwareRules(contrastContext)) {
            arrayList.add(k2);
        }
        return arrayList;
    }

    public Iterable<k> getEnabledInputAwareRules(ContrastContext contrastContext) {
        return this.filterEnabled(contrastContext, this.inputAwareRules);
    }

    public Iterable<k> getInputAwareRules(ContrastContext contrastContext, UserInputDTM.InputType inputType, ExceptionInputTypeDTM exceptionInputTypeDTM, HttpRequest httpRequest) {
        return this.getInputAwareRules(contrastContext, new b<k>(contrastContext.protect(), inputType, exceptionInputTypeDTM, httpRequest, this, contrastContext.application().current()));
    }

    public Iterable<k> getInputAwareRules(ContrastContext contrastContext, Predicate<k> predicate) {
        a<k> a2 = new a<k>(contrastContext, predicate, this);
        return () -> Iterators.filterIterator(this.inputAwareRules, a2);
    }

    public <T extends p> Iterable<T> filterEnabled(ContrastContext contrastContext, Collection<T> collection) {
        return () -> {
            if (collection == null || collection.isEmpty()) {
                return Collections.emptyIterator();
            }
            return Iterators.filterIterator(collection, new c(contrastContext, this));
        };
    }

    boolean isDisabledByInputExclusion(p p2, ExceptionInputTypeDTM exceptionInputTypeDTM, com.contrastsecurity.agent.apps.exclusions.c c2) {
        Objects.requireNonNull(p2);
        Objects.requireNonNull(exceptionInputTypeDTM);
        if (c2 == null) {
            return false;
        }
        return c2.a(e.a.b, p2.getRuleId().id(), exceptionInputTypeDTM);
    }

    public p getRuleById(ProtectRuleId protectRuleId) {
        return this.ruleById.get((Object)protectRuleId);
    }

    @q
    public <T extends p> T getRuleById(ProtectRuleId protectRuleId, Class<T> clazz) {
        return (T)((p)clazz.cast(this.ruleById.get((Object)protectRuleId)));
    }

    public boolean isSinksDisabled() {
        return !this.config.getBoolean(ConfigProperty.PROTECT_SINKS);
    }

    public boolean shouldProcessSink() {
        return this.activated && this.config.getBoolean(ConfigProperty.PROTECT_SINKS);
    }

    public ProtectContext newContext(ContrastContext contrastContext) {
        return contrastContext.protect(new ProtectContext(this.canonicalizer, this.clock, this.metrics, this.requestTimeMetrics, this.timingAnomalyEventFactory));
    }

    @Override
    public LogEnhancerDTM getLogEnhancerById(long l2) {
        return this.logEnhancers.get(l2);
    }

    @Override
    public List<com.contrastsecurity.agent.plugins.protect.a> getLogEnhancers() {
        return this.logEnhancerList;
    }

    private CommonConfigProtectionMode getAppRuleMode(ContrastContext contrastContext, p p2) {
        if (this.globalOverrideMode != null) {
            return this.globalOverrideMode;
        }
        return p2.getProtectRuleMode().a(contrastContext);
    }

    @q
    CommonConfigProtectionMode getGlobalModeOverride() {
        return this.globalOverrideMode;
    }

    static CommonConfigProtectionMode calcGlobalModeOverride(Config config) {
        ProtectionModeDTM protectionModeDTM = config.getEnumOrNull(ProtectionModeDTM.class, ConfigProperty.PROTECT_RULE_MODE_OVERRIDE);
        return protectionModeDTM == null ? null : protectionModeDTM.toCommonConfig();
    }

    public boolean isRuleDisabled(ContrastContext contrastContext, ProtectRuleId protectRuleId) {
        p p2 = this.ruleById.get((Object)protectRuleId);
        if (p2 == null) {
            return true;
        }
        return this.isRuleDisabled(contrastContext, p2);
    }

    public boolean isRuleDisabled(ContrastContext contrastContext, p p2) {
        Object object;
        if (p2.a()) {
            return false;
        }
        if (!this.ruleById.containsKey((Object)p2.getRuleId().baseRuleId())) {
            return true;
        }
        CommonConfigProtectionMode commonConfigProtectionMode = this.getAppRuleMode(contrastContext, p2);
        if (CommonConfigProtectionMode.OFF == commonConfigProtectionMode) {
            return true;
        }
        if (!this.shouldProcessSink()) {
            return true;
        }
        ProtectContext protectContext = contrastContext.protect();
        if (protectContext != null && protectContext.isRuleDisabled(p2.getRuleId())) {
            return true;
        }
        String string = p2.getRuleId().baseRuleId().id();
        if (contrastContext.scope().deque(DequeScope.Type.PROTECT_DEADZONE).inScope(string)) {
            return true;
        }
        Application application = contrastContext.application().current();
        if (application == null) {
            return false;
        }
        com.contrastsecurity.agent.apps.exclusions.i i2 = application.getExclusionProcessor();
        HttpRequest httpRequest = contrastContext.http().getRequest();
        if (httpRequest != null && i2.hasUrlExclusions(e.a.b) && ((com.contrastsecurity.agent.apps.exclusions.c)(object = d.a(application, httpRequest))).a(e.a.b, string)) {
            return true;
        }
        object = application.context().get(com.contrastsecurity.agent.plugins.apps.a.a.e.a);
        if (object == null) {
            return false;
        }
        return ((com.contrastsecurity.agent.plugins.apps.a.a.e)object).a(contrastContext, string, e.a.b);
    }

    public boolean canBlock(ContrastContext contrastContext, p p2) {
        CommonConfigProtectionMode commonConfigProtectionMode = this.getAppRuleMode(contrastContext, p2);
        return CommonConfigProtectionMode.BLOCK.equals((Object)commonConfigProtectionMode) || CommonConfigProtectionMode.BLOCK_AT_PERIMETER.equals((Object)commonConfigProtectionMode);
    }

    boolean shouldBlockAtPerimeter(ContrastContext contrastContext, k k2, UserInputDTM.InputType inputType) {
        CommonConfigProtectionMode commonConfigProtectionMode = this.getAppRuleMode(contrastContext, k2);
        return commonConfigProtectionMode == CommonConfigProtectionMode.BLOCK_AT_PERIMETER || commonConfigProtectionMode == CommonConfigProtectionMode.BLOCK && k2.a(inputType);
    }

    public boolean isScanParameterAsAnything() {
        return this.config.getBoolean(ConfigProperty.INSPECT_PARAMETERS_AS_JSON) || this.config.getBoolean(ConfigProperty.INSPECT_PARAMETERS_AS_XML);
    }

    public void checkParameterAccess(ContrastContext contrastContext) {
        if (contrastContext.protect().shouldThrowExceptionOnParameterAccess()) {
            throw new AttackBlockedException("Attack already detected in parameters");
        }
    }

    public void activate() {
        this.activated = true;
    }

    public void deactivate() {
        this.activated = false;
    }

    static final class c<T extends p>
    implements Predicate<T> {
        private final ProtectManager a;
        private final ContrastContext b;

        c(ContrastContext contrastContext, ProtectManager protectManager) {
            this.b = contrastContext;
            this.a = protectManager;
        }

        public boolean a(T t2) {
            return !this.a.isRuleDisabled(this.b, (p)t2);
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.a((p)object);
        }
    }

    static final class a<T extends p>
    implements Predicate<T> {
        private final Predicate<T> a;
        private final Predicate<T> b;

        a(ContrastContext contrastContext, Predicate<T> predicate, ProtectManager protectManager) {
            this.a = predicate;
            this.b = new c(contrastContext, protectManager);
        }

        public boolean a(T t2) {
            return this.a.test(t2) && this.b.test(t2);
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.a((p)object);
        }
    }

    static final class b<T extends k>
    implements Predicate<T> {
        private final ProtectContext a;
        private final UserInputDTM.InputType b;
        private final ExceptionInputTypeDTM c;
        private final ProtectManager d;
        private final com.contrastsecurity.agent.apps.exclusions.c e;
        private final String f;

        b(ProtectContext protectContext, UserInputDTM.InputType inputType, ExceptionInputTypeDTM exceptionInputTypeDTM, HttpRequest httpRequest, ProtectManager protectManager, Application application) {
            this.a = protectContext;
            this.b = inputType;
            this.c = exceptionInputTypeDTM;
            this.d = protectManager;
            this.e = com.contrastsecurity.agent.apps.exclusions.d.a(application, httpRequest);
            this.f = httpRequest != null ? httpRequest.getUri() : null;
        }

        public boolean a(T t2) {
            boolean bl2;
            ProtectRuleId protectRuleId = t2.getRuleId();
            boolean bl3 = bl2 = t2.appliesToInputType(this.b) && !this.a.isRuleDisabled(protectRuleId) && !this.d.isDisabledByInputExclusion((p)t2, this.c, this.e);
            if (!bl2 && logger.isTraceEnabled()) {
                logger.trace("Skipping {} input scanning for {} for {} due to exception", this.b.logName(), protectRuleId.id(), this.f);
            }
            return bl2;
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.a((k)object);
        }
    }
}

