/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.route;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.commons.Clock;
import com.contrastsecurity.agent.config.Config;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.context.ExecutionContext;
import com.contrastsecurity.agent.context.RequestContext;
import com.contrastsecurity.agent.contrastapi_v1_0.RequestMethod;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.messages.finding.trace.EventSourceDTM;
import com.contrastsecurity.agent.messages.mq.EventType;
import com.contrastsecurity.agent.messages.routes.ObservedRoute;
import com.contrastsecurity.agent.messages.routes.RouteType;
import com.contrastsecurity.agent.o;
import com.contrastsecurity.agent.o.e;
import com.contrastsecurity.agent.plugins.observe.RootSpan;
import com.contrastsecurity.agent.plugins.route.RouteObservationProcessor;
import com.contrastsecurity.agent.plugins.route.c;
import com.contrastsecurity.agent.q;
import com.contrastsecurity.agent.services.a.d;
import com.contrastsecurity.agent.telemetry.metrics.Counter;
import com.contrastsecurity.agent.telemetry.metrics.TelemetryMetrics;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.StringUtils;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

@o
@DontObfuscate
public final class RouteObservationProcessorImpl
implements RouteObservationProcessor {
    private final Config config;
    private final d<ObservedRoute> reporter;
    private final e publisher;
    private final Clock clock;
    private final long duplicateWindowTimeNS;
    private final Counter observedRouteMapFullCounter;
    private final Semaphore maxRoutesSemaphore;
    private final ConcurrentHashMap<Integer, Long> routeTimestampMap;
    private final boolean reportMiddleware;
    @q
    static final ExecutionContext.Key<Deque> OUTER_OBSERVED_ROUTES = ExecutionContext.Key.create(Deque.class);
    @q
    static final ExecutionContext.Key<Set> SOURCES = ExecutionContext.Key.create(Set.class);
    @q
    static final String COUNTER_ANALYSIS_OBSERVED_ROUTE_MAP_FULL = "observedRouteMapFullCount";
    @q
    static final String GAUGE_OBSERVED_ROUTE_CACHE_MAP_ELEMENTS = "observedRouteMapElements";
    private static final Logger logger = LoggerFactory.getLogger(RouteObservationProcessorImpl.class);

    public RouteObservationProcessorImpl(Config config, d<ObservedRoute> d2, e e2, Clock clock, TelemetryMetrics telemetryMetrics) {
        this.config = config;
        this.reporter = d2;
        this.publisher = e2;
        this.clock = clock;
        int n2 = config.getInt(ConfigProperty.ROUTE_OBSERVATION_MAP_DEDUPLICATION_SIZE);
        this.duplicateWindowTimeNS = TimeUnit.MILLISECONDS.toNanos(config.getLong(ConfigProperty.ROUTE_OBSERVATION_DEDUPLICATION_TIME));
        this.maxRoutesSemaphore = new Semaphore(n2);
        this.routeTimestampMap = new ConcurrentHashMap(n2);
        this.reportMiddleware = config.getBoolean(ConfigProperty.ROUTE_OBSERVATION_MIDDLEWARE_REPORTING_ENABLED);
        this.observedRouteMapFullCounter = telemetryMetrics.newCounter(COUNTER_ANALYSIS_OBSERVED_ROUTE_MAP_FULL, TelemetryMetrics.TelemetryCategory.ASSESS).withDescription("The number of times the Observed Route deduplication map was full").register();
        telemetryMetrics.newGauge(GAUGE_OBSERVED_ROUTE_CACHE_MAP_ELEMENTS, TelemetryMetrics.TelemetryCategory.ASSESS).a("The size of the Observed Route deduplication map").a(this.routeTimestampMap, object -> this.routeTimestampMap.size()).a();
    }

    @Override
    public void onSourceEventsFound(ContrastContext contrastContext, Set<EventSourceDTM> set) {
        HttpRequest httpRequest = contrastContext.http().getRequest();
        if (httpRequest == null) {
            return;
        }
        Set set2 = httpRequest.context().getOrComputeIfAbsent(SOURCES, CopyOnWriteArraySet::new);
        set2.addAll(set);
    }

    @Override
    public void onRouteStart(ContrastContext contrastContext, String string, RouteType routeType) {
        HttpRequest httpRequest = contrastContext.http().getRequest();
        if (string == null || httpRequest == null || httpRequest.getMethod() == null) {
            logger.debug("Verb, signature or request was null, which are required for route observation: {}", (Object)httpRequest);
            return;
        }
        this.onRouteStart(contrastContext, string, contrastContext.http().getRequest().getTemplate(), routeType);
    }

    @Override
    public void onRouteStart(ContrastContext contrastContext, String string, String string2, RouteType routeType) {
        Object object;
        Object object2;
        HttpRequest httpRequest = contrastContext.http().getRequest();
        if (string == null || httpRequest == null || httpRequest.getMethod() == null) {
            logger.debug("Verb, signature or request was null, which are required for route observation: {}", (Object)httpRequest);
            return;
        }
        String string3 = httpRequest.getPath();
        if (string3 == null) {
            logger.debug("Path was null, which is required for route observation: {}", (Object)httpRequest);
            return;
        }
        RequestMethod requestMethod = httpRequest.getMethod();
        if (requestMethod.isUnknownHeader()) {
            logger.debug("Request method was {}, which is unknown, cannot perform route observation: {}", (Object)requestMethod, (Object)httpRequest);
            return;
        }
        Application application = contrastContext.application().current();
        if (application == null || application.getSessionId() == null) {
            if (logger.isDebugEnabled()) {
                String string4 = application == null ? "null" : application.getSessionId();
                logger.debug("Unable to find application or session id for route observation. Request: {}, Application: {}, SessionId: {}", httpRequest, application, string4);
            }
            return;
        }
        ObservedRoute.Builder builder = ObservedRoute.builder().signature(string).sessionId(application.getSessionId()).url(string3).requestMethod(requestMethod).template(string2).type(routeType);
        Map map = application.context().get(Application.DISCOVERED_ROUTES_KEY);
        if (map != null && (object2 = (c)map.get(string)) != null) {
            builder.setMappings(object2.a());
            if (!StringUtils.isEmpty(string2)) {
                object = object2.a(string2);
                builder.template((String)object);
            } else if (string2 == null && object2.a().size() == 1) {
                builder.template(object2.a().iterator().next());
            }
        }
        if ((object2 = this.addSourcesToObservedRoute(contrastContext, (ObservedRoute)httpRequest.context().get(CURRENT_OBSERVED_ROUTE))) != null) {
            httpRequest.context().getOrComputeIfAbsent(OUTER_OBSERVED_ROUTES, ArrayDeque::new).push(object2);
        }
        object = builder.build();
        httpRequest.context().put(CURRENT_OBSERVED_ROUTE, object);
        httpRequest.setTemplate(((ObservedRoute)object).template());
        if (!this.config.getBoolean(ConfigProperty.OBSERVE_ENABLE)) {
            return;
        }
        RootSpan rootSpan = contrastContext.observe();
        if (rootSpan == null || rootSpan.isRecording() || RouteType.MIDDLEWARE == ((ObservedRoute)object).type()) {
            return;
        }
        rootSpan.startRecording(contrastContext);
    }

    private ObservedRoute addSourcesToObservedRoute(ContrastContext contrastContext, ObservedRoute observedRoute) {
        if (!ObservedRoute.isValid(observedRoute)) {
            return null;
        }
        Set set = contrastContext.http().getRequest().context().get(SOURCES);
        if (set != null && !set.isEmpty()) {
            ObservedRoute.Builder builder = observedRoute.toBuilder();
            for (Object e2 : set) {
                builder.addSource((EventSourceDTM)e2);
            }
            set.clear();
            return builder.build();
        }
        return observedRoute;
    }

    @Override
    public void onRouteEnd(ContrastContext contrastContext) {
        Deque deque;
        HttpRequest httpRequest = contrastContext.http().getRequest();
        if (httpRequest == null) {
            logger.debug("Request was null");
            return;
        }
        Application application = contrastContext.application().current();
        if (application == null) {
            logger.debug("No application was found");
            return;
        }
        RequestContext requestContext = httpRequest.context();
        ObservedRoute observedRoute = this.addSourcesToObservedRoute(contrastContext, (ObservedRoute)requestContext.remove(CURRENT_OBSERVED_ROUTE));
        if (observedRoute == null) {
            logger.debug("No observed routes were found");
            return;
        }
        this.publisher.a(EventType.OBSERVED_ROUTE_EVENT, observedRoute);
        if (this.shouldReport(observedRoute)) {
            this.reporter.a(application, observedRoute);
        }
        if ((deque = requestContext.get(OUTER_OBSERVED_ROUTES)) == null || deque.isEmpty()) {
            return;
        }
        try {
            ObservedRoute observedRoute2 = (ObservedRoute)deque.pop();
            requestContext.put(CURRENT_OBSERVED_ROUTE, observedRoute2);
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.debug("No outer observed routes were found");
        }
    }

    private boolean shouldReport(ObservedRoute observedRoute) {
        return !this.isDuplicate(observedRoute) && (observedRoute.type() != RouteType.MIDDLEWARE || this.reportMiddleware);
    }

    @Override
    public void onRequestEnd(ContrastContext contrastContext) {
        this.onRouteEnd(contrastContext);
    }

    @Override
    public boolean doesCurrentRouteHaveSignature(ContrastContext contrastContext, String string) {
        if (string == null) {
            return false;
        }
        HttpRequest httpRequest = contrastContext.http().getRequest();
        if (httpRequest == null) {
            return false;
        }
        ObservedRoute observedRoute = (ObservedRoute)httpRequest.context().get(CURRENT_OBSERVED_ROUTE);
        return observedRoute != null && string.equals(observedRoute.signature());
    }

    @q
    boolean isDuplicate(ObservedRoute observedRoute) {
        if (this.duplicateWindowTimeNS <= 0L) {
            return false;
        }
        long l2 = this.clock.nanoTime();
        Long l4 = this.routeTimestampMap.compute(observedRoute.hashForReporting(), (n2, l3) -> {
            boolean bl2;
            if (l3 == null) {
                if (!this.maxRoutesSemaphore.tryAcquire()) {
                    this.observedRouteMapFullCounter.increment();
                    return null;
                }
                return l2;
            }
            boolean bl3 = bl2 = l2 - l3 > this.duplicateWindowTimeNS;
            if (bl2) {
                this.maxRoutesSemaphore.release();
                return null;
            }
            return l3;
        });
        return l4 != null && l4 != l2;
    }
}

