/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.route;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.context.ExecutionContext;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.messages.finding.trace.EventSourceDTM;
import com.contrastsecurity.agent.messages.routes.ObservedRoute;
import com.contrastsecurity.agent.messages.routes.RouteType;
import com.contrastsecurity.agent.o;
import com.contrastsecurity.agent.plugins.route.RouteObservationProcessor;
import com.contrastsecurity.agent.test.integration.IntegrationTestServices;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

@o
@DontObfuscate
public final class TestObservationProcessor
implements RouteObservationProcessor {
    private static final ExecutionContext.Key<Set> SOURCES = ExecutionContext.Key.create(Set.class);
    private static final ExecutionContext.Key<ObservedRoute.Builder> OBSERVED_ROUTE_KEY = ExecutionContext.Key.create(ObservedRoute.Builder.class);

    @Override
    public void onRouteStart(ContrastContext contrastContext, String string, RouteType routeType) {
        this.onRouteStart(contrastContext, string, contrastContext.http().getRequest().getTemplate(), routeType);
    }

    @Override
    public void onRouteStart(ContrastContext contrastContext, String string, String string2, RouteType routeType) {
        HttpRequest httpRequest = contrastContext.http().getRequest();
        ObservedRoute.Builder builder = ObservedRoute.builder().sessionId("integration-test-session-id").signature(string).url(httpRequest.getPath()).requestMethod(httpRequest.getMethod()).type(routeType);
        this.addSourcesToObservedRoute(contrastContext, builder);
        httpRequest.context().put(OBSERVED_ROUTE_KEY, builder);
    }

    @Override
    public void onRouteEnd(ContrastContext contrastContext) {
        HttpRequest httpRequest = contrastContext.http().getRequest();
        if (httpRequest == null) {
            return;
        }
        ObservedRoute.Builder builder = httpRequest.context().get(OBSERVED_ROUTE_KEY);
        if (builder == null) {
            return;
        }
        this.addSourcesToObservedRoute(contrastContext, builder);
        IntegrationTestServices.getInstance().addObservedRoute(builder.build());
    }

    @Override
    public void onRequestEnd(ContrastContext contrastContext) {
        this.onRouteEnd(contrastContext);
    }

    @Override
    public void onSourceEventsFound(ContrastContext contrastContext, Set<EventSourceDTM> set) {
        HttpRequest httpRequest = contrastContext.http().getRequest();
        if (httpRequest == null) {
            return;
        }
        httpRequest.context().getOrComputeIfAbsent(SOURCES, CopyOnWriteArraySet::new).addAll(set);
    }

    private void addSourcesToObservedRoute(ContrastContext contrastContext, ObservedRoute.Builder builder) {
        HttpRequest httpRequest = contrastContext.http().getRequest();
        if (httpRequest == null) {
            return;
        }
        Set set = httpRequest.context().get(SOURCES);
        if (set == null || set.isEmpty()) {
            return;
        }
        for (Object e2 : set) {
            builder.addSource((EventSourceDTM)e2);
        }
        set.clear();
    }

    @Override
    public boolean doesCurrentRouteHaveSignature(ContrastContext contrastContext, String string) {
        return false;
    }
}

