/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.HeapUsage;
import com.contrastsecurity.agent.telemetry.metrics.Counter;
import com.contrastsecurity.agent.trace.snapshot.a;
import com.contrastsecurity.agent.weakmap.WeakIdentityHashMap;
import java.util.Collections;
import java.util.Map;

@HeapUsage.SupportsHeapProfiling
@DontObfuscate
public final class AssessContextSnapshotCache
implements a {
    @HeapUsage.Deep
    private final Map<Object, String> snapshotMap = Collections.synchronizedMap(new WeakIdentityHashMap());
    @HeapUsage.Shallow(reason=HeapUsage.Shallow.Reason.AGENT_GLOBAL)
    private final Counter snapshotCacheHit;
    @HeapUsage.Shallow(reason=HeapUsage.Shallow.Reason.AGENT_GLOBAL)
    private final Counter snapshotCacheMiss;

    public AssessContextSnapshotCache(Counter counter, Counter counter2) {
        this.snapshotCacheHit = counter;
        this.snapshotCacheMiss = counter2;
    }

    @Override
    public String getSnapshot(Object object) {
        String string = this.snapshotMap.get(object);
        if (string == null && object == null) {
            return null;
        }
        if (string != null) {
            this.snapshotCacheHit.increment();
        } else {
            this.snapshotCacheMiss.increment();
        }
        return string;
    }

    @Override
    public void putSnapshot(Object object, String string) {
        this.snapshotMap.put(object, string);
    }

    @Override
    public int cacheEntries() {
        return this.snapshotMap.size();
    }
}

