/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.Clock;
import com.contrastsecurity.agent.commons.HeapUsage;
import com.contrastsecurity.agent.config.Config;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.enums.LogContextSwitch;
import com.contrastsecurity.agent.generated.tags.Tag;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.plugins.security.AssessContextSnapshotCache;
import com.contrastsecurity.agent.plugins.security.Finding;
import com.contrastsecurity.agent.plugins.security.controller.maps.TraceMap;
import com.contrastsecurity.agent.plugins.security.model.TriggerEvent;
import com.contrastsecurity.agent.plugins.security.policy.rules.c;
import com.contrastsecurity.agent.plugins.security.policy.rules.providers.HttpWatcher;
import com.contrastsecurity.agent.plugins.security.sampling.SamplingResult;
import com.contrastsecurity.agent.q;
import com.contrastsecurity.agent.telemetry.metrics.Counter;
import com.contrastsecurity.agent.telemetry.metrics.i;
import com.contrastsecurity.agent.trace.CodeEvent;
import com.contrastsecurity.agent.trace.InvalidTagRangeException;
import com.contrastsecurity.agent.trace.Trace;
import com.contrastsecurity.agent.util.J;
import com.contrastsecurity.agent.util.JVMUtils;
import com.contrastsecurity.agent.util.M;
import com.contrastsecurity.agent.weakmap.ConcurrentReferenceHashMap;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.CRC32;

@HeapUsage.SupportsHeapProfiling(ownedCaches={AssessContextSnapshotCache.class, a.class})
@DontObfuscate
public class AssessmentContext {
    @HeapUsage.Deep
    private final AssessContextSnapshotCache snapshotCache;
    @HeapUsage.Deep
    private final Map<Integer, Integer> lengthMap = new HashMap<Integer, Integer>();
    @HeapUsage.Deep
    private final Map<Thread, String> threadDescCache = new a();
    @HeapUsage.Deep
    private final TraceMap traceMap;
    @HeapUsage.Deep
    private final ConcurrentHashMap<Integer, Set<Tag>> identityTagMap;
    @HeapUsage.Deep
    private final ConcurrentHashMap<Integer, List<Trace>> identityTraceMap;
    @HeapUsage.Deep
    private final AtomicBoolean jumpedContexts;
    @HeapUsage.Shallow(reason=HeapUsage.Shallow.Reason.AGENT_GLOBAL)
    private final i requestTimeMetric;
    @HeapUsage.Shallow(reason=HeapUsage.Shallow.Reason.AGENT_GLOBAL)
    private final Clock clock;
    @HeapUsage.Deep
    private volatile TriggerEvent lastTriggerEvent;
    @HeapUsage.Deep
    private volatile Collection<HttpWatcher> httpWatchers;
    @HeapUsage.Deep
    private volatile c findingTestCache;
    @HeapUsage.Deep
    private volatile SamplingResult samplingResult;
    private final boolean identityTaggingEnabled;
    private final long maxContextTtl;
    private volatile long updated;
    private static final Logger logger = LoggerFactory.getLogger(AssessmentContext.class);

    @q
    public AssessmentContext(Config config, Clock clock, int n2, Counter counter, Counter counter2, i i2) {
        this.clock = clock;
        this.updated = clock.now();
        this.identityTagMap = new ConcurrentHashMap(n2 / 4);
        this.identityTraceMap = new ConcurrentHashMap(n2 / 2);
        this.jumpedContexts = new AtomicBoolean(false);
        this.requestTimeMetric = i2;
        this.snapshotCache = new AssessContextSnapshotCache(counter, counter2);
        this.traceMap = new TraceMap(n2, 0.75f, config.getInt(ConfigProperty.MAX_CONTEXT_SOURCE_EVENTS), config.getInt(ConfigProperty.MAX_CONTEXT_PROPAGATION_EVENTS));
        this.identityTaggingEnabled = config.getBoolean(ConfigProperty.IDENTITYTAGS);
        if (LogContextSwitch.enabled()) {
            logger.debug("Created context: {}", (Object)this);
        }
        this.maxContextTtl = config.getLong(ConfigProperty.MAX_TRACE_TTL);
    }

    public void updateLastAccess() {
        long l2 = this.lastUpdatedMillis();
        long l3 = this.clock.now() - l2;
        if (l3 > this.maxContextTtl) {
            this.clear();
            if (logger.isDebugEnabled()) {
                logger.debug("Cleared expired assessment context {} with traceMap {} in ({}ms)", this, JVMUtils.getSafeToString(this.traceMap, true), l3);
            }
            this.refresh();
        }
    }

    public void recordRequestTime(HttpRequest httpRequest) {
        this.requestTimeMetric.a(this.clock.nanoTime() - httpRequest.startTimeNs(), TimeUnit.NANOSECONDS);
    }

    long lastUpdatedMillis() {
        return this.updated;
    }

    public Set<Tag> getTags(int n2) {
        return this.identityTagMap.getOrDefault(n2, Collections.emptySet());
    }

    @q
    public void addTags(Integer n3, Tag ... tagArray) {
        this.identityTagMap.computeIfAbsent(n3, n2 -> Collections.synchronizedSet(EnumSet.noneOf(Tag.class))).addAll(Arrays.asList(tagArray));
    }

    public Integer getLength(Object object) {
        return object == null ? Integer.valueOf(0) : this.lengthMap.get(object.hashCode());
    }

    public void saveLength(Object object, Integer n2) {
        if (object != null) {
            this.lengthMap.put(object.hashCode(), n2);
        }
    }

    @q
    public void clearIdentityTraceMap() {
        this.identityTraceMap.clear();
    }

    public void clear() {
        this.identityTagMap.clear();
        this.identityTraceMap.clear();
        this.threadDescCache.clear();
        this.traceMap.clear();
        if (LogContextSwitch.enabled()) {
            logger.debug("Cleared context: {}", (Object)this);
        }
    }

    public void applyTags(int n2, String string, int n3) throws InvalidTagRangeException {
        this.applyTags(n2, J.a(string), n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyTags(int n3, Collection<Tag> collection, int n4) throws InvalidTagRangeException {
        this.identityTagMap.computeIfAbsent(n3, n2 -> Collections.synchronizedSet(EnumSet.noneOf(Tag.class))).addAll(collection);
        List<Trace> list = this.identityTraceMap.get(n3);
        if (list == null) {
            return;
        }
        List<Trace> list2 = list;
        synchronized (list2) {
            if (list.isEmpty()) {
                return;
            }
            for (Trace trace : list) {
                CodeEvent codeEvent = trace.getLastEvent();
                if (codeEvent == null) continue;
                codeEvent.addTags(collection, n4);
            }
        }
    }

    @q
    List<Trace> getTraces(Integer n2) {
        return this.identityTraceMap.get(n2);
    }

    public void addTrace(Integer n3, Trace trace) {
        this.identityTraceMap.computeIfAbsent(n3, n2 -> Collections.synchronizedList(new ArrayList())).add(trace);
    }

    public String getThreadDescription(Thread thread) {
        String string = this.threadDescCache.get(thread);
        if (string == null) {
            string = M.a(thread);
            this.threadDescCache.put(thread, string);
        }
        return string;
    }

    public void setLastTriggerEvent(TriggerEvent triggerEvent) {
        this.lastTriggerEvent = triggerEvent;
    }

    @q
    public TriggerEvent getLastTriggerEvent() {
        return this.lastTriggerEvent;
    }

    public TraceMap getTraceMap() {
        return this.traceMap;
    }

    public void refresh() {
        this.updated = this.clock.now();
    }

    public boolean isJumpedContexts() {
        return this.jumpedContexts.get();
    }

    public void jumpingContexts() {
        this.jumpedContexts.set(true);
        if (LogContextSwitch.enabled()) {
            logger.debug("Preparing to jump context: {}", (Object)this);
        }
        this.refresh();
    }

    public boolean isIdentityTaggingEnabled() {
        return this.identityTaggingEnabled;
    }

    public AssessContextSnapshotCache getSnapshotCache() {
        return this.snapshotCache;
    }

    public void enableCaptureRecentFindings() {
        this.findingTestCache = new c();
    }

    public void onFindingOccurred(String string, Finding finding) {
        if (this.findingTestCache == null) {
            return;
        }
        this.findingTestCache.a(string, finding);
    }

    @q
    public Map<String, Finding> getRecentFindings() {
        if (this.findingTestCache == null) {
            throw new IllegalStateException("Finding test captures are not enabled!");
        }
        return this.findingTestCache.a();
    }

    @q
    public void clearRecentFindings() {
        if (this.findingTestCache == null) {
            throw new IllegalStateException("Finding test captures are not enabled!");
        }
        this.findingTestCache.b();
    }

    public void samplingResult(SamplingResult samplingResult) {
        this.samplingResult = samplingResult;
    }

    public SamplingResult samplingResult() {
        return this.samplingResult;
    }

    public void httpWatchers(Collection<HttpWatcher> collection) {
        this.httpWatchers = collection;
    }

    public Collection<HttpWatcher> httpWatchers() {
        return this.httpWatchers == null ? Collections.emptyList() : this.httpWatchers;
    }

    public String toString() {
        return AssessmentContext.toString(this, LogContextSwitch.get());
    }

    @q
    static String toString(AssessmentContext assessmentContext, LogContextSwitch logContextSwitch) {
        String string = JVMUtils.getSafeToString(assessmentContext, true);
        if (logContextSwitch != LogContextSwitch.FULL || assessmentContext == null) {
            return string;
        }
        return string + ":\ntraceMap=\n" + assessmentContext.traceMap + "\nthreadDescCache=\n" + assessmentContext.threadDescCache + "\nidentityTagMap=\n" + assessmentContext.identityTagMap + "\nidentityTraceMap=\n" + assessmentContext.identityTraceMap + "\nsnapshotCache=\n" + assessmentContext.snapshotCache;
    }

    public String toSummaryString() {
        return JVMUtils.getSafeToString(this, true) + "{traceMap=" + JVMUtils.getSafeToString(this.traceMap, true) + " (with " + this.traceMap.size() + " items in it), jumpedContexts=" + this.jumpedContexts + "}";
    }

    public static int calculateIdentity(int n2, int n3) {
        com.contrastsecurity.agent.util.i i2 = new com.contrastsecurity.agent.util.i();
        ((CRC32)i2).update(n2);
        ((CRC32)i2).update(n3);
        return (int)i2.getValue();
    }

    @HeapUsage.SupportsHeapProfiling
    public static final class a
    extends ConcurrentReferenceHashMap<Thread, String> {
        private a() {
        }
    }
}

