/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.controller;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.Clock;
import com.contrastsecurity.agent.commons.Purgeable;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.commons.e;
import com.contrastsecurity.agent.config.Config;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.enums.TraceMapStrategy;
import com.contrastsecurity.agent.config.exception.b;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.o;
import com.contrastsecurity.agent.plugins.security.AssessmentContext;
import com.contrastsecurity.agent.plugins.security.controller.maps.GlobalTraceMap;
import com.contrastsecurity.agent.plugins.security.controller.maps.TraceMap;
import com.contrastsecurity.agent.telemetry.HeapProfiler;
import com.contrastsecurity.agent.trace.CodeEvent;
import com.contrastsecurity.agent.trace.Trace;
import com.contrastsecurity.agent.util.JVMUtils;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

@DontObfuscate
@o
public class EventContext
implements Purgeable {
    private boolean enabled;
    private final TraceMapStrategy traceMapStrategy;
    private final Clock clock;
    private final TraceMap globalTraceMap;
    private final long maxStronglyReachableTraceTtl;
    private static final Logger logger = LoggerFactory.getLogger(EventContext.class);

    public EventContext(Config config, Clock clock, HeapProfiler heapProfiler) {
        this.clock = clock;
        this.maxStronglyReachableTraceTtl = config.getLong(ConfigProperty.MAX_TRACE_TTL);
        this.traceMapStrategy = EventContext.traceMapStrategyFromConfig(config);
        int n2 = config.getInt(ConfigProperty.MAX_GLOBAL_TRACE_MAP_SIZE);
        this.globalTraceMap = heapProfiler.saveForProfiling(new GlobalTraceMap(n2));
    }

    static TraceMapStrategy traceMapStrategyFromConfig(Config config) {
        String string = config.get(ConfigProperty.TRACE_MAP_STRATEGY);
        TraceMapStrategy traceMapStrategy = TraceMapStrategy.valueOfIgnoreCase(string);
        if (traceMapStrategy == null) {
            throw new b("Invalid value [" + string + "] set for " + (Object)((Object)ConfigProperty.TRACE_MAP_STRATEGY) + ". Valid values are GLOBAL, CONTEXT, BOTH.");
        }
        return traceMapStrategy;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl2) {
        this.enabled = bl2;
    }

    public TraceMap getTraceMap(AssessmentContext assessmentContext) {
        switch (this.traceMapStrategy) {
            case GLOBAL: {
                return this.globalTraceMap;
            }
            case BOTH: {
                TraceMap traceMap = assessmentContext == null ? null : assessmentContext.getTraceMap();
                return traceMap == null ? this.globalTraceMap : traceMap;
            }
        }
        throw new IllegalStateException("Unknown Trace Map Strategy: " + (Object)((Object)this.traceMapStrategy));
    }

    public TraceMap putTrace(AssessmentContext assessmentContext, Object object, Trace trace) {
        TraceMap traceMap = this.getTraceMap(assessmentContext);
        traceMap.put(object, trace);
        return traceMap;
    }

    @Override
    public e purgeStale() {
        int n2 = this.globalTraceMap.size();
        this.removeDeadTraces(this.globalTraceMap);
        this.removeExpiredTraces(this.globalTraceMap);
        return new e(n2, this.globalTraceMap.size());
    }

    private void removeDeadTraces(TraceMap traceMap) {
        traceMap.dumpStats();
        traceMap.purgeStaleEntries();
    }

    private void removeExpiredTraces(TraceMap traceMap) {
        Iterator iterator = traceMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Trace trace = null;
            try {
                entry = iterator.next();
                trace = (Trace)entry.getValue();
                if (!this.shouldRemoveTrace(trace)) continue;
                Object k2 = entry.getKey();
                if (logger.isTraceEnabled()) {
                    logger.trace("Removing expired key=[{}] with identity=[{}] and value=[{}] from trace map=[{}].", k2, JVMUtils.getSafeToString(k2, true), JVMUtils.getSafeToString(trace, true), JVMUtils.getSafeToString(traceMap, true));
                }
                iterator.remove();
            }
            catch (NoSuchElementException noSuchElementException) {
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                entry = throwable;
                logger.error("Problem pruning old trace {}", trace != null ? Long.valueOf(trace.getId()) : "null", (Object)entry);
            }
        }
    }

    private boolean shouldRemoveTrace(Trace trace) {
        CodeEvent codeEvent = trace.getFirstEvent();
        if (codeEvent == null) {
            return true;
        }
        long l2 = codeEvent.getTimestamp();
        long l3 = this.clock.now() - l2;
        return l3 > this.maxStronglyReachableTraceTtl;
    }

    public int size(ContrastContext contrastContext) {
        TraceMap traceMap = this.getTraceMap(contrastContext.assessment());
        return traceMap != null ? traceMap.size() : 0;
    }

    public Integer getTrackedItemHash(AssessmentContext assessmentContext, Object[] objectArray) {
        TraceMap traceMap = this.getTraceMap(assessmentContext);
        Trace trace = (Trace)traceMap.get(objectArray);
        if (trace != null) {
            return Arrays.hashCode(objectArray);
        }
        for (Object object : objectArray) {
            Integer n2;
            if (object == null) continue;
            Class<?> clazz = object.getClass().getComponentType();
            if (clazz != null && !clazz.isPrimitive() && (n2 = this.getTrackedItemHash(assessmentContext, (Object[])object)) != null) {
                return n2;
            }
            trace = (Trace)traceMap.get(object);
            if (trace == null) continue;
            return object.hashCode();
        }
        return null;
    }
}

