/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.controller.maps;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.HeapUsage;
import com.contrastsecurity.agent.logging.a;
import com.contrastsecurity.agent.plugins.security.AssessContextSnapshotCache;
import com.contrastsecurity.agent.plugins.security.AssessmentContext;
import com.contrastsecurity.agent.plugins.security.controller.maps.TraceMap;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;

@HeapUsage.SupportsHeapProfiling(ownedCaches={AssessContextSnapshotCache.class, AssessmentContext.a.class})
@DontObfuscate
public final class GlobalTraceMap
extends TraceMap {
    private final int maxSize;
    public static final String MAX_SOURCE_EVENTS_REACHED_GLOBAL = "MAX_SOURCE_EVENTS_REACHED_GLOBAL";
    private static final Logger logger = LoggerFactory.getLogger(GlobalTraceMap.class);

    public GlobalTraceMap(int n2) {
        super(n2 + n2 / 4, 1.0f, 0, 0);
        this.maxSize = n2;
    }

    @Override
    public int sourceEvents() {
        return 0;
    }

    @Override
    public void incrementSourceEventCount() {
    }

    @Override
    public boolean hasReachedMaximumSourceEvents() {
        return this.size() >= this.maxSize;
    }

    @Override
    public int propagationEvents() {
        return 0;
    }

    @Override
    public void incrementPropagationEventCount() {
    }

    @Override
    public boolean hasReachedMaximumPropagationEvents() {
        return this.size() >= this.maxSize;
    }

    @Override
    public void logMaximumSourceEvents(String string) {
        if (!a.c(MAX_SOURCE_EVENTS_REACHED_GLOBAL)) {
            a.c(MAX_SOURCE_EVENTS_REACHED_GLOBAL, logger, "Maximum source events reached for Global Trace Map. Ignoring source event {}, Further events will be logged at the `DEBUG` level", null, new Object[]{string});
            return;
        }
        logger.debug("Maximum source events reached for Global Trace Map. Ignoring source event {},", (Object)string);
    }
}

