/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.policy.adaptiveoptimization;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.config.Config;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.instr.a.b;
import com.contrastsecurity.agent.o;
import com.contrastsecurity.agent.plugins.security.Finding;
import com.contrastsecurity.agent.plugins.security.model.PropagationEvent;
import com.contrastsecurity.agent.plugins.security.model.SourceEvent;
import com.contrastsecurity.agent.plugins.security.policy.SourceNode;
import com.contrastsecurity.agent.plugins.security.policy.adaptiveoptimization.c;
import com.contrastsecurity.agent.plugins.security.policy.adaptiveoptimization.f;
import com.contrastsecurity.agent.plugins.security.policy.adaptiveoptimization.g;
import com.contrastsecurity.agent.plugins.security.policy.u;
import com.contrastsecurity.agent.stack.StackCapture;
import com.contrastsecurity.agent.trace.CodeEvent;
import com.contrastsecurity.agent.trace.Trace;
import com.contrastsecurity.thirdparty.cggc.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;

@o
@DontObfuscate
public class AdaptiveOptimizationManager {
    private volatile boolean enabled;
    private volatile int maximum;
    private volatile int frequency;
    private final boolean includeRequestUriInSourceIdentity;
    private final ConcurrentMap<String, f> propagationFrameHistoryCache;
    private final ConcurrentMap<Integer, g> namedSourceHistoryCache;
    private b denylist;
    private static final int MAX_PROPAGATION_FRAME_HISTORY_CACHE_SIZE = 256;
    private static final int FRAME_CALLER_FRAME_SEARCH_DEPTH = 10;
    private static final String SET_ADAPTIVE_OPTIMIZATION_FREQUENCY = "setAdaptiveOptimizationFrequency";
    private static final String SET_ADAPTIVE_OPTIMIZATION_MAXIMUM = "setAdaptiveOptimizationMax";
    private static final String GET_ADAPTIVE_OPTIMIZATION_MAXIMUM = "getAdaptiveOptimizationMax";
    private static final String GET_ADAPTIVE_OPTIMIZATION_FREQUENCY = "getAdaptiveOptimizationFrequency";
    private static final String IS_ADAPTIVE_OPTIMIZATION_ON = "isAdaptiveOptimizationOn";
    private static final String TOGGLE_ADAPTIVE_OPTIMIZATION = "toggleAdaptiveOptimization";
    private static final Logger logger = LoggerFactory.getLogger(AdaptiveOptimizationManager.class);

    public AdaptiveOptimizationManager(Config config) {
        Objects.requireNonNull(config);
        this.enabled = config.getBoolean(ConfigProperty.ADAPTIVE_OPTIMIZATION);
        this.frequency = config.getInt(ConfigProperty.ADAPTIVE_OPTIMIZATION_FREQUENCY);
        this.maximum = config.getInt(ConfigProperty.ADAPTIVE_OPTIMIZATION_MAXIMUM);
        this.includeRequestUriInSourceIdentity = config.getBoolean(ConfigProperty.ADAPTIVE_OPTIMIZATION_PER_REQUEST);
        c c2 = new c();
        this.propagationFrameHistoryCache = new ConcurrentLinkedHashMap.Builder().initialCapacity(128).maximumWeightedCapacity(256L).weigher(c2).build();
        this.namedSourceHistoryCache = new ConcurrentLinkedHashMap.Builder().initialCapacity(128).maximumWeightedCapacity(256L).weigher(c2).build();
    }

    public void setClassDenylist(b b2) {
        this.denylist = b2;
    }

    public void onTraceReported(Finding finding) {
        if (this.enabled) {
            Trace trace = finding.getTrace();
            HashMap<StackTraceElement, String> hashMap = new HashMap<StackTraceElement, String>(128);
            for (CodeEvent codeEvent : trace.getEvents()) {
                CodeEvent codeEvent2;
                if (codeEvent instanceof SourceEvent) {
                    codeEvent2 = (SourceEvent)codeEvent;
                    this.incrementSourceHistory(finding.getRequest(), (SourceEvent)codeEvent2);
                }
                if (!(codeEvent instanceof PropagationEvent)) continue;
                codeEvent2 = (PropagationEvent)codeEvent;
                this.incrementPropagationFrameHistory(hashMap, (PropagationEvent)codeEvent2);
            }
        }
    }

    private void incrementPropagationFrameHistory(Map<StackTraceElement, String> map, PropagationEvent propagationEvent) {
        StackCapture stackCapture = propagationEvent.getStack();
        if (stackCapture == null) {
            return;
        }
        List<StackTraceElement> list = stackCapture.traceWithoutLeadingContrastCode();
        for (int i2 = 0; i2 < list.size() && i2 < 10; ++i2) {
            StackTraceElement stackTraceElement = list.get(i2);
            String string = this.getFrameKey(stackTraceElement, map);
            f f2 = (f)this.propagationFrameHistoryCache.get(string);
            if (f2 == null) continue;
            f2.c();
        }
    }

    private void incrementSourceHistory(HttpRequest httpRequest, SourceEvent sourceEvent) {
        SourceNode sourceNode = sourceEvent.getSource();
        if (sourceNode.isSourceType(u.g) || sourceNode.isSourceType(u.d) || sourceNode.isSourceType(u.c)) {
            g g2;
            int n2 = sourceEvent.getIdentityHash();
            if (this.includeRequestUriInSourceIdentity) {
                n2 += this.getRequestHash(httpRequest);
            }
            if ((g2 = (g)this.namedSourceHistoryCache.get(n2)) != null) {
                g2.c();
            }
        }
    }

    private int getRequestHash(HttpRequest httpRequest) {
        return httpRequest != null ? httpRequest.getNormalizedUri().hashCode() : 0;
    }

    public boolean isSourceIdentityAllowed(ContrastContext contrastContext, int n2, boolean bl2) {
        boolean bl3 = true;
        if (this.enabled) {
            g g2;
            if (this.includeRequestUriInSourceIdentity) {
                n2 += this.getRequestHash(contrastContext.http().getRequest());
            }
            if ((g2 = (g)this.namedSourceHistoryCache.get(n2)) != null && !g2.b() && g2.a(this.maximum)) {
                bl3 = false;
            }
            if (bl2) {
                if (g2 == null) {
                    g2 = new g();
                    this.namedSourceHistoryCache.putIfAbsent(n2, g2);
                }
                ((g)this.namedSourceHistoryCache.get(n2)).d();
            }
        }
        return bl3;
    }

    private String getFrameKey(StackTraceElement stackTraceElement, Map<StackTraceElement, String> map) {
        String string = map.get(stackTraceElement);
        if (string == null) {
            string = this.buildFrameKey(stackTraceElement);
            map.put(stackTraceElement, string);
        }
        return string;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl2) {
        this.enabled = bl2;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public void setFrequency(int n2) {
        this.frequency = n2;
    }

    public void setMaximum(int n2) {
        this.maximum = n2;
    }

    public f putPropagatorFrameHistoryIfAbsent(String string, f f2) {
        f f3 = this.propagationFrameHistoryCache.putIfAbsent(string, f2);
        if (f3 == null) {
            return f2;
        }
        return f3;
    }

    public f getFrameHistory(String string) {
        return (f)this.propagationFrameHistoryCache.get(string);
    }

    public String buildFrameKey(StackTraceElement stackTraceElement) {
        return stackTraceElement.getClassName() + '#' + stackTraceElement.getMethodName();
    }

    public boolean isExcludedFromTransformation(StackTraceElement stackTraceElement) {
        return this.denylist != null && !this.denylist.a(stackTraceElement.getClassName());
    }

    public ConcurrentMap<Integer, g> getNamedSourceHistoryCache() {
        return this.namedSourceHistoryCache;
    }
}

