/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.cesyb.scalar;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

class DateTimeParser
extends DateFormat {
    private static final String DATEFORMAT_YAML = "yyyy-MM-dd HH:mm:ss";
    private static final int FORMAT_NONE = -1;
    private SimpleDateFormat outputFormat;
    private ArrayList<Parser> parsers = new ArrayList();

    public DateTimeParser() {
        this.outputFormat = new SimpleDateFormat(DATEFORMAT_YAML);
        this.parsers.add(new SimpleParser(this.outputFormat));
        this.parsers.add(new Parser(){

            public Date parse(String string) throws ParseException {
                try {
                    long l2 = Long.parseLong(string);
                    return new Date(l2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParseException("Error parsing value", -1);
                }
            }
        });
        this.parsers.add(new SimpleParser("yyyy-MM-dd"));
        this.parsers.add(new SimpleParser(0, 0));
        this.parsers.add(new SimpleParser(1, 1));
        this.parsers.add(new SimpleParser(2, 2));
        this.parsers.add(new SimpleParser(3, 3));
        this.parsers.add(new SimpleParser(0, -1));
        this.parsers.add(new SimpleParser(1, -1));
        this.parsers.add(new SimpleParser(2, -1));
        this.parsers.add(new SimpleParser(3, -1));
        this.parsers.add(new SimpleParser(-1, 0));
        this.parsers.add(new SimpleParser(-1, 1));
        this.parsers.add(new SimpleParser(-1, 2));
        this.parsers.add(new SimpleParser(-1, 3));
    }

    public Date parse(String string, ParsePosition parsePosition) {
        String string2 = string.substring(parsePosition.getIndex());
        Date date = null;
        for (Parser parser : this.parsers) {
            try {
                date = parser.parse(string2);
                break;
            }
            catch (ParseException parseException) {
            }
        }
        if (date == null) {
            parsePosition.setIndex(parsePosition.getIndex());
            parsePosition.setErrorIndex(parsePosition.getIndex());
        } else {
            parsePosition.setIndex(string2.length());
        }
        return date;
    }

    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.outputFormat.format(date, stringBuffer, fieldPosition);
    }

    protected static class SimpleParser
    implements Parser {
        private DateFormat format;

        public SimpleParser(String string) {
            this.format = new SimpleDateFormat(string);
        }

        public SimpleParser(DateFormat dateFormat) {
            this.format = dateFormat;
        }

        public SimpleParser(int n2, int n3) {
            this.format = n3 < 0 ? DateFormat.getDateInstance(n2) : (n2 < 0 ? DateFormat.getTimeInstance(n3) : DateFormat.getDateTimeInstance(n2, n3));
        }

        public Date parse(String string) throws ParseException {
            return this.format.parse(string);
        }
    }

    protected static interface Parser {
        public Date parse(String var1) throws ParseException;
    }
}

