/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.cggl.protobuf;

import com.contrastsecurity.thirdparty.cggl.protobuf.Descriptors;
import com.contrastsecurity.thirdparty.cggl.protobuf.Extension;
import com.contrastsecurity.thirdparty.cggl.protobuf.ExtensionRegistryLite;
import com.contrastsecurity.thirdparty.cggl.protobuf.GeneratedMessage;
import com.contrastsecurity.thirdparty.cggl.protobuf.Message;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ExtensionRegistry
extends ExtensionRegistryLite {
    private final Map<String, ExtensionInfo> immutableExtensionsByName;
    private final Map<String, ExtensionInfo> mutableExtensionsByName;
    private final Map<DescriptorIntPair, ExtensionInfo> immutableExtensionsByNumber;
    private final Map<DescriptorIntPair, ExtensionInfo> mutableExtensionsByNumber;
    static final ExtensionRegistry EMPTY_REGISTRY = new ExtensionRegistry(true);

    public static ExtensionRegistry newInstance() {
        return new ExtensionRegistry();
    }

    public static ExtensionRegistry getEmptyRegistry() {
        return EMPTY_REGISTRY;
    }

    @Override
    public ExtensionRegistry getUnmodifiable() {
        return new ExtensionRegistry(this);
    }

    @Deprecated
    public ExtensionInfo findExtensionByName(String string) {
        return this.findImmutableExtensionByName(string);
    }

    public ExtensionInfo findImmutableExtensionByName(String string) {
        return this.immutableExtensionsByName.get(string);
    }

    public ExtensionInfo findMutableExtensionByName(String string) {
        return this.mutableExtensionsByName.get(string);
    }

    @Deprecated
    public ExtensionInfo findExtensionByNumber(Descriptors.Descriptor descriptor, int n2) {
        return this.findImmutableExtensionByNumber(descriptor, n2);
    }

    public ExtensionInfo findImmutableExtensionByNumber(Descriptors.Descriptor descriptor, int n2) {
        return this.immutableExtensionsByNumber.get(new DescriptorIntPair(descriptor, n2));
    }

    public ExtensionInfo findMutableExtensionByNumber(Descriptors.Descriptor descriptor, int n2) {
        return this.mutableExtensionsByNumber.get(new DescriptorIntPair(descriptor, n2));
    }

    public Set<ExtensionInfo> getAllMutableExtensionsByExtendedType(String string) {
        HashSet<ExtensionInfo> hashSet = new HashSet<ExtensionInfo>();
        for (DescriptorIntPair descriptorIntPair : this.mutableExtensionsByNumber.keySet()) {
            if (!descriptorIntPair.descriptor.getFullName().equals(string)) continue;
            hashSet.add(this.mutableExtensionsByNumber.get(descriptorIntPair));
        }
        return hashSet;
    }

    public Set<ExtensionInfo> getAllImmutableExtensionsByExtendedType(String string) {
        HashSet<ExtensionInfo> hashSet = new HashSet<ExtensionInfo>();
        for (DescriptorIntPair descriptorIntPair : this.immutableExtensionsByNumber.keySet()) {
            if (!descriptorIntPair.descriptor.getFullName().equals(string)) continue;
            hashSet.add(this.immutableExtensionsByNumber.get(descriptorIntPair));
        }
        return hashSet;
    }

    public void add(Extension<?, ?> extension) {
        if (extension.getExtensionType() != Extension.ExtensionType.IMMUTABLE && extension.getExtensionType() != Extension.ExtensionType.MUTABLE) {
            return;
        }
        this.add(ExtensionRegistry.newExtensionInfo(extension), extension.getExtensionType());
    }

    public void add(GeneratedMessage.GeneratedExtension<?, ?> generatedExtension) {
        this.add((Extension<?, ?>)generatedExtension);
    }

    static ExtensionInfo newExtensionInfo(Extension<?, ?> extension) {
        if (extension.getDescriptor().getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
            if (extension.getMessageDefaultInstance() == null) {
                throw new IllegalStateException("Registered message-type extension had null default instance: " + extension.getDescriptor().getFullName());
            }
            return new ExtensionInfo(extension.getDescriptor(), extension.getMessageDefaultInstance());
        }
        return new ExtensionInfo(extension.getDescriptor(), null);
    }

    public void add(Descriptors.FieldDescriptor fieldDescriptor) {
        if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
            throw new IllegalArgumentException("ExtensionRegistry.add() must be provided a default instance when adding an embedded message extension.");
        }
        ExtensionInfo extensionInfo = new ExtensionInfo(fieldDescriptor, null);
        this.add(extensionInfo, Extension.ExtensionType.IMMUTABLE);
        this.add(extensionInfo, Extension.ExtensionType.MUTABLE);
    }

    public void add(Descriptors.FieldDescriptor fieldDescriptor, Message message) {
        if (fieldDescriptor.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) {
            throw new IllegalArgumentException("ExtensionRegistry.add() provided a default instance for a non-message extension.");
        }
        this.add(new ExtensionInfo(fieldDescriptor, message), Extension.ExtensionType.IMMUTABLE);
    }

    private ExtensionRegistry() {
        this.immutableExtensionsByName = new HashMap<String, ExtensionInfo>();
        this.mutableExtensionsByName = new HashMap<String, ExtensionInfo>();
        this.immutableExtensionsByNumber = new HashMap<DescriptorIntPair, ExtensionInfo>();
        this.mutableExtensionsByNumber = new HashMap<DescriptorIntPair, ExtensionInfo>();
    }

    private ExtensionRegistry(ExtensionRegistry extensionRegistry) {
        super(extensionRegistry);
        this.immutableExtensionsByName = Collections.unmodifiableMap(extensionRegistry.immutableExtensionsByName);
        this.mutableExtensionsByName = Collections.unmodifiableMap(extensionRegistry.mutableExtensionsByName);
        this.immutableExtensionsByNumber = Collections.unmodifiableMap(extensionRegistry.immutableExtensionsByNumber);
        this.mutableExtensionsByNumber = Collections.unmodifiableMap(extensionRegistry.mutableExtensionsByNumber);
    }

    ExtensionRegistry(boolean bl2) {
        super(EMPTY_REGISTRY_LITE);
        this.immutableExtensionsByName = Collections.emptyMap();
        this.mutableExtensionsByName = Collections.emptyMap();
        this.immutableExtensionsByNumber = Collections.emptyMap();
        this.mutableExtensionsByNumber = Collections.emptyMap();
    }

    private void add(ExtensionInfo extensionInfo, Extension.ExtensionType extensionType) {
        Map<DescriptorIntPair, ExtensionInfo> map;
        Map<String, ExtensionInfo> map2;
        if (!extensionInfo.descriptor.isExtension()) {
            throw new IllegalArgumentException("ExtensionRegistry.add() was given a FieldDescriptor for a regular (non-extension) field.");
        }
        switch (extensionType) {
            case IMMUTABLE: {
                map2 = this.immutableExtensionsByName;
                map = this.immutableExtensionsByNumber;
                break;
            }
            case MUTABLE: {
                map2 = this.mutableExtensionsByName;
                map = this.mutableExtensionsByNumber;
                break;
            }
            default: {
                return;
            }
        }
        map2.put(extensionInfo.descriptor.getFullName(), extensionInfo);
        map.put(new DescriptorIntPair(extensionInfo.descriptor.getContainingType(), extensionInfo.descriptor.getNumber()), extensionInfo);
        Descriptors.FieldDescriptor fieldDescriptor = extensionInfo.descriptor;
        if (fieldDescriptor.getContainingType().getOptions().getMessageSetWireFormat() && fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.MESSAGE && fieldDescriptor.isOptional() && fieldDescriptor.getExtensionScope() == fieldDescriptor.getMessageType()) {
            map2.put(fieldDescriptor.getMessageType().getFullName(), extensionInfo);
        }
    }

    private static final class DescriptorIntPair {
        private final Descriptors.Descriptor descriptor;
        private final int number;

        DescriptorIntPair(Descriptors.Descriptor descriptor, int n2) {
            this.descriptor = descriptor;
            this.number = n2;
        }

        public int hashCode() {
            return this.descriptor.hashCode() * 65535 + this.number;
        }

        public boolean equals(Object object) {
            if (!(object instanceof DescriptorIntPair)) {
                return false;
            }
            DescriptorIntPair descriptorIntPair = (DescriptorIntPair)object;
            return this.descriptor == descriptorIntPair.descriptor && this.number == descriptorIntPair.number;
        }
    }

    public static final class ExtensionInfo {
        public final Descriptors.FieldDescriptor descriptor;
        public final Message defaultInstance;

        private ExtensionInfo(Descriptors.FieldDescriptor fieldDescriptor) {
            this.descriptor = fieldDescriptor;
            this.defaultInstance = null;
        }

        private ExtensionInfo(Descriptors.FieldDescriptor fieldDescriptor, Message message) {
            this.descriptor = fieldDescriptor;
            this.defaultInstance = message;
        }
    }
}

