/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.cggl.protobuf;

import com.contrastsecurity.thirdparty.cggl.protobuf.AbstractProtobufList;
import com.contrastsecurity.thirdparty.cggl.protobuf.ByteString;
import com.contrastsecurity.thirdparty.cggl.protobuf.Internal;
import com.contrastsecurity.thirdparty.cggl.protobuf.LazyStringList;
import com.contrastsecurity.thirdparty.cggl.protobuf.UnmodifiableLazyStringList;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;

public class LazyStringArrayList
extends AbstractProtobufList<String>
implements LazyStringList,
RandomAccess {
    private static final LazyStringArrayList EMPTY_LIST = new LazyStringArrayList();
    public static final LazyStringList EMPTY;
    private final List<Object> list;

    static LazyStringArrayList emptyList() {
        return EMPTY_LIST;
    }

    public LazyStringArrayList() {
        this(10);
    }

    public LazyStringArrayList(int n2) {
        this(new ArrayList<Object>(n2));
    }

    public LazyStringArrayList(LazyStringList lazyStringList) {
        this.list = new ArrayList<Object>(lazyStringList.size());
        this.addAll(lazyStringList);
    }

    public LazyStringArrayList(List<String> list) {
        this(new ArrayList<Object>(list));
    }

    private LazyStringArrayList(ArrayList<Object> arrayList) {
        this.list = arrayList;
    }

    public LazyStringArrayList mutableCopyWithCapacity(int n2) {
        if (n2 < this.size()) {
            throw new IllegalArgumentException();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(n2);
        arrayList.addAll(this.list);
        return new LazyStringArrayList(arrayList);
    }

    @Override
    public String get(int n2) {
        Object object = this.list.get(n2);
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof ByteString) {
            ByteString byteString = (ByteString)object;
            String string = byteString.toStringUtf8();
            if (byteString.isValidUtf8()) {
                this.list.set(n2, string);
            }
            return string;
        }
        byte[] byArray = (byte[])object;
        String string = Internal.toStringUtf8(byArray);
        if (Internal.isValidUtf8(byArray)) {
            this.list.set(n2, string);
        }
        return string;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public String set(int n2, String string) {
        this.ensureIsMutable();
        Object object = this.list.set(n2, string);
        return LazyStringArrayList.asString(object);
    }

    @Override
    public void add(int n2, String string) {
        this.ensureIsMutable();
        this.list.add(n2, string);
        ++this.modCount;
    }

    @Override
    private void add(int n2, ByteString byteString) {
        this.ensureIsMutable();
        this.list.add(n2, byteString);
        ++this.modCount;
    }

    @Override
    private void add(int n2, byte[] byArray) {
        this.ensureIsMutable();
        this.list.add(n2, byArray);
        ++this.modCount;
    }

    @Override
    public boolean addAll(Collection<? extends String> collection) {
        return this.addAll(this.size(), collection);
    }

    @Override
    public boolean addAll(int n2, Collection<? extends String> collection) {
        this.ensureIsMutable();
        Collection<? extends String> collection2 = collection instanceof LazyStringList ? ((LazyStringList)collection).getUnderlyingElements() : collection;
        boolean bl2 = this.list.addAll(n2, collection2);
        ++this.modCount;
        return bl2;
    }

    @Override
    public boolean addAllByteString(Collection<? extends ByteString> collection) {
        this.ensureIsMutable();
        boolean bl2 = this.list.addAll(collection);
        ++this.modCount;
        return bl2;
    }

    @Override
    public boolean addAllByteArray(Collection<byte[]> collection) {
        this.ensureIsMutable();
        boolean bl2 = this.list.addAll(collection);
        ++this.modCount;
        return bl2;
    }

    @Override
    public String remove(int n2) {
        this.ensureIsMutable();
        Object object = this.list.remove(n2);
        ++this.modCount;
        return LazyStringArrayList.asString(object);
    }

    @Override
    public void clear() {
        this.ensureIsMutable();
        this.list.clear();
        ++this.modCount;
    }

    @Override
    public void add(ByteString byteString) {
        this.ensureIsMutable();
        this.list.add(byteString);
        ++this.modCount;
    }

    @Override
    public void add(byte[] byArray) {
        this.ensureIsMutable();
        this.list.add(byArray);
        ++this.modCount;
    }

    @Override
    public Object getRaw(int n2) {
        return this.list.get(n2);
    }

    @Override
    public ByteString getByteString(int n2) {
        Object object = this.list.get(n2);
        ByteString byteString = LazyStringArrayList.asByteString(object);
        if (byteString != object) {
            this.list.set(n2, byteString);
        }
        return byteString;
    }

    @Override
    public byte[] getByteArray(int n2) {
        Object object = this.list.get(n2);
        byte[] byArray = LazyStringArrayList.asByteArray(object);
        if (byArray != object) {
            this.list.set(n2, byArray);
        }
        return byArray;
    }

    @Override
    public void set(int n2, ByteString byteString) {
        this.setAndReturn(n2, byteString);
    }

    private Object setAndReturn(int n2, ByteString byteString) {
        this.ensureIsMutable();
        return this.list.set(n2, byteString);
    }

    @Override
    public void set(int n2, byte[] byArray) {
        this.setAndReturn(n2, byArray);
    }

    private Object setAndReturn(int n2, byte[] byArray) {
        this.ensureIsMutable();
        return this.list.set(n2, byArray);
    }

    private static String asString(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof ByteString) {
            return ((ByteString)object).toStringUtf8();
        }
        return Internal.toStringUtf8((byte[])object);
    }

    private static ByteString asByteString(Object object) {
        if (object instanceof ByteString) {
            return (ByteString)object;
        }
        if (object instanceof String) {
            return ByteString.copyFromUtf8((String)object);
        }
        return ByteString.copyFrom((byte[])object);
    }

    private static byte[] asByteArray(Object object) {
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof String) {
            return Internal.toByteArray((String)object);
        }
        return ((ByteString)object).toByteArray();
    }

    @Override
    public List<?> getUnderlyingElements() {
        return Collections.unmodifiableList(this.list);
    }

    @Override
    public void mergeFrom(LazyStringList lazyStringList) {
        this.ensureIsMutable();
        for (Object obj : lazyStringList.getUnderlyingElements()) {
            if (obj instanceof byte[]) {
                byte[] byArray = (byte[])obj;
                this.list.add(Arrays.copyOf(byArray, byArray.length));
                continue;
            }
            this.list.add(obj);
        }
    }

    @Override
    public List<byte[]> asByteArrayList() {
        return new ByteArrayListView(this);
    }

    @Override
    public List<ByteString> asByteStringList() {
        return new ByteStringListView(this);
    }

    @Override
    public LazyStringList getUnmodifiableView() {
        if (this.isModifiable()) {
            return new UnmodifiableLazyStringList(this);
        }
        return this;
    }

    static {
        EMPTY_LIST.makeImmutable();
        EMPTY = EMPTY_LIST;
    }

    private static class ByteStringListView
    extends AbstractList<ByteString>
    implements RandomAccess {
        private final LazyStringArrayList list;

        ByteStringListView(LazyStringArrayList lazyStringArrayList) {
            this.list = lazyStringArrayList;
        }

        @Override
        public ByteString get(int n2) {
            return this.list.getByteString(n2);
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public ByteString set(int n2, ByteString byteString) {
            Object object = this.list.setAndReturn(n2, byteString);
            ++this.modCount;
            return LazyStringArrayList.asByteString(object);
        }

        @Override
        public void add(int n2, ByteString byteString) {
            this.list.add(n2, byteString);
            ++this.modCount;
        }

        @Override
        public ByteString remove(int n2) {
            String string = this.list.remove(n2);
            ++this.modCount;
            return LazyStringArrayList.asByteString(string);
        }
    }

    private static class ByteArrayListView
    extends AbstractList<byte[]>
    implements RandomAccess {
        private final LazyStringArrayList list;

        ByteArrayListView(LazyStringArrayList lazyStringArrayList) {
            this.list = lazyStringArrayList;
        }

        @Override
        public byte[] get(int n2) {
            return this.list.getByteArray(n2);
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public byte[] set(int n2, byte[] byArray) {
            Object object = this.list.setAndReturn(n2, byArray);
            ++this.modCount;
            return LazyStringArrayList.asByteArray(object);
        }

        @Override
        public void add(int n2, byte[] byArray) {
            this.list.add(n2, byArray);
            ++this.modCount;
        }

        @Override
        public byte[] remove(int n2) {
            String string = this.list.remove(n2);
            ++this.modCount;
            return LazyStringArrayList.asByteArray(string);
        }
    }
}

