/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.crmq.tools.jsonrpc;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.crmq.client.AMQP;
import com.contrastsecurity.thirdparty.crmq.client.Channel;
import com.contrastsecurity.thirdparty.crmq.client.StringRpcServer;
import com.contrastsecurity.thirdparty.crmq.tools.jsonrpc.DefaultJsonRpcMapper;
import com.contrastsecurity.thirdparty.crmq.tools.jsonrpc.JsonRpcMapper;
import com.contrastsecurity.thirdparty.crmq.tools.jsonrpc.ProcedureDescription;
import com.contrastsecurity.thirdparty.crmq.tools.jsonrpc.ServiceDescription;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;

public class JsonRpcServer
extends StringRpcServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonRpcServer.class);
    private final JsonRpcMapper mapper;
    public ServiceDescription serviceDescription;
    public Class<?> interfaceClass;
    public Object interfaceInstance;

    public JsonRpcServer(Channel channel, Class<?> clazz, Object object, JsonRpcMapper jsonRpcMapper) throws IOException {
        super(channel);
        this.mapper = jsonRpcMapper;
        this.init(clazz, object);
    }

    public JsonRpcServer(Channel channel, Class<?> clazz, Object object) throws IOException {
        this(channel, clazz, object, new DefaultJsonRpcMapper());
    }

    public JsonRpcServer(Channel channel, String string, Class<?> clazz, Object object, JsonRpcMapper jsonRpcMapper) throws IOException {
        super(channel, string);
        this.mapper = jsonRpcMapper;
        this.init(clazz, object);
    }

    public JsonRpcServer(Channel channel, String string, Class<?> clazz, Object object) throws IOException {
        this(channel, string, clazz, object, new DefaultJsonRpcMapper());
    }

    private void init(Class<?> clazz, Object object) {
        this.interfaceClass = clazz;
        this.interfaceInstance = object;
        this.serviceDescription = new ServiceDescription(clazz);
    }

    @Override
    public String handleStringCall(String string, AMQP.BasicProperties basicProperties) {
        String string2 = this.doCall(string);
        return string2;
    }

    public String doCall(String string) {
        String string2;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Request: {}", (Object)string);
        }
        try {
            JsonRpcMapper.JsonRpcRequest jsonRpcRequest = this.mapper.parse(string, this.serviceDescription);
            if (jsonRpcRequest == null) {
                string2 = this.errorResponse(null, 400, "Bad Request", null);
            } else if (!"1.1".equals(jsonRpcRequest.getVersion())) {
                string2 = this.errorResponse(null, 505, "JSONRPC version not supported", null);
            } else {
                Object object = jsonRpcRequest.getId();
                String string3 = jsonRpcRequest.getMethod();
                Object[] objectArray = jsonRpcRequest.getParameters();
                if (jsonRpcRequest.isSystemDescribe()) {
                    string2 = this.resultResponse(object, this.serviceDescription);
                } else if (jsonRpcRequest.isSystem()) {
                    string2 = this.errorResponse(object, 403, "System methods forbidden", null);
                } else {
                    try {
                        Method method = this.matchingMethod(string3, objectArray);
                        if (LOGGER.isDebugEnabled()) {
                            ArrayList<String> arrayList = new ArrayList<String>();
                            if (objectArray != null) {
                                for (Object object2 : objectArray) {
                                    arrayList.add(String.format("%s (%s)", object2, object2 == null ? "?" : object2.getClass()));
                                }
                            }
                            LOGGER.debug("About to invoke {} method with parameters {}", (Object)method, (Object)arrayList);
                        }
                        Object object3 = method.invoke(this.interfaceInstance, objectArray);
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Invocation returned {} ({})", object3, object3 == null ? "?" : object3.getClass());
                        }
                        string2 = this.resultResponse(object, object3);
                    }
                    catch (Throwable throwable) {
                        Throwables.throwIfCritical(throwable);
                        Throwable throwable2 = throwable;
                        LOGGER.info("Error while processing JSON RPC request", throwable2);
                        string2 = this.errorResponse(object, 500, "Internal Server Error", throwable2);
                    }
                }
            }
        }
        catch (ClassCastException classCastException) {
            string2 = this.errorResponse(null, 400, "Bad Request", null);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Response: {}", (Object)string2);
        }
        return string2;
    }

    public Method matchingMethod(String string, Object[] objectArray) {
        ProcedureDescription procedureDescription = this.serviceDescription.getProcedure(string, objectArray.length);
        return procedureDescription.internal_getMethod();
    }

    private String errorResponse(Object object, int n2, String string, Object object2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("name", "JSONRPCError");
        hashMap.put("code", n2);
        hashMap.put("message", string);
        hashMap.put("error", object2);
        return this.response(object, "error", hashMap);
    }

    private String resultResponse(Object object, Object object2) {
        return this.response(object, "result", object2);
    }

    private String response(Object object, String string, Object object2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("version", "1.1");
        if (object != null) {
            hashMap.put("id", object);
        }
        hashMap.put(string, object2);
        String string2 = this.mapper.write(hashMap);
        return string2;
    }

    public ServiceDescription getServiceDescription() {
        return this.serviceDescription;
    }
}

