/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.binder.cache;

import com.contrastsecurity.thirdparty.imm.common.lang.NonNullApi;
import com.contrastsecurity.thirdparty.imm.common.lang.NonNullFields;
import com.contrastsecurity.thirdparty.imm.common.lang.Nullable;
import com.contrastsecurity.thirdparty.imm.core.instrument.FunctionCounter;
import com.contrastsecurity.thirdparty.imm.core.instrument.FunctionTimer;
import com.contrastsecurity.thirdparty.imm.core.instrument.Gauge;
import com.contrastsecurity.thirdparty.imm.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tag;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tags;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.cache.CacheMeterBinder;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.cache.HazelcastIMapAdapter;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;

@NonNullApi
@NonNullFields
public class HazelcastCacheMetrics
extends CacheMeterBinder<Object> {
    private static final String DESCRIPTION_CACHE_ENTRIES = "The number of entries held by this member";
    private static final String DESCRIPTION_CACHE_ENTRY_MEMORY = "Memory cost of entries held by this member";
    private static final String DESCRIPTION_CACHE_NEAR_REQUESTS = "The number of requests (hits or misses) of near cache entries owned by this member";
    private final HazelcastIMapAdapter cache;

    public static Object monitor(MeterRegistry meterRegistry, Object object, String ... stringArray) {
        return HazelcastCacheMetrics.monitor(meterRegistry, object, Tags.of(stringArray));
    }

    public static Object monitor(MeterRegistry meterRegistry, Object object, Iterable<Tag> iterable) {
        new HazelcastCacheMetrics(object, iterable).bindTo(meterRegistry);
        return object;
    }

    public HazelcastCacheMetrics(Object object, Iterable<Tag> iterable) {
        super(object, HazelcastIMapAdapter.nameOf(object), iterable);
        this.cache = new HazelcastIMapAdapter(object);
    }

    @Override
    protected Long size() {
        HazelcastIMapAdapter.LocalMapStats localMapStats = this.cache.getLocalMapStats();
        if (localMapStats != null) {
            return localMapStats.getOwnedEntryCount();
        }
        return null;
    }

    @Override
    protected long hitCount() {
        HazelcastIMapAdapter.LocalMapStats localMapStats = this.cache.getLocalMapStats();
        if (localMapStats != null) {
            return localMapStats.getHits();
        }
        return 0L;
    }

    @Override
    protected Long missCount() {
        return null;
    }

    @Override
    @Nullable
    protected Long evictionCount() {
        return null;
    }

    @Override
    protected long putCount() {
        HazelcastIMapAdapter.LocalMapStats localMapStats = this.cache.getLocalMapStats();
        if (localMapStats != null) {
            return localMapStats.getPutOperationCount() + localMapStats.getSetOperationCount();
        }
        return 0L;
    }

    @Override
    protected void bindImplementationSpecificMetrics(MeterRegistry meterRegistry) {
        Gauge.builder("cache.entries", this.cache, hazelcastIMapAdapter -> this.getDouble(hazelcastIMapAdapter.getLocalMapStats(), HazelcastIMapAdapter.LocalMapStats::getBackupEntryCount)).tags(this.getTagsWithCacheName()).tag("ownership", "backup").description(DESCRIPTION_CACHE_ENTRIES).register(meterRegistry);
        Gauge.builder("cache.entries", this.cache, hazelcastIMapAdapter -> this.getDouble(hazelcastIMapAdapter.getLocalMapStats(), HazelcastIMapAdapter.LocalMapStats::getOwnedEntryCount)).tags(this.getTagsWithCacheName()).tag("ownership", "owned").description(DESCRIPTION_CACHE_ENTRIES).register(meterRegistry);
        Gauge.builder("cache.entry.memory", this.cache, hazelcastIMapAdapter -> this.getDouble(hazelcastIMapAdapter.getLocalMapStats(), HazelcastIMapAdapter.LocalMapStats::getBackupEntryMemoryCost)).tags(this.getTagsWithCacheName()).tag("ownership", "backup").description(DESCRIPTION_CACHE_ENTRY_MEMORY).baseUnit("bytes").register(meterRegistry);
        Gauge.builder("cache.entry.memory", this.cache, hazelcastIMapAdapter -> this.getDouble(hazelcastIMapAdapter.getLocalMapStats(), HazelcastIMapAdapter.LocalMapStats::getOwnedEntryMemoryCost)).tags(this.getTagsWithCacheName()).tag("ownership", "owned").description(DESCRIPTION_CACHE_ENTRY_MEMORY).baseUnit("bytes").register(meterRegistry);
        FunctionCounter.builder("cache.partition.gets", this.cache, hazelcastIMapAdapter -> this.getDouble(hazelcastIMapAdapter.getLocalMapStats(), HazelcastIMapAdapter.LocalMapStats::getGetOperationCount)).tags(this.getTagsWithCacheName()).description("The total number of get operations executed against this partition").register(meterRegistry);
        this.timings(meterRegistry);
        this.nearCacheMetrics(meterRegistry);
    }

    private double getDouble(HazelcastIMapAdapter.LocalMapStats localMapStats, ToDoubleFunction<HazelcastIMapAdapter.LocalMapStats> toDoubleFunction) {
        return localMapStats != null ? toDoubleFunction.applyAsDouble(localMapStats) : Double.NaN;
    }

    private void nearCacheMetrics(MeterRegistry meterRegistry) {
        HazelcastIMapAdapter.LocalMapStats localMapStats = this.cache.getLocalMapStats();
        if (localMapStats != null && localMapStats.getNearCacheStats() != null) {
            Gauge.builder("cache.near.requests", this.cache, hazelcastIMapAdapter -> this.getDouble(hazelcastIMapAdapter.getLocalMapStats(), localMapStats -> localMapStats.getNearCacheStats().getHits())).tags(this.getTagsWithCacheName()).tag("result", "hit").description(DESCRIPTION_CACHE_NEAR_REQUESTS).register(meterRegistry);
            Gauge.builder("cache.near.requests", this.cache, hazelcastIMapAdapter -> this.getDouble(hazelcastIMapAdapter.getLocalMapStats(), localMapStats -> localMapStats.getNearCacheStats().getMisses())).tags(this.getTagsWithCacheName()).tag("result", "miss").description(DESCRIPTION_CACHE_NEAR_REQUESTS).register(meterRegistry);
            Gauge.builder("cache.near.evictions", this.cache, hazelcastIMapAdapter -> this.getDouble(hazelcastIMapAdapter.getLocalMapStats(), localMapStats -> localMapStats.getNearCacheStats().getEvictions())).tags(this.getTagsWithCacheName()).description("The number of evictions of near cache entries owned by this member").register(meterRegistry);
            Gauge.builder("cache.near.persistences", this.cache, hazelcastIMapAdapter -> this.getDouble(hazelcastIMapAdapter.getLocalMapStats(), localMapStats -> localMapStats.getNearCacheStats().getPersistenceCount())).tags(this.getTagsWithCacheName()).description("The number of near cache key persistences (when the pre-load feature is enabled)").register(meterRegistry);
        }
    }

    private void timings(MeterRegistry meterRegistry) {
        FunctionTimer.builder("cache.gets.latency", this.cache, hazelcastIMapAdapter -> this.getLong(hazelcastIMapAdapter.getLocalMapStats(), HazelcastIMapAdapter.LocalMapStats::getGetOperationCount), hazelcastIMapAdapter -> this.getDouble(hazelcastIMapAdapter.getLocalMapStats(), HazelcastIMapAdapter.LocalMapStats::getTotalGetLatency), TimeUnit.MILLISECONDS).tags(this.getTagsWithCacheName()).description("Cache gets").register(meterRegistry);
        FunctionTimer.builder("cache.puts.latency", this.cache, hazelcastIMapAdapter -> this.getLong(hazelcastIMapAdapter.getLocalMapStats(), HazelcastIMapAdapter.LocalMapStats::getPutOperationCount), hazelcastIMapAdapter -> this.getDouble(hazelcastIMapAdapter.getLocalMapStats(), HazelcastIMapAdapter.LocalMapStats::getTotalPutLatency), TimeUnit.MILLISECONDS).tags(this.getTagsWithCacheName()).description("Cache puts").register(meterRegistry);
        FunctionTimer.builder("cache.removals.latency", this.cache, hazelcastIMapAdapter -> this.getLong(hazelcastIMapAdapter.getLocalMapStats(), HazelcastIMapAdapter.LocalMapStats::getRemoveOperationCount), hazelcastIMapAdapter -> this.getDouble(hazelcastIMapAdapter.getLocalMapStats(), HazelcastIMapAdapter.LocalMapStats::getTotalRemoveLatency), TimeUnit.MILLISECONDS).tags(this.getTagsWithCacheName()).description("Cache removals").register(meterRegistry);
    }

    private long getLong(HazelcastIMapAdapter.LocalMapStats localMapStats, ToLongFunction<HazelcastIMapAdapter.LocalMapStats> toLongFunction) {
        return localMapStats != null ? toLongFunction.applyAsLong(localMapStats) : 0L;
    }
}

