/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.binder.jersey.server;

import com.contrastsecurity.thirdparty.imm.common.KeyValues;
import com.contrastsecurity.thirdparty.imm.common.lang.Nullable;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.jersey.server.JerseyContext;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.jersey.server.JerseyKeyValues;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.jersey.server.JerseyObservationConvention;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.monitoring.RequestEvent;

public class DefaultJerseyObservationConvention
implements JerseyObservationConvention {
    private final String metricsName;

    public DefaultJerseyObservationConvention(String string) {
        this.metricsName = string;
    }

    @Override
    public KeyValues getLowCardinalityKeyValues(JerseyContext jerseyContext) {
        RequestEvent requestEvent = jerseyContext.getRequestEvent();
        ContainerRequest containerRequest = (ContainerRequest)jerseyContext.getCarrier();
        ContainerResponse containerResponse = (ContainerResponse)jerseyContext.getResponse();
        return KeyValues.of(JerseyKeyValues.method(containerRequest), JerseyKeyValues.uri(requestEvent), JerseyKeyValues.exception(requestEvent), JerseyKeyValues.status(containerResponse), JerseyKeyValues.outcome(containerResponse));
    }

    @Override
    public String getName() {
        return this.metricsName;
    }

    @Override
    @Nullable
    public String getContextualName(JerseyContext jerseyContext) {
        if (jerseyContext.getCarrier() == null) {
            return null;
        }
        return "HTTP " + ((ContainerRequest)jerseyContext.getCarrier()).getMethod();
    }
}

