/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.binder.jvm;

import com.contrastsecurity.thirdparty.imm.common.lang.Nullable;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.function.ToLongFunction;
import java.util.stream.Stream;

class JvmMemory {
    private JvmMemory() {
    }

    static Stream<MemoryPoolMXBean> getLongLivedHeapPools() {
        return ManagementFactory.getMemoryPoolMXBeans().stream().filter(JvmMemory::isHeap).filter(memoryPoolMXBean -> JvmMemory.isLongLivedPool(memoryPoolMXBean.getName()));
    }

    static boolean isConcurrentPhase(String string, String string2) {
        return "No GC".equals(string) || "Shenandoah Cycles".equals(string2) || "ZGC Cycles".equals(string2) || string2.startsWith("GPGC") && !string2.endsWith("Pauses");
    }

    static boolean isAllocationPool(String string) {
        return string != null && (string.endsWith("Eden Space") || "Shenandoah".equals(string) || "ZHeap".equals(string) || string.endsWith("New Gen") || string.endsWith("nursery-allocate") || string.endsWith("-eden") || "JavaHeap".equals(string));
    }

    static boolean isLongLivedPool(String string) {
        return string != null && (string.endsWith("Old Gen") || string.endsWith("Tenured Gen") || "Shenandoah".equals(string) || "ZHeap".equals(string) || string.endsWith("balanced-old") || string.contains("tenured") || "JavaHeap".equals(string));
    }

    static boolean isHeap(MemoryPoolMXBean memoryPoolMXBean) {
        return MemoryType.HEAP.equals((Object)memoryPoolMXBean.getType());
    }

    static double getUsageValue(MemoryPoolMXBean memoryPoolMXBean, ToLongFunction<MemoryUsage> toLongFunction) {
        MemoryUsage memoryUsage = JvmMemory.getUsage(memoryPoolMXBean);
        if (memoryUsage == null) {
            return Double.NaN;
        }
        return toLongFunction.applyAsLong(memoryUsage);
    }

    @Nullable
    private static MemoryUsage getUsage(MemoryPoolMXBean memoryPoolMXBean) {
        try {
            return memoryPoolMXBean.getUsage();
        }
        catch (InternalError internalError) {
            return null;
        }
    }
}

