/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.binder.logging;

import com.contrastsecurity.thirdparty.imm.common.lang.NonNullApi;
import com.contrastsecurity.thirdparty.imm.common.lang.NonNullFields;
import com.contrastsecurity.thirdparty.imm.core.instrument.Counter;
import com.contrastsecurity.thirdparty.imm.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tag;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.MeterBinder;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.LogManager;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.AbstractLifeCycle;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.Filter;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.LoggerContext;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.async.AsyncLoggerConfig;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.LoggerConfig;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.filter.AbstractFilter;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.filter.CompositeFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@NonNullApi
@NonNullFields
public class Log4j2Metrics
implements MeterBinder,
AutoCloseable {
    private static final String METER_NAME = "log4j2.events";
    private final Iterable<Tag> tags;
    private final LoggerContext loggerContext;
    private List<MetricsFilter> metricsFilters = new ArrayList<MetricsFilter>();

    public Log4j2Metrics() {
        this(Collections.emptyList());
    }

    public Log4j2Metrics(Iterable<Tag> iterable) {
        this(iterable, (LoggerContext)LogManager.getContext(false));
    }

    public Log4j2Metrics(Iterable<Tag> iterable, LoggerContext loggerContext) {
        this.tags = iterable;
        this.loggerContext = loggerContext;
    }

    @Override
    public void bindTo(MeterRegistry meterRegistry) {
        Configuration configuration = this.loggerContext.getConfiguration();
        LoggerConfig loggerConfig3 = configuration.getRootLogger();
        loggerConfig3.addFilter(this.createMetricsFilterAndStart(meterRegistry, loggerConfig3));
        this.loggerContext.getConfiguration().getLoggers().values().stream().filter(loggerConfig -> !loggerConfig.isAdditive()).forEach(loggerConfig2 -> {
            if (loggerConfig2 == loggerConfig3) {
                return;
            }
            Filter filter2 = loggerConfig2.getFilter();
            if (filter2 instanceof CompositeFilter && Arrays.stream(((CompositeFilter)filter2).getFiltersArray()).anyMatch(filter -> filter instanceof MetricsFilter)) {
                return;
            }
            if (filter2 instanceof MetricsFilter) {
                return;
            }
            loggerConfig2.addFilter(this.createMetricsFilterAndStart(meterRegistry, (LoggerConfig)loggerConfig2));
        });
        this.loggerContext.updateLoggers(configuration);
    }

    private MetricsFilter createMetricsFilterAndStart(MeterRegistry meterRegistry, LoggerConfig loggerConfig) {
        MetricsFilter metricsFilter = new MetricsFilter(meterRegistry, this.tags, loggerConfig instanceof AsyncLoggerConfig);
        metricsFilter.start();
        this.metricsFilters.add(metricsFilter);
        return metricsFilter;
    }

    @Override
    public void close() {
        if (!this.metricsFilters.isEmpty()) {
            Configuration configuration = this.loggerContext.getConfiguration();
            LoggerConfig loggerConfig3 = configuration.getRootLogger();
            this.metricsFilters.forEach(loggerConfig3::removeFilter);
            this.loggerContext.getConfiguration().getLoggers().values().stream().filter(loggerConfig -> !loggerConfig.isAdditive()).forEach(loggerConfig2 -> {
                if (loggerConfig2 != loggerConfig3) {
                    this.metricsFilters.forEach(loggerConfig2::removeFilter);
                }
            });
            this.loggerContext.updateLoggers(configuration);
            this.metricsFilters.forEach(AbstractLifeCycle::stop);
        }
    }

    @NonNullApi
    @NonNullFields
    class MetricsFilter
    extends AbstractFilter {
        private final Counter fatalCounter;
        private final Counter errorCounter;
        private final Counter warnCounter;
        private final Counter infoCounter;
        private final Counter debugCounter;
        private final Counter traceCounter;
        private final boolean isAsyncLogger;

        MetricsFilter(MeterRegistry meterRegistry, Iterable<Tag> iterable, boolean bl2) {
            this.isAsyncLogger = bl2;
            this.fatalCounter = Counter.builder(Log4j2Metrics.METER_NAME).tags(iterable).tags("level", "fatal").description("Number of fatal level log events").baseUnit("events").register(meterRegistry);
            this.errorCounter = Counter.builder(Log4j2Metrics.METER_NAME).tags(iterable).tags("level", "error").description("Number of error level log events").baseUnit("events").register(meterRegistry);
            this.warnCounter = Counter.builder(Log4j2Metrics.METER_NAME).tags(iterable).tags("level", "warn").description("Number of warn level log events").baseUnit("events").register(meterRegistry);
            this.infoCounter = Counter.builder(Log4j2Metrics.METER_NAME).tags(iterable).tags("level", "info").description("Number of info level log events").baseUnit("events").register(meterRegistry);
            this.debugCounter = Counter.builder(Log4j2Metrics.METER_NAME).tags(iterable).tags("level", "debug").description("Number of debug level log events").baseUnit("events").register(meterRegistry);
            this.traceCounter = Counter.builder(Log4j2Metrics.METER_NAME).tags(iterable).tags("level", "trace").description("Number of trace level log events").baseUnit("events").register(meterRegistry);
        }

        @Override
        public Filter.Result filter(LogEvent logEvent) {
            if (!this.isAsyncLogger || this.isAsyncLoggerAndEndOfBatch(logEvent)) {
                this.incrementCounter(logEvent);
            }
            return Filter.Result.NEUTRAL;
        }

        private boolean isAsyncLoggerAndEndOfBatch(LogEvent logEvent) {
            return this.isAsyncLogger && logEvent.isEndOfBatch();
        }

        private void incrementCounter(LogEvent logEvent) {
            switch (logEvent.getLevel().getStandardLevel()) {
                case FATAL: {
                    this.fatalCounter.increment();
                    break;
                }
                case ERROR: {
                    this.errorCounter.increment();
                    break;
                }
                case WARN: {
                    this.warnCounter.increment();
                    break;
                }
                case INFO: {
                    this.infoCounter.increment();
                    break;
                }
                case DEBUG: {
                    this.debugCounter.increment();
                    break;
                }
                case TRACE: {
                    this.traceCounter.increment();
                    break;
                }
            }
        }
    }
}

