/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.config;

import com.contrastsecurity.thirdparty.imm.core.instrument.config.MeterRegistryConfig;
import com.contrastsecurity.thirdparty.imm.core.instrument.config.validate.Validated;
import com.contrastsecurity.thirdparty.imm.core.instrument.config.validate.ValidationException;
import java.util.Arrays;
import java.util.function.Function;

public class MeterRegistryConfigValidator {
    private MeterRegistryConfigValidator() {
    }

    @SafeVarargs
    public static <M extends MeterRegistryConfig> Validated<?> checkAll(M m2, Function<M, ? extends Validated<?>> ... functionArray) {
        return Arrays.stream(functionArray).map(function -> (Validated)function.apply(m2)).map(validated -> validated).reduce(Validated.none(), (validated, validated2) -> validated.and((Validated<?>)validated2));
    }

    public static <M extends MeterRegistryConfig, T> Function<M, Validated<T>> check(String string, Function<M, T> function) {
        return meterRegistryConfig -> {
            try {
                return Validated.valid(meterRegistryConfig.prefix() + '.' + string, function.apply(meterRegistryConfig));
            }
            catch (ValidationException validationException) {
                return validationException.getValidation().failures().iterator().next();
            }
        };
    }

    public static <M extends MeterRegistryConfig, T> Function<M, Validated<T>> checkRequired(String string, Function<M, T> function) {
        return MeterRegistryConfigValidator.check(string, function).andThen(Validated::required);
    }
}

