/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.cumulative;

import com.contrastsecurity.thirdparty.imm.core.instrument.AbstractDistributionSummary;
import com.contrastsecurity.thirdparty.imm.core.instrument.Clock;
import com.contrastsecurity.thirdparty.imm.core.instrument.Measurement;
import com.contrastsecurity.thirdparty.imm.core.instrument.Meter;
import com.contrastsecurity.thirdparty.imm.core.instrument.Statistic;
import com.contrastsecurity.thirdparty.imm.core.instrument.distribution.DistributionStatisticConfig;
import com.contrastsecurity.thirdparty.imm.core.instrument.distribution.Histogram;
import com.contrastsecurity.thirdparty.imm.core.instrument.distribution.TimeWindowMax;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.DoubleAdder;

public class CumulativeDistributionSummary
extends AbstractDistributionSummary {
    private final AtomicLong count = new AtomicLong();
    private final DoubleAdder total = new DoubleAdder();
    private final TimeWindowMax max;

    @Deprecated
    public CumulativeDistributionSummary(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, double d2) {
        this(id, clock, distributionStatisticConfig, d2, false);
    }

    public CumulativeDistributionSummary(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, double d2, boolean bl2) {
        this(id, clock, distributionStatisticConfig, d2, AbstractDistributionSummary.defaultHistogram(clock, distributionStatisticConfig, bl2));
    }

    protected CumulativeDistributionSummary(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, double d2, Histogram histogram) {
        super(id, d2, histogram);
        this.max = new TimeWindowMax(clock, distributionStatisticConfig);
    }

    @Override
    protected void recordNonNegative(double d2) {
        this.count.incrementAndGet();
        this.total.add(d2);
        this.max.record(d2);
    }

    @Override
    public long count() {
        return this.count.get();
    }

    @Override
    public double totalAmount() {
        return this.total.sum();
    }

    @Override
    public double max() {
        return this.max.poll();
    }

    @Override
    public Iterable<Measurement> measure() {
        return Arrays.asList(new Measurement(() -> this.count(), Statistic.COUNT), new Measurement(this::totalAmount, Statistic.TOTAL), new Measurement(this::max, Statistic.MAX));
    }
}

