/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.logging;

import com.contrastsecurity.thirdparty.imm.common.lang.Nullable;
import com.contrastsecurity.thirdparty.imm.common.util.internal.logging.InternalLogger;
import com.contrastsecurity.thirdparty.imm.common.util.internal.logging.InternalLoggerFactory;
import com.contrastsecurity.thirdparty.imm.core.annotation.Incubating;
import com.contrastsecurity.thirdparty.imm.core.instrument.Clock;
import com.contrastsecurity.thirdparty.imm.core.instrument.DistributionSummary;
import com.contrastsecurity.thirdparty.imm.core.instrument.Meter;
import com.contrastsecurity.thirdparty.imm.core.instrument.Timer;
import com.contrastsecurity.thirdparty.imm.core.instrument.config.NamingConvention;
import com.contrastsecurity.thirdparty.imm.core.instrument.distribution.DistributionStatisticConfig;
import com.contrastsecurity.thirdparty.imm.core.instrument.distribution.HistogramSnapshot;
import com.contrastsecurity.thirdparty.imm.core.instrument.distribution.pause.PauseDetector;
import com.contrastsecurity.thirdparty.imm.core.instrument.logging.LoggingRegistryConfig;
import com.contrastsecurity.thirdparty.imm.core.instrument.step.StepDistributionSummary;
import com.contrastsecurity.thirdparty.imm.core.instrument.step.StepMeterRegistry;
import com.contrastsecurity.thirdparty.imm.core.instrument.step.StepTimer;
import com.contrastsecurity.thirdparty.imm.core.instrument.util.DoubleFormat;
import com.contrastsecurity.thirdparty.imm.core.instrument.util.NamedThreadFactory;
import com.contrastsecurity.thirdparty.imm.core.instrument.util.TimeUtils;
import java.time.Duration;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

@Incubating(since="1.1.0")
public class LoggingMeterRegistry
extends StepMeterRegistry {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(LoggingMeterRegistry.class);
    private final LoggingRegistryConfig config;
    private final Consumer<String> loggingSink;
    private final Function<Meter, String> meterIdPrinter;

    public LoggingMeterRegistry() {
        this(LoggingRegistryConfig.DEFAULT, Clock.SYSTEM);
    }

    public LoggingMeterRegistry(LoggingRegistryConfig loggingRegistryConfig, Clock clock) {
        this(loggingRegistryConfig, clock, log::info);
    }

    public LoggingMeterRegistry(Consumer<String> consumer) {
        this(LoggingRegistryConfig.DEFAULT, Clock.SYSTEM, consumer);
    }

    public LoggingMeterRegistry(LoggingRegistryConfig loggingRegistryConfig, Clock clock, Consumer<String> consumer) {
        this(loggingRegistryConfig, clock, new NamedThreadFactory("logging-metrics-publisher"), consumer, null);
    }

    private LoggingMeterRegistry(LoggingRegistryConfig loggingRegistryConfig, Clock clock, ThreadFactory threadFactory, Consumer<String> consumer, @Nullable Function<Meter, String> function) {
        super(loggingRegistryConfig, clock);
        this.config = loggingRegistryConfig;
        this.loggingSink = consumer;
        this.meterIdPrinter = function != null ? function : this.defaultMeterIdPrinter();
        this.config().namingConvention(NamingConvention.dot);
        this.start(threadFactory);
    }

    private Function<Meter, String> defaultMeterIdPrinter() {
        return meter -> this.getConventionName(meter.getId()) + this.getConventionTags(meter.getId()).stream().map(tag -> tag.getKey() + "=" + tag.getValue()).collect(Collectors.joining(",", "{", "}"));
    }

    @Override
    protected void publish() {
        if (this.config.enabled()) {
            this.getMeters().stream().sorted((meter, meter2) -> {
                int n2 = meter.getId().getType().compareTo(meter2.getId().getType());
                if (n2 == 0) {
                    return meter.getId().getName().compareTo(meter2.getId().getName());
                }
                return n2;
            }).forEach(meter2 -> {
                Printer printer = new Printer((Meter)meter2);
                meter2.use(gauge -> this.loggingSink.accept(printer.id() + " value=" + printer.value(gauge.value())), counter -> {
                    double d2 = counter.count();
                    if (!this.config.logInactive() && d2 == 0.0) {
                        return;
                    }
                    this.loggingSink.accept(printer.id() + " throughput=" + printer.rate(d2));
                }, timer -> {
                    HistogramSnapshot histogramSnapshot = timer.takeSnapshot();
                    long l2 = histogramSnapshot.count();
                    if (!this.config.logInactive() && l2 == 0L) {
                        return;
                    }
                    this.loggingSink.accept(printer.id() + " throughput=" + printer.unitlessRate(l2) + " mean=" + printer.time(histogramSnapshot.mean(this.getBaseTimeUnit())) + " max=" + printer.time(histogramSnapshot.max(this.getBaseTimeUnit())));
                }, distributionSummary -> {
                    HistogramSnapshot histogramSnapshot = distributionSummary.takeSnapshot();
                    long l2 = histogramSnapshot.count();
                    if (!this.config.logInactive() && l2 == 0L) {
                        return;
                    }
                    this.loggingSink.accept(printer.id() + " throughput=" + printer.unitlessRate(l2) + " mean=" + printer.value(histogramSnapshot.mean()) + " max=" + printer.value(histogramSnapshot.max()));
                }, longTaskTimer -> {
                    int n2 = longTaskTimer.activeTasks();
                    if (!this.config.logInactive() && n2 == 0) {
                        return;
                    }
                    this.loggingSink.accept(printer.id() + " active=" + printer.value(n2) + " duration=" + printer.time(longTaskTimer.duration(this.getBaseTimeUnit())));
                }, timeGauge -> {
                    double d2 = timeGauge.value(this.getBaseTimeUnit());
                    if (!this.config.logInactive() && d2 == 0.0) {
                        return;
                    }
                    this.loggingSink.accept(printer.id() + " value=" + printer.time(d2));
                }, functionCounter -> {
                    double d2 = functionCounter.count();
                    if (!this.config.logInactive() && d2 == 0.0) {
                        return;
                    }
                    this.loggingSink.accept(printer.id() + " throughput=" + printer.rate(d2));
                }, functionTimer -> {
                    double d2 = functionTimer.count();
                    if (!this.config.logInactive() && d2 == 0.0) {
                        return;
                    }
                    this.loggingSink.accept(printer.id() + " throughput=" + printer.rate(d2) + " mean=" + printer.time(functionTimer.mean(this.getBaseTimeUnit())));
                }, meter -> this.loggingSink.accept(this.writeMeter((Meter)meter, printer)));
            });
        }
    }

    String writeMeter(Meter meter, Printer printer) {
        return StreamSupport.stream(meter.measure().spliterator(), false).map(measurement -> {
            String string = measurement.getStatistic().getTagValueRepresentation() + "=";
            switch (measurement.getStatistic()) {
                case TOTAL: 
                case MAX: 
                case VALUE: {
                    return string + printer.value(measurement.getValue());
                }
                case TOTAL_TIME: 
                case DURATION: {
                    return string + printer.time(measurement.getValue());
                }
                case COUNT: {
                    return "throughput=" + printer.rate(measurement.getValue());
                }
            }
            return string + DoubleFormat.decimalOrNan(measurement.getValue());
        }).collect(Collectors.joining(", ", printer.id() + " ", ""));
    }

    @Override
    protected Timer newTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector) {
        return new StepTimer(id, this.clock, distributionStatisticConfig, pauseDetector, this.getBaseTimeUnit(), this.config.step().toMillis(), false);
    }

    @Override
    protected DistributionSummary newDistributionSummary(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, double d2) {
        return new StepDistributionSummary(id, this.clock, distributionStatisticConfig, d2, this.config.step().toMillis(), false);
    }

    @Override
    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.MILLISECONDS;
    }

    public static Builder builder(LoggingRegistryConfig loggingRegistryConfig) {
        return new Builder(loggingRegistryConfig);
    }

    static /* synthetic */ InternalLogger access$200() {
        return log;
    }

    class Printer {
        private final Meter meter;

        Printer(Meter meter) {
            this.meter = meter;
        }

        String id() {
            return (String)LoggingMeterRegistry.this.meterIdPrinter.apply(this.meter);
        }

        String time(double d2) {
            return TimeUtils.format(Duration.ofNanos((long)TimeUtils.convert(d2, LoggingMeterRegistry.this.getBaseTimeUnit(), TimeUnit.NANOSECONDS)));
        }

        String rate(double d2) {
            return this.humanReadableBaseUnit(d2 / (double)LoggingMeterRegistry.this.config.step().getSeconds()) + "/s";
        }

        String unitlessRate(double d2) {
            return DoubleFormat.decimalOrNan(d2 / (double)LoggingMeterRegistry.this.config.step().getSeconds()) + "/s";
        }

        String value(double d2) {
            return this.humanReadableBaseUnit(d2);
        }

        String humanReadableByteCount(double d2) {
            int n2 = 1024;
            if (d2 < (double)n2 || Double.isNaN(d2)) {
                return DoubleFormat.decimalOrNan(d2) + " B";
            }
            int n3 = (int)(Math.log(d2) / Math.log(n2));
            String string = "KMGTPE".charAt(n3 - 1) + "i";
            return DoubleFormat.decimalOrNan(d2 / Math.pow(n2, n3)) + " " + string + "B";
        }

        String humanReadableBaseUnit(double d2) {
            String string = this.meter.getId().getBaseUnit();
            if ("bytes".equals(string)) {
                return this.humanReadableByteCount(d2);
            }
            return DoubleFormat.decimalOrNan(d2) + (string != null ? " " + string : "");
        }
    }

    public static class Builder {
        private final LoggingRegistryConfig config;
        private Clock clock = Clock.SYSTEM;
        private ThreadFactory threadFactory = new NamedThreadFactory("logging-metrics-publisher");
        private Consumer<String> loggingSink = LoggingMeterRegistry.access$200()::info;
        @Nullable
        private Function<Meter, String> meterIdPrinter;

        Builder(LoggingRegistryConfig loggingRegistryConfig) {
            this.config = loggingRegistryConfig;
        }

        public Builder clock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public Builder loggingSink(Consumer<String> consumer) {
            this.loggingSink = consumer;
            return this;
        }

        public Builder meterIdPrinter(Function<Meter, String> function) {
            this.meterIdPrinter = function;
            return this;
        }

        public LoggingMeterRegistry build() {
            return new LoggingMeterRegistry(this.config, this.clock, this.threadFactory, this.loggingSink, this.meterIdPrinter);
        }
    }
}

