/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.ipc.http;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.imm.common.lang.Nullable;
import com.contrastsecurity.thirdparty.imm.common.util.StringUtils;
import com.contrastsecurity.thirdparty.imm.core.ipc.http.HttpStatusClass;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.zip.GZIPOutputStream;

public interface HttpSender {
    public Response send(Request var1) throws Throwable;

    default public Request.Builder post(String string) {
        return this.newRequest(string).withMethod(Method.POST);
    }

    default public Request.Builder head(String string) {
        return this.newRequest(string).withMethod(Method.HEAD);
    }

    default public Request.Builder put(String string) {
        return this.newRequest(string).withMethod(Method.PUT);
    }

    default public Request.Builder get(String string) {
        return this.newRequest(string).withMethod(Method.GET);
    }

    default public Request.Builder delete(String string) {
        return this.newRequest(string).withMethod(Method.DELETE);
    }

    default public Request.Builder options(String string) {
        return this.newRequest(string).withMethod(Method.OPTIONS);
    }

    default public Request.Builder newRequest(String string) {
        return new Request.Builder(string, this);
    }

    public static class Request {
        private final URL url;
        private final byte[] entity;
        private final Method method;
        private final Map<String, String> requestHeaders;

        public Request(URL uRL, byte[] byArray, Method method, Map<String, String> map) {
            this.url = uRL;
            this.entity = byArray;
            this.method = method;
            this.requestHeaders = map;
        }

        public URL getUrl() {
            return this.url;
        }

        public byte[] getEntity() {
            return this.entity;
        }

        public Method getMethod() {
            return this.method;
        }

        public Map<String, String> getRequestHeaders() {
            return this.requestHeaders;
        }

        public static Builder build(String string, HttpSender httpSender) {
            return new Builder(string, httpSender);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.method.toString()).append(' ').append(this.url.toString()).append("\n");
            if (this.entity.length == 0) {
                stringBuilder.append("<no request body>");
            } else {
                stringBuilder.append(new String(this.entity));
            }
            return stringBuilder.toString();
        }

        public static class Builder {
            private static final String APPLICATION_JSON = "application/json";
            private static final String TEXT_PLAIN = "text/plain";
            private final URL url;
            private final HttpSender sender;
            private byte[] entity = new byte[0];
            private Method method;
            private Map<String, String> requestHeaders = new LinkedHashMap<String, String>();

            Builder(String string, HttpSender httpSender) {
                try {
                    this.url = URI.create(string).toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    throw new UncheckedIOException(malformedURLException);
                }
                this.sender = httpSender;
            }

            public final Builder withHeader(String string, String string2) {
                this.requestHeaders.put(string, string2);
                return this;
            }

            public final Builder withBasicAuthentication(@Nullable String string, @Nullable String string2) {
                if (StringUtils.isNotBlank(string)) {
                    String string3 = Base64.getEncoder().encodeToString((string.trim() + ":" + (string2 == null ? "" : string2.trim())).getBytes(StandardCharsets.UTF_8));
                    this.withAuthentication("Basic", string3);
                }
                return this;
            }

            public final Builder withAuthentication(String string, @Nullable String string2) {
                if (StringUtils.isNotBlank(string2)) {
                    this.withHeader("Authorization", string + " " + string2);
                }
                return this;
            }

            public final Builder withJsonContent(String string) {
                return this.withContent(APPLICATION_JSON, string);
            }

            public final Builder withPlainText(String string) {
                return this.withContent(TEXT_PLAIN, string);
            }

            public final Builder withContent(String string, String string2) {
                return this.withContent(string, string2.getBytes(StandardCharsets.UTF_8));
            }

            public final Builder withContent(String string, byte[] byArray) {
                this.withHeader("Content-Type", string);
                this.entity = byArray;
                return this;
            }

            public Builder acceptJson() {
                return this.accept(APPLICATION_JSON);
            }

            public Builder accept(String string) {
                return this.withHeader("Accept", string);
            }

            public final Builder withMethod(Method method) {
                this.method = method;
                return this;
            }

            public final Builder compress() throws IOException {
                this.withHeader("Content-Encoding", "gzip");
                this.entity = Builder.gzip(this.entity);
                return this;
            }

            public final Builder compressWhen(Supplier<Boolean> supplier) throws IOException {
                if (supplier.get().booleanValue()) {
                    return this.compress();
                }
                return this;
            }

            private static byte[] gzip(byte[] byArray) throws IOException {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
                GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
                try {
                    gZIPOutputStream.write(byArray);
                }
                catch (Throwable throwable) {
                    Throwables.throwIfCritical(throwable);
                    Throwable throwable2 = throwable;
                    try {
                        gZIPOutputStream.close();
                    }
                    catch (Throwable throwable3) {
                        Throwables.throwIfCritical(throwable3);
                        Throwable throwable4 = throwable3;
                        throwable2.addSuppressed(throwable4);
                    }
                    throw throwable2;
                }
                gZIPOutputStream.close();
                return byteArrayOutputStream.toByteArray();
            }

            public final Builder print() {
                System.out.println(new Request(this.url, this.entity, this.method, this.requestHeaders));
                return this;
            }

            public Response send() throws Throwable {
                return this.sender.send(new Request(this.url, this.entity, this.method, this.requestHeaders));
            }
        }
    }

    public static enum Method {
        GET,
        HEAD,
        POST,
        PUT,
        DELETE,
        OPTIONS;

    }

    public static class Response {
        public static final String NO_RESPONSE_BODY = "<no response body>";
        private final int code;
        private final String body;

        public Response(int n2, @Nullable String string) {
            this.code = n2;
            this.body = StringUtils.isBlank(string) ? NO_RESPONSE_BODY : string;
        }

        public int code() {
            return this.code;
        }

        public String body() {
            return this.body;
        }

        public Response onSuccess(Consumer<Response> consumer) {
            switch (HttpStatusClass.valueOf(this.code)) {
                case INFORMATIONAL: 
                case SUCCESS: {
                    consumer.accept(this);
                }
            }
            return this;
        }

        public Response onError(Consumer<Response> consumer) {
            switch (HttpStatusClass.valueOf(this.code)) {
                case CLIENT_ERROR: 
                case SERVER_ERROR: {
                    consumer.accept(this);
                }
            }
            return this;
        }

        public boolean isSuccessful() {
            switch (HttpStatusClass.valueOf(this.code)) {
                case INFORMATIONAL: 
                case SUCCESS: {
                    return true;
                }
            }
            return false;
        }
    }
}

