/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.context.internal.shaded;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

abstract class AbstractWeakConcurrentMap<K, V, L>
extends ReferenceQueue<K>
implements Iterable<Map.Entry<K, V>>,
Runnable {
    final ConcurrentMap<WeakKey<K>, V> target;

    protected AbstractWeakConcurrentMap() {
        this(new ConcurrentHashMap());
    }

    protected AbstractWeakConcurrentMap(ConcurrentMap<WeakKey<K>, V> concurrentMap) {
        this.target = concurrentMap;
    }

    protected abstract L getLookupKey(K var1);

    protected abstract void resetLookupKey(L var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K k2) {
        V v2;
        Object v3;
        if (k2 == null) {
            throw new NullPointerException();
        }
        L l2 = this.getLookupKey(k2);
        try {
            v3 = this.target.get(l2);
        }
        finally {
            this.resetLookupKey(l2);
        }
        if (v3 == null && (v3 = this.defaultValue(k2)) != null && (v2 = this.target.putIfAbsent(new WeakKey<K>(k2, this), v3)) != null) {
            v3 = v2;
        }
        return v3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getIfPresent(K k2) {
        if (k2 == null) {
            throw new NullPointerException();
        }
        L l2 = this.getLookupKey(k2);
        try {
            Object v2 = this.target.get(l2);
            return v2;
        }
        finally {
            this.resetLookupKey(l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(K k2) {
        if (k2 == null) {
            throw new NullPointerException();
        }
        L l2 = this.getLookupKey(k2);
        try {
            boolean bl2 = this.target.containsKey(l2);
            return bl2;
        }
        finally {
            this.resetLookupKey(l2);
        }
    }

    public V put(K k2, V v2) {
        if (k2 == null || v2 == null) {
            throw new NullPointerException();
        }
        return this.target.put(new WeakKey<K>(k2, this), v2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V putIfAbsent(K k2, V v2) {
        Object v3;
        if (k2 == null || v2 == null) {
            throw new NullPointerException();
        }
        L l2 = this.getLookupKey(k2);
        try {
            v3 = this.target.get(l2);
        }
        finally {
            this.resetLookupKey(l2);
        }
        return v3 == null ? this.target.putIfAbsent(new WeakKey<K>(k2, this), v2) : v3;
    }

    public V putIfProbablyAbsent(K k2, V v2) {
        if (k2 == null || v2 == null) {
            throw new NullPointerException();
        }
        return this.target.putIfAbsent(new WeakKey<K>(k2, this), v2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(K k2) {
        if (k2 == null) {
            throw new NullPointerException();
        }
        L l2 = this.getLookupKey(k2);
        try {
            Object v2 = this.target.remove(l2);
            return v2;
        }
        finally {
            this.resetLookupKey(l2);
        }
    }

    public void clear() {
        this.target.clear();
    }

    protected V defaultValue(K k2) {
        return null;
    }

    public void expungeStaleEntries() {
        Reference reference;
        while ((reference = this.poll()) != null) {
            this.target.remove(reference);
        }
    }

    public int approximateSize() {
        return this.target.size();
    }

    @Override
    public void run() {
        try {
            while (!Thread.interrupted()) {
                this.target.remove(this.remove());
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return new EntryIterator(this.target.entrySet().iterator());
    }

    public String toString() {
        return this.target.toString();
    }

    public static final class WeakKey<K>
    extends WeakReference<K> {
        private final int hashCode;

        WeakKey(K k2, ReferenceQueue<? super K> referenceQueue) {
            super(k2, referenceQueue);
            this.hashCode = System.identityHashCode(k2);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (object instanceof WeakKey) {
                return ((WeakKey)object).get() == this.get();
            }
            return object.equals(this);
        }

        public String toString() {
            return String.valueOf(this.get());
        }
    }

    private class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<WeakKey<K>, V>> iterator;
        private Map.Entry<WeakKey<K>, V> nextEntry;
        private K nextKey;

        private EntryIterator(Iterator<Map.Entry<WeakKey<K>, V>> iterator) {
            this.iterator = iterator;
            this.findNext();
        }

        private void findNext() {
            while (this.iterator.hasNext()) {
                this.nextEntry = this.iterator.next();
                this.nextKey = this.nextEntry.getKey().get();
                if (this.nextKey == null) continue;
                return;
            }
            this.nextEntry = null;
            this.nextKey = null;
        }

        @Override
        public boolean hasNext() {
            return this.nextKey != null;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.nextKey == null) {
                throw new NoSuchElementException();
            }
            try {
                SimpleEntry simpleEntry = new SimpleEntry(this.nextKey, this.nextEntry);
                return simpleEntry;
            }
            finally {
                this.findNext();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class SimpleEntry
    implements Map.Entry<K, V> {
        private final K key;
        final Map.Entry<WeakKey<K>, V> entry;

        private SimpleEntry(K k2, Map.Entry<WeakKey<K>, V> entry) {
            this.key = k2;
            this.entry = entry;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.entry.getValue();
        }

        @Override
        public V setValue(V v2) {
            if (v2 == null) {
                throw new NullPointerException();
            }
            return this.entry.setValue(v2);
        }
    }
}

