/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.exporter.otlp.http.logs;

import com.contrastsecurity.thirdparty.iot.api.internal.Utils;
import com.contrastsecurity.thirdparty.iot.api.metrics.MeterProvider;
import com.contrastsecurity.thirdparty.iot.exporter.internal.http.HttpExporterBuilder;
import com.contrastsecurity.thirdparty.iot.exporter.internal.otlp.logs.LogsRequestMarshaler;
import com.contrastsecurity.thirdparty.iot.exporter.otlp.http.logs.OtlpHttpLogRecordExporter;
import com.contrastsecurity.thirdparty.iot.exporter.otlp.internal.OtlpUserAgent;
import com.contrastsecurity.thirdparty.iot.sdk.common.export.RetryPolicy;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;

public final class OtlpHttpLogRecordExporterBuilder {
    private static final String DEFAULT_ENDPOINT = "http://localhost:4318/v1/logs";
    private final HttpExporterBuilder<LogsRequestMarshaler> delegate;

    OtlpHttpLogRecordExporterBuilder(HttpExporterBuilder<LogsRequestMarshaler> httpExporterBuilder) {
        this.delegate = httpExporterBuilder;
        OtlpUserAgent.addUserAgentHeader(httpExporterBuilder::addHeader);
    }

    OtlpHttpLogRecordExporterBuilder() {
        this(new HttpExporterBuilder<LogsRequestMarshaler>("otlp", "log", DEFAULT_ENDPOINT));
    }

    public OtlpHttpLogRecordExporterBuilder setTimeout(long l2, TimeUnit timeUnit) {
        Objects.requireNonNull(timeUnit, "unit");
        Utils.checkArgument(l2 >= 0L, "timeout must be non-negative");
        this.delegate.setTimeout(l2, timeUnit);
        return this;
    }

    public OtlpHttpLogRecordExporterBuilder setTimeout(Duration duration) {
        Objects.requireNonNull(duration, "timeout");
        return this.setTimeout(duration.toNanos(), TimeUnit.NANOSECONDS);
    }

    public OtlpHttpLogRecordExporterBuilder setEndpoint(String string) {
        Objects.requireNonNull(string, "endpoint");
        this.delegate.setEndpoint(string);
        return this;
    }

    public OtlpHttpLogRecordExporterBuilder setCompression(String string) {
        Objects.requireNonNull(string, "compressionMethod");
        Utils.checkArgument(string.equals("gzip") || string.equals("none"), "Unsupported compression method. Supported compression methods include: gzip, none.");
        this.delegate.setCompression(string);
        return this;
    }

    public OtlpHttpLogRecordExporterBuilder addHeader(String string, String string2) {
        this.delegate.addHeader(string, string2);
        return this;
    }

    public OtlpHttpLogRecordExporterBuilder setTrustedCertificates(byte[] byArray) {
        this.delegate.setTrustManagerFromCerts(byArray);
        return this;
    }

    public OtlpHttpLogRecordExporterBuilder setClientTls(byte[] byArray, byte[] byArray2) {
        this.delegate.setKeyManagerFromCerts(byArray, byArray2);
        return this;
    }

    public OtlpHttpLogRecordExporterBuilder setSslContext(SSLContext sSLContext, X509TrustManager x509TrustManager) {
        this.delegate.setSslContext(sSLContext, x509TrustManager);
        return this;
    }

    public OtlpHttpLogRecordExporterBuilder setRetryPolicy(RetryPolicy retryPolicy) {
        Objects.requireNonNull(retryPolicy, "retryPolicy");
        this.delegate.setRetryPolicy(retryPolicy);
        return this;
    }

    public OtlpHttpLogRecordExporterBuilder setMeterProvider(MeterProvider meterProvider) {
        Objects.requireNonNull(meterProvider, "meterProvider");
        this.delegate.setMeterProvider(meterProvider);
        return this;
    }

    public OtlpHttpLogRecordExporter build() {
        return new OtlpHttpLogRecordExporter(this.delegate, this.delegate.build());
    }
}

