/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.sdk.metrics;

import com.contrastsecurity.agent.logging.log4j2.e;
import com.contrastsecurity.thirdparty.iot.api.common.Attributes;
import com.contrastsecurity.thirdparty.iot.api.metrics.DoubleCounterBuilder;
import com.contrastsecurity.thirdparty.iot.api.metrics.LongCounter;
import com.contrastsecurity.thirdparty.iot.api.metrics.LongCounterBuilder;
import com.contrastsecurity.thirdparty.iot.api.metrics.ObservableLongCounter;
import com.contrastsecurity.thirdparty.iot.api.metrics.ObservableLongMeasurement;
import com.contrastsecurity.thirdparty.iot.context.Context;
import com.contrastsecurity.thirdparty.iot.sdk.internal.ThrottlingLogger;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.AbstractInstrument;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.AbstractInstrumentBuilder;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.InstrumentType;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.InstrumentValueType;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.SdkDoubleCounter;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.state.MeterProviderSharedState;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.state.MeterSharedState;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.state.WriteableMetricStorage;
import java.util.function.Consumer;

final class SdkLongCounter
extends AbstractInstrument
implements LongCounter {
    private static final e logger = e.a(SdkLongCounter.class.getName());
    private final ThrottlingLogger throttlingLogger = new ThrottlingLogger(logger);
    private final WriteableMetricStorage storage;

    private SdkLongCounter(InstrumentDescriptor instrumentDescriptor, WriteableMetricStorage writeableMetricStorage) {
        super(instrumentDescriptor);
        this.storage = writeableMetricStorage;
    }

    @Override
    public void add(long l2, Attributes attributes, Context context) {
        if (l2 < 0L) {
            this.throttlingLogger.log(e.a.c, "Counters can only increase. Instrument " + this.getDescriptor().getName() + " has recorded a negative value.");
            return;
        }
        this.storage.recordLong(l2, attributes, context);
    }

    @Override
    public void add(long l2, Attributes attributes) {
        this.add(l2, attributes, Context.current());
    }

    @Override
    public void add(long l2) {
        this.add(l2, Attributes.empty());
    }

    static final class SdkLongCounterBuilder
    extends AbstractInstrumentBuilder<SdkLongCounterBuilder>
    implements LongCounterBuilder {
        SdkLongCounterBuilder(MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, String string) {
            super(meterProviderSharedState, meterSharedState, InstrumentType.COUNTER, InstrumentValueType.LONG, string, "", "");
        }

        @Override
        protected SdkLongCounterBuilder getThis() {
            return this;
        }

        @Override
        public SdkLongCounter build() {
            return this.buildSynchronousInstrument((instrumentDescriptor, writeableMetricStorage) -> new SdkLongCounter((InstrumentDescriptor)instrumentDescriptor, (WriteableMetricStorage)writeableMetricStorage));
        }

        @Override
        public DoubleCounterBuilder ofDoubles() {
            return this.swapBuilder(SdkDoubleCounter.SdkDoubleCounterBuilder::new);
        }

        @Override
        public ObservableLongCounter buildWithCallback(Consumer<ObservableLongMeasurement> consumer) {
            return this.registerLongAsynchronousInstrument(InstrumentType.OBSERVABLE_COUNTER, consumer);
        }

        @Override
        public ObservableLongMeasurement buildObserver() {
            return this.buildObservableMeasurement(InstrumentType.OBSERVABLE_COUNTER);
        }
    }
}

