/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.sdk.trace;

import com.contrastsecurity.thirdparty.iot.context.Context;
import com.contrastsecurity.thirdparty.iot.sdk.common.CompletableResultCode;
import com.contrastsecurity.thirdparty.iot.sdk.trace.ReadWriteSpan;
import com.contrastsecurity.thirdparty.iot.sdk.trace.ReadableSpan;
import com.contrastsecurity.thirdparty.iot.sdk.trace.SpanProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

final class MultiSpanProcessor
implements SpanProcessor {
    private final List<SpanProcessor> spanProcessorsStart;
    private final List<SpanProcessor> spanProcessorsEnd;
    private final List<SpanProcessor> spanProcessorsAll;
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);

    static SpanProcessor create(List<SpanProcessor> list) {
        return new MultiSpanProcessor(new ArrayList<SpanProcessor>((Collection)Objects.requireNonNull(list, "spanProcessorList")));
    }

    @Override
    public void onStart(Context context, ReadWriteSpan readWriteSpan) {
        for (SpanProcessor spanProcessor : this.spanProcessorsStart) {
            spanProcessor.onStart(context, readWriteSpan);
        }
    }

    @Override
    public boolean isStartRequired() {
        return !this.spanProcessorsStart.isEmpty();
    }

    @Override
    public void onEnd(ReadableSpan readableSpan) {
        for (SpanProcessor spanProcessor : this.spanProcessorsEnd) {
            spanProcessor.onEnd(readableSpan);
        }
    }

    @Override
    public boolean isEndRequired() {
        return !this.spanProcessorsEnd.isEmpty();
    }

    @Override
    public CompletableResultCode shutdown() {
        if (this.isShutdown.getAndSet(true)) {
            return CompletableResultCode.ofSuccess();
        }
        ArrayList<CompletableResultCode> arrayList = new ArrayList<CompletableResultCode>(this.spanProcessorsAll.size());
        for (SpanProcessor spanProcessor : this.spanProcessorsAll) {
            arrayList.add(spanProcessor.shutdown());
        }
        return CompletableResultCode.ofAll(arrayList);
    }

    @Override
    public CompletableResultCode forceFlush() {
        ArrayList<CompletableResultCode> arrayList = new ArrayList<CompletableResultCode>(this.spanProcessorsAll.size());
        for (SpanProcessor spanProcessor : this.spanProcessorsAll) {
            arrayList.add(spanProcessor.forceFlush());
        }
        return CompletableResultCode.ofAll(arrayList);
    }

    private MultiSpanProcessor(List<SpanProcessor> list) {
        this.spanProcessorsAll = list;
        this.spanProcessorsStart = new ArrayList<SpanProcessor>(this.spanProcessorsAll.size());
        this.spanProcessorsEnd = new ArrayList<SpanProcessor>(this.spanProcessorsAll.size());
        for (SpanProcessor spanProcessor : this.spanProcessorsAll) {
            if (spanProcessor.isStartRequired()) {
                this.spanProcessorsStart.add(spanProcessor);
            }
            if (!spanProcessor.isEndRequired()) continue;
            this.spanProcessorsEnd.add(spanProcessor);
        }
    }

    public String toString() {
        return "MultiSpanProcessor{spanProcessorsStart=" + this.spanProcessorsStart + ", spanProcessorsEnd=" + this.spanProcessorsEnd + ", spanProcessorsAll=" + this.spanProcessorsAll + '}';
    }
}

