/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.nn3nx;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.nn3nx.IXMLEntityResolver;
import com.contrastsecurity.thirdparty.nn3nx.IXMLReader;
import com.contrastsecurity.thirdparty.nn3nx.XMLParseException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Hashtable;

public class XMLEntityResolver
implements IXMLEntityResolver {
    private Hashtable entities = new Hashtable();

    public XMLEntityResolver() {
        this.entities.put("amp", "&#38;");
        this.entities.put("quot", "&#34;");
        this.entities.put("apos", "&#39;");
        this.entities.put("lt", "&#60;");
        this.entities.put("gt", "&#62;");
    }

    @Override
    public void addInternalEntity(String string, String string2) {
        if (!this.entities.containsKey(string)) {
            this.entities.put(string, string2);
        }
    }

    @Override
    public void addExternalEntity(String string, String string2, String string3) {
        if (!this.entities.containsKey(string)) {
            this.entities.put(string, new String[]{string2, string3});
        }
    }

    @Override
    public Reader getEntity(IXMLReader iXMLReader, String string) throws XMLParseException {
        Object v2 = this.entities.get(string);
        if (v2 == null) {
            return null;
        }
        if (v2 instanceof String) {
            return new StringReader((String)v2);
        }
        String[] stringArray = (String[])v2;
        return this.openExternalEntity(iXMLReader, stringArray[0], stringArray[1]);
    }

    @Override
    public boolean isExternalEntity(String string) {
        Object v2 = this.entities.get(string);
        return !(v2 instanceof String);
    }

    protected Reader openExternalEntity(IXMLReader iXMLReader, String string, String string2) throws XMLParseException {
        String string3 = iXMLReader.getSystemID();
        try {
            return iXMLReader.openStream(string, string2);
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            throw new XMLParseException(string3, iXMLReader.getLineNr(), "Could not open external entity at system ID: " + string2);
        }
    }
}

