/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.nsjsqlp.util.deparser;

import com.contrastsecurity.thirdparty.nsjsqlp.expression.Expression;
import com.contrastsecurity.thirdparty.nsjsqlp.expression.ExpressionVisitor;
import com.contrastsecurity.thirdparty.nsjsqlp.expression.operators.relational.ExpressionList;
import com.contrastsecurity.thirdparty.nsjsqlp.expression.operators.relational.ItemsListVisitor;
import com.contrastsecurity.thirdparty.nsjsqlp.expression.operators.relational.MultiExpressionList;
import com.contrastsecurity.thirdparty.nsjsqlp.schema.Column;
import com.contrastsecurity.thirdparty.nsjsqlp.statement.insert.Insert;
import com.contrastsecurity.thirdparty.nsjsqlp.statement.select.SelectExpressionItem;
import com.contrastsecurity.thirdparty.nsjsqlp.statement.select.SelectVisitor;
import com.contrastsecurity.thirdparty.nsjsqlp.statement.select.SubSelect;
import com.contrastsecurity.thirdparty.nsjsqlp.statement.select.WithItem;
import java.util.Iterator;

public class InsertDeParser
implements ItemsListVisitor {
    private StringBuilder buffer;
    private ExpressionVisitor expressionVisitor;
    private SelectVisitor selectVisitor;

    public InsertDeParser() {
    }

    public InsertDeParser(ExpressionVisitor expressionVisitor, SelectVisitor selectVisitor, StringBuilder stringBuilder) {
        this.buffer = stringBuilder;
        this.expressionVisitor = expressionVisitor;
        this.selectVisitor = selectVisitor;
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    public void setBuffer(StringBuilder stringBuilder) {
        this.buffer = stringBuilder;
    }

    public void deParse(Insert insert) {
        this.buffer.append("INSERT ");
        if (insert.getModifierPriority() != null) {
            this.buffer.append((Object)insert.getModifierPriority()).append(" ");
        }
        if (insert.isModifierIgnore()) {
            this.buffer.append("IGNORE ");
        }
        this.buffer.append("INTO ");
        this.buffer.append(insert.getTable().getFullyQualifiedName());
        if (insert.getColumns() != null) {
            this.buffer.append(" (");
            Iterator<Object> iterator = insert.getColumns().iterator();
            while (iterator.hasNext()) {
                Column object2 = iterator.next();
                this.buffer.append(object2.getColumnName());
                if (!iterator.hasNext()) continue;
                this.buffer.append(", ");
            }
            this.buffer.append(")");
        }
        if (insert.getItemsList() != null) {
            insert.getItemsList().accept(this);
        }
        if (insert.getSelect() != null) {
            this.buffer.append(" ");
            if (insert.isUseSelectBrackets()) {
                this.buffer.append("(");
            }
            if (insert.getSelect().getWithItemsList() != null) {
                this.buffer.append("WITH ");
                for (WithItem withItem : insert.getSelect().getWithItemsList()) {
                    withItem.accept(this.selectVisitor);
                }
                this.buffer.append(" ");
            }
            insert.getSelect().getSelectBody().accept(this.selectVisitor);
            if (insert.isUseSelectBrackets()) {
                this.buffer.append(")");
            }
        }
        if (insert.isUseDuplicate()) {
            this.buffer.append(" ON DUPLICATE KEY UPDATE ");
            for (int i2 = 0; i2 < insert.getDuplicateUpdateColumns().size(); ++i2) {
                Column column = insert.getDuplicateUpdateColumns().get(i2);
                this.buffer.append(column.getFullyQualifiedName()).append(" = ");
                Expression expression = insert.getDuplicateUpdateExpressionList().get(i2);
                expression.accept(this.expressionVisitor);
                if (i2 >= insert.getDuplicateUpdateColumns().size() - 1) continue;
                this.buffer.append(", ");
            }
        }
        if (insert.isReturningAllColumns()) {
            this.buffer.append(" RETURNING *");
        } else if (insert.getReturningExpressionList() != null) {
            this.buffer.append(" RETURNING ");
            Iterator<SelectExpressionItem> iterator = insert.getReturningExpressionList().iterator();
            while (iterator.hasNext()) {
                this.buffer.append(iterator.next().toString());
                if (!iterator.hasNext()) continue;
                this.buffer.append(", ");
            }
        }
    }

    @Override
    public void visit(ExpressionList expressionList) {
        this.buffer.append(" VALUES (");
        Iterator<Expression> iterator = expressionList.getExpressions().iterator();
        while (iterator.hasNext()) {
            Expression expression = iterator.next();
            expression.accept(this.expressionVisitor);
            if (!iterator.hasNext()) continue;
            this.buffer.append(", ");
        }
        this.buffer.append(")");
    }

    @Override
    public void visit(MultiExpressionList multiExpressionList) {
        this.buffer.append(" VALUES ");
        Iterator<ExpressionList> iterator = multiExpressionList.getExprList().iterator();
        while (iterator.hasNext()) {
            this.buffer.append("(");
            Iterator<Expression> iterator2 = iterator.next().getExpressions().iterator();
            while (iterator2.hasNext()) {
                Expression expression = iterator2.next();
                expression.accept(this.expressionVisitor);
                if (!iterator2.hasNext()) continue;
                this.buffer.append(", ");
            }
            this.buffer.append(")");
            if (!iterator.hasNext()) continue;
            this.buffer.append(", ");
        }
    }

    @Override
    public void visit(SubSelect subSelect) {
        subSelect.getSelectBody().accept(this.selectVisitor);
    }

    public ExpressionVisitor getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public SelectVisitor getSelectVisitor() {
        return this.selectVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor expressionVisitor) {
        this.expressionVisitor = expressionVisitor;
    }

    public void setSelectVisitor(SelectVisitor selectVisitor) {
        this.selectVisitor = selectVisitor;
    }
}

