/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.commons.codec.binary;

import com.contrastsecurity.thirdparty.oa4j.commons.codec.BinaryDecoder;
import com.contrastsecurity.thirdparty.oa4j.commons.codec.BinaryEncoder;
import com.contrastsecurity.thirdparty.oa4j.commons.codec.CodecPolicy;
import com.contrastsecurity.thirdparty.oa4j.commons.codec.DecoderException;
import com.contrastsecurity.thirdparty.oa4j.commons.codec.EncoderException;
import com.contrastsecurity.thirdparty.oa4j.commons.codec.binary.StringUtils;
import java.util.Arrays;
import java.util.Objects;

public abstract class BaseNCodec
implements BinaryDecoder,
BinaryEncoder {
    static final int EOF = -1;
    public static final int MIME_CHUNK_SIZE = 76;
    public static final int PEM_CHUNK_SIZE = 64;
    private static final int DEFAULT_BUFFER_RESIZE_FACTOR = 2;
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final int MAX_BUFFER_SIZE = 0x7FFFFFF7;
    protected static final int MASK_8BITS = 255;
    protected static final byte PAD_DEFAULT = 61;
    protected static final CodecPolicy DECODING_POLICY_DEFAULT = CodecPolicy.LENIENT;
    static final byte[] CHUNK_SEPARATOR = new byte[]{13, 10};
    @Deprecated
    protected final byte PAD = (byte)61;
    protected final byte pad;
    private final int unencodedBlockSize;
    private final int encodedBlockSize;
    protected final int lineLength;
    private final int chunkSeparatorLength;
    private final CodecPolicy decodingPolicy;

    private static int compareUnsigned(int n2, int n3) {
        return Integer.compare(n2 + Integer.MIN_VALUE, n3 + Integer.MIN_VALUE);
    }

    private static int createPositiveCapacity(int n2) {
        if (n2 < 0) {
            throw new OutOfMemoryError("Unable to allocate array size: " + ((long)n2 & 0xFFFFFFFFL));
        }
        return n2 > 0x7FFFFFF7 ? n2 : 0x7FFFFFF7;
    }

    public static byte[] getChunkSeparator() {
        return (byte[])CHUNK_SEPARATOR.clone();
    }

    protected static boolean isWhiteSpace(byte by) {
        switch (by) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    private static byte[] resizeBuffer(Context context, int n2) {
        int n3 = context.buffer.length;
        int n4 = n3 * 2;
        if (BaseNCodec.compareUnsigned(n4, n2) < 0) {
            n4 = n2;
        }
        if (BaseNCodec.compareUnsigned(n4, 0x7FFFFFF7) > 0) {
            n4 = BaseNCodec.createPositiveCapacity(n2);
        }
        byte[] byArray = new byte[n4];
        System.arraycopy(context.buffer, 0, byArray, 0, context.buffer.length);
        context.buffer = byArray;
        return byArray;
    }

    protected BaseNCodec(int n2, int n3, int n4, int n5) {
        this(n2, n3, n4, n5, 61);
    }

    protected BaseNCodec(int n2, int n3, int n4, int n5, byte by) {
        this(n2, n3, n4, n5, by, DECODING_POLICY_DEFAULT);
    }

    protected BaseNCodec(int n2, int n3, int n4, int n5, byte by, CodecPolicy codecPolicy) {
        this.unencodedBlockSize = n2;
        this.encodedBlockSize = n3;
        boolean bl2 = n4 > 0 && n5 > 0;
        this.lineLength = bl2 ? n4 / n3 * n3 : 0;
        this.chunkSeparatorLength = n5;
        this.pad = by;
        this.decodingPolicy = Objects.requireNonNull(codecPolicy, "codecPolicy");
    }

    int available(Context context) {
        return context.buffer != null ? context.pos - context.readPos : 0;
    }

    protected boolean containsAlphabetOrPad(byte[] byArray) {
        if (byArray == null) {
            return false;
        }
        for (byte by : byArray) {
            if (this.pad != by && !this.isInAlphabet(by)) continue;
            return true;
        }
        return false;
    }

    @Override
    public byte[] decode(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return byArray;
        }
        Context context = new Context();
        this.decode(byArray, 0, byArray.length, context);
        this.decode(byArray, 0, -1, context);
        byte[] byArray2 = new byte[context.pos];
        this.readResults(byArray2, 0, byArray2.length, context);
        return byArray2;
    }

    abstract void decode(byte[] var1, int var2, int var3, Context var4);

    @Override
    public Object decode(Object object) throws DecoderException {
        if (object instanceof byte[]) {
            return this.decode((byte[])object);
        }
        if (object instanceof String) {
            return this.decode((String)object);
        }
        throw new DecoderException("Parameter supplied to Base-N decode is not a byte[] or a String");
    }

    public byte[] decode(String string) {
        return this.decode(StringUtils.getBytesUtf8(string));
    }

    @Override
    public byte[] encode(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return byArray;
        }
        return this.encode(byArray, 0, byArray.length);
    }

    public byte[] encode(byte[] byArray, int n2, int n3) {
        if (byArray == null || byArray.length == 0) {
            return byArray;
        }
        Context context = new Context();
        this.encode(byArray, n2, n3, context);
        this.encode(byArray, n2, -1, context);
        byte[] byArray2 = new byte[context.pos - context.readPos];
        this.readResults(byArray2, 0, byArray2.length, context);
        return byArray2;
    }

    abstract void encode(byte[] var1, int var2, int var3, Context var4);

    @Override
    public Object encode(Object object) throws EncoderException {
        if (!(object instanceof byte[])) {
            throw new EncoderException("Parameter supplied to Base-N encode is not a byte[]");
        }
        return this.encode((byte[])object);
    }

    public String encodeAsString(byte[] byArray) {
        return StringUtils.newStringUtf8(this.encode(byArray));
    }

    public String encodeToString(byte[] byArray) {
        return StringUtils.newStringUtf8(this.encode(byArray));
    }

    protected byte[] ensureBufferSize(int n2, Context context) {
        if (context.buffer == null) {
            context.buffer = new byte[Math.max(n2, this.getDefaultBufferSize())];
            context.pos = 0;
            context.readPos = 0;
        } else if (context.pos + n2 - context.buffer.length > 0) {
            return BaseNCodec.resizeBuffer(context, context.pos + n2);
        }
        return context.buffer;
    }

    public CodecPolicy getCodecPolicy() {
        return this.decodingPolicy;
    }

    protected int getDefaultBufferSize() {
        return 8192;
    }

    public long getEncodedLength(byte[] byArray) {
        long l2 = (long)((byArray.length + this.unencodedBlockSize - 1) / this.unencodedBlockSize) * (long)this.encodedBlockSize;
        if (this.lineLength > 0) {
            l2 += (l2 + (long)this.lineLength - 1L) / (long)this.lineLength * (long)this.chunkSeparatorLength;
        }
        return l2;
    }

    boolean hasData(Context context) {
        return context.buffer != null;
    }

    protected abstract boolean isInAlphabet(byte var1);

    public boolean isInAlphabet(byte[] byArray, boolean bl2) {
        for (byte by : byArray) {
            if (this.isInAlphabet(by) || bl2 && (by == this.pad || BaseNCodec.isWhiteSpace(by))) continue;
            return false;
        }
        return true;
    }

    public boolean isInAlphabet(String string) {
        return this.isInAlphabet(StringUtils.getBytesUtf8(string), true);
    }

    public boolean isStrictDecoding() {
        return this.decodingPolicy == CodecPolicy.STRICT;
    }

    int readResults(byte[] byArray, int n2, int n3, Context context) {
        if (context.buffer != null) {
            int n4 = Math.min(this.available(context), n3);
            System.arraycopy(context.buffer, context.readPos, byArray, n2, n4);
            context.readPos += n4;
            if (context.readPos >= context.pos) {
                context.buffer = null;
            }
            return n4;
        }
        return context.eof ? -1 : 0;
    }

    static class Context {
        int ibitWorkArea;
        long lbitWorkArea;
        byte[] buffer;
        int pos;
        int readPos;
        boolean eof;
        int currentLinePos;
        int modulus;

        Context() {
        }

        public String toString() {
            return String.format("%s[buffer=%s, currentLinePos=%s, eof=%s, ibitWorkArea=%s, lbitWorkArea=%s, modulus=%s, pos=%s, readPos=%s]", this.getClass().getSimpleName(), Arrays.toString(this.buffer), this.currentLinePos, this.eof, this.ibitWorkArea, this.lbitWorkArea, this.modulus, this.pos, this.readPos);
        }
    }
}

