/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.http.impl.conn;

import com.contrastsecurity.thirdparty.oa4j.commons.logging.Log;
import com.contrastsecurity.thirdparty.oa4j.commons.logging.LogFactory;
import com.contrastsecurity.thirdparty.oa4j.http.annotation.Contract;
import com.contrastsecurity.thirdparty.oa4j.http.annotation.ThreadingBehavior;
import com.contrastsecurity.thirdparty.oa4j.http.conn.ManagedHttpClientConnection;
import com.contrastsecurity.thirdparty.oa4j.http.conn.routing.HttpRoute;
import com.contrastsecurity.thirdparty.oa4j.http.impl.conn.CPoolEntry;
import com.contrastsecurity.thirdparty.oa4j.http.pool.AbstractConnPool;
import com.contrastsecurity.thirdparty.oa4j.http.pool.ConnFactory;
import com.contrastsecurity.thirdparty.oa4j.http.pool.PoolEntryCallback;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

@Contract(threading=ThreadingBehavior.SAFE)
class CPool
extends AbstractConnPool<HttpRoute, ManagedHttpClientConnection, CPoolEntry> {
    private static final AtomicLong COUNTER = new AtomicLong();
    private final Log log = LogFactory.getLog(CPool.class);
    private final long timeToLive;
    private final TimeUnit timeUnit;

    public CPool(ConnFactory<HttpRoute, ManagedHttpClientConnection> connFactory, int n2, int n3, long l2, TimeUnit timeUnit) {
        super(connFactory, n2, n3);
        this.timeToLive = l2;
        this.timeUnit = timeUnit;
    }

    @Override
    protected CPoolEntry createEntry(HttpRoute httpRoute, ManagedHttpClientConnection managedHttpClientConnection) {
        String string = Long.toString(COUNTER.getAndIncrement());
        return new CPoolEntry(this.log, string, httpRoute, managedHttpClientConnection, this.timeToLive, this.timeUnit);
    }

    @Override
    protected boolean validate(CPoolEntry cPoolEntry) {
        return !((ManagedHttpClientConnection)cPoolEntry.getConnection()).isStale();
    }

    @Override
    protected void enumAvailable(PoolEntryCallback<HttpRoute, ManagedHttpClientConnection> poolEntryCallback) {
        super.enumAvailable(poolEntryCallback);
    }

    @Override
    protected void enumLeased(PoolEntryCallback<HttpRoute, ManagedHttpClientConnection> poolEntryCallback) {
        super.enumLeased(poolEntryCallback);
    }
}

