/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.http.impl.entity;

import com.contrastsecurity.thirdparty.oa4j.http.Header;
import com.contrastsecurity.thirdparty.oa4j.http.HttpException;
import com.contrastsecurity.thirdparty.oa4j.http.HttpMessage;
import com.contrastsecurity.thirdparty.oa4j.http.HttpVersion;
import com.contrastsecurity.thirdparty.oa4j.http.ProtocolException;
import com.contrastsecurity.thirdparty.oa4j.http.annotation.Contract;
import com.contrastsecurity.thirdparty.oa4j.http.annotation.ThreadingBehavior;
import com.contrastsecurity.thirdparty.oa4j.http.entity.ContentLengthStrategy;
import com.contrastsecurity.thirdparty.oa4j.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class StrictContentLengthStrategy
implements ContentLengthStrategy {
    public static final StrictContentLengthStrategy INSTANCE = new StrictContentLengthStrategy();
    private final int implicitLen;

    public StrictContentLengthStrategy(int n2) {
        this.implicitLen = n2;
    }

    public StrictContentLengthStrategy() {
        this(-1);
    }

    @Override
    public long determineLength(HttpMessage httpMessage) throws HttpException {
        Args.notNull(httpMessage, "HTTP message");
        Header header = httpMessage.getFirstHeader("Transfer-Encoding");
        if (header != null) {
            String string = header.getValue();
            if ("chunked".equalsIgnoreCase(string)) {
                if (httpMessage.getProtocolVersion().lessEquals(HttpVersion.HTTP_1_0)) {
                    throw new ProtocolException("Chunked transfer encoding not allowed for " + httpMessage.getProtocolVersion());
                }
                return -2L;
            }
            if ("identity".equalsIgnoreCase(string)) {
                return -1L;
            }
            throw new ProtocolException("Unsupported transfer encoding: " + string);
        }
        Header header2 = httpMessage.getFirstHeader("Content-Length");
        if (header2 != null) {
            String string = header2.getValue();
            try {
                long l2 = Long.parseLong(string);
                if (l2 < 0L) {
                    throw new ProtocolException("Negative content length: " + string);
                }
                return l2;
            }
            catch (NumberFormatException numberFormatException) {
                throw new ProtocolException("Invalid content length: " + string);
            }
        }
        return this.implicitLen;
    }
}

